/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameInScopeItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SynchronizedCollectConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultChooseByNameItemProvider
implements ChooseByNameInScopeItemProvider {
    private static final Logger LOG = Logger.getInstance(DefaultChooseByNameItemProvider.class);
    private static final String UNIVERSAL_SEPARATOR = "\u0000";
    private final SmartPsiElementPointer<PsiElement> myContext;

    public DefaultChooseByNameItemProvider(@Nullable PsiElement context) {
        this.myContext = context == null ? null : SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(context);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer2) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(1);
        }
        if (cancelled == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(2);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(3);
        }
        return this.filterElements((ChooseByNameViewModel)base, pattern, everywhere, cancelled, consumer2);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer2) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(6);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(7);
        }
        return this.filterElementsWithWeights(base, DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere), indicator, res2 -> consumer2.process(res2.getItem()));
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer2) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(8);
        }
        if (parameters2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(10);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(11);
        }
        return this.filterElements((ChooseByNameViewModel)base, parameters2, indicator, consumer2);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer2) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(12);
        }
        if (parameters2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(14);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(15);
        }
        return this.filterElementsWithWeights(base, parameters2, indicator, res2 -> consumer2.process(res2.getItem()));
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(16);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(18);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(19);
        }
        return this.filterElementsWithWeights((ChooseByNameViewModel)base, pattern, everywhere, indicator, consumer2);
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(20);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(22);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(23);
        }
        return this.filterElementsWithWeights(base, DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere), indicator, consumer2);
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(24);
        }
        if (parameters2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(25);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(26);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(27);
        }
        return this.filterElementsWithWeights((ChooseByNameViewModel)base, parameters2, indicator, consumer2);
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(28);
        }
        if (parameters2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(29);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(30);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(31);
        }
        return (Boolean)ProgressManager.getInstance().computePrioritized(() -> DefaultChooseByNameItemProvider.filterElements(base, indicator, this.myContext == null ? null : this.myContext.getElement(), () -> base.getModel().getNames(parameters2.isSearchInLibraries()), consumer2, parameters2));
    }

    public static boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @Nullable PsiElement context, @NotNull Processor<Object> consumer2) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(32);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(33);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(34);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(35);
        }
        return DefaultChooseByNameItemProvider.filterElements(base, indicator, context, null, res2 -> consumer2.process(res2.getItem()), DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere));
    }

    private static boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull ProgressIndicator indicator, @Nullable PsiElement context, @Nullable Supplier<String[]> allNamesProducer, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2, @NotNull FindSymbolParameters parameters2) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(36);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(37);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(38);
        }
        if (parameters2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(39);
        }
        boolean everywhere = parameters2.isSearchInLibraries();
        String pattern = parameters2.getCompletePattern();
        if (base.getProject() != null) {
            base.getProject().putUserData(ChooseByNamePopup.CURRENT_SEARCH_PATTERN, (Object)pattern);
        }
        String namePattern = DefaultChooseByNameItemProvider.getNamePattern(base, pattern);
        boolean preferStartMatches = !pattern.startsWith("*");
        List<MatchResult> namesList = DefaultChooseByNameItemProvider.getSortedNamesForAllWildcards(base, parameters2, indicator, allNamesProducer, namePattern, preferStartMatches);
        indicator.checkCanceled();
        return DefaultChooseByNameItemProvider.processByNames(base, everywhere, indicator, context, consumer2, namesList, parameters2);
    }

    @NotNull
    private static List<MatchResult> getSortedNamesForAllWildcards(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, String namePattern, boolean preferStartMatches) {
        String matchingPattern;
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(40);
        }
        if (parameters2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(41);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(42);
        }
        if ((matchingPattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern)).isEmpty() && !base.canShowListForEmptyPattern()) {
            List<MatchResult> list2 = Collections.emptyList();
            if (list2 == null) {
                DefaultChooseByNameItemProvider.$$$reportNull$$$0(43);
            }
            return list2;
        }
        List<MatchResult> result2 = DefaultChooseByNameItemProvider.getSortedNames(base, parameters2, indicator, allNamesProducer, matchingPattern, preferStartMatches);
        if (!namePattern.contains("*")) {
            List<MatchResult> list3 = result2;
            if (list3 == null) {
                DefaultChooseByNameItemProvider.$$$reportNull$$$0(44);
            }
            return list3;
        }
        HashSet<String> allNames = new HashSet<String>(ContainerUtil.map(result2, mr -> mr.elementName));
        for (int i2 = 1; i2 < namePattern.length() - 1; ++i2) {
            if (namePattern.charAt(i2) != '*') continue;
            List<MatchResult> namesForSuffix = DefaultChooseByNameItemProvider.getSortedNames(base, parameters2, indicator, allNamesProducer, DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern.substring(i2 + 1)), preferStartMatches);
            for (MatchResult mr2 : namesForSuffix) {
                if (!allNames.add(mr2.elementName)) continue;
                result2.add(mr2);
            }
        }
        List<MatchResult> list4 = result2;
        if (list4 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(45);
        }
        return list4;
    }

    @NotNull
    private static List<MatchResult> getSortedNames(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, String namePattern, boolean preferStartMatches) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(46);
        }
        if (parameters2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(47);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(48);
        }
        List<MatchResult> namesList = DefaultChooseByNameItemProvider.getAllNames(base, parameters2, indicator, allNamesProducer, namePattern, preferStartMatches);
        indicator.checkCanceled();
        String pattern = parameters2.getCompletePattern();
        long started = System.currentTimeMillis();
        namesList.sort(Comparator.comparing(mr -> !pattern.equalsIgnoreCase(mr.elementName)).thenComparing(mr -> !namePattern.equalsIgnoreCase(mr.elementName)).thenComparing(Comparator.naturalOrder()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorted:" + (System.currentTimeMillis() - started) + ",results:" + namesList.size());
        }
        List<MatchResult> list2 = namesList;
        if (list2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(49);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static List<MatchResult> getAllNames(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, @NotNull String namePattern, boolean preferStartMatches) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(50);
        }
        if (parameters2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(51);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(52);
        }
        if (namePattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(53);
        }
        ArrayList namesList = new ArrayList();
        SynchronizedCollectConsumer collect2 = new SynchronizedCollectConsumer(namesList);
        ChooseByNameModel model2 = base.getModel();
        if (model2 instanceof ChooseByNameModelEx) {
            indicator.checkCanceled();
            long started = System.currentTimeMillis();
            String fullPattern = parameters2.getCompletePattern();
            MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(namePattern, preferStartMatches);
            ((ChooseByNameModelEx)model2).processNames((Processor<? super String>)((Processor)arg_0 -> DefaultChooseByNameItemProvider.lambda$getAllNames$8(indicator, base, fullPattern, matcher, (CollectConsumer)collect2, arg_0)), parameters2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("loaded + matched:" + (System.currentTimeMillis() - started) + "," + collect2.getResult().size());
            }
        } else {
            if (allNamesProducer == null) {
                throw new IllegalArgumentException("Need to specify allNamesProducer when using a model which isn't a ChooseByNameModelEx");
            }
            String[] names2 = allNamesProducer.get();
            long started = System.currentTimeMillis();
            DefaultChooseByNameItemProvider.processNamesByPattern(base, names2, namePattern, indicator, (Consumer<? super MatchResult>)collect2, preferStartMatches);
            if (LOG.isDebugEnabled()) {
                LOG.debug("matched:" + (System.currentTimeMillis() - started) + "," + names2.length);
            }
        }
        SynchronizedCollectConsumer synchronizedCollectConsumer = collect2;
        // MONITORENTER : synchronizedCollectConsumer
        ArrayList<MatchResult> arrayList = new ArrayList<MatchResult>(namesList);
        // MONITOREXIT : synchronizedCollectConsumer
        if (arrayList != null) return arrayList;
        DefaultChooseByNameItemProvider.$$$reportNull$$$0(54);
        return arrayList;
    }

    @NotNull
    private static FindSymbolParameters createParameters(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere) {
        ChooseByNameModel model2;
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(55);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(56);
        }
        IdFilter idFilter = (model2 = base.getModel()) instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model2).getIdFilter(everywhere) : null;
        GlobalSearchScope searchScope2 = FindSymbolParameters.searchScopeFor(base.getProject(), everywhere);
        return new FindSymbolParameters(pattern, DefaultChooseByNameItemProvider.getNamePattern(base, pattern), searchScope2, idFilter);
    }

    private static boolean processByNames(@NotNull ChooseByNameViewModel base, boolean everywhere, @NotNull ProgressIndicator indicator, final @Nullable PsiElement context, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2, @NotNull List<? extends MatchResult> namesList, @NotNull FindSymbolParameters parameters2) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(57);
        }
        if (indicator == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(58);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(59);
        }
        if (namesList == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(60);
        }
        if (parameters2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(61);
        }
        SmartList sameNameElements = new SmartList();
        final ChooseByNameModel model2 = base.getModel();
        Comparator<Pair<Object, MatchResult>> weightComparator = new Comparator<Pair<Object, MatchResult>>(){
            final Comparator<Object> modelComparator;
            {
                this.modelComparator = model2 instanceof Comparator ? (Comparator)model2 : new PathProximityComparator(context);
            }

            @Override
            public int compare(Pair<Object, MatchResult> o1, Pair<Object, MatchResult> o2) {
                int result2 = this.modelComparator.compare(o1.first, o2.first);
                return result2 != 0 ? result2 : ((MatchResult)o1.second).compareTo((MatchResult)o2.second);
            }
        };
        MinusculeMatcher fullMatcher = DefaultChooseByNameItemProvider.getFullMatcher(parameters2, base);
        for (MatchResult matchResult : namesList) {
            Object[] elements2;
            indicator.checkCanceled();
            String name = matchResult.elementName;
            Object[] objectArray = elements2 = model2 instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model2).getElementsByName(name, parameters2, indicator) : model2.getElementsByName(name, everywhere, DefaultChooseByNameItemProvider.getNamePattern(base, parameters2.getCompletePattern()));
            if (elements2.length > 1) {
                sameNameElements.clear();
                for (Object element2 : elements2) {
                    indicator.checkCanceled();
                    MatchResult qualifiedResult = DefaultChooseByNameItemProvider.matchQualifiedName(model2, fullMatcher, element2);
                    if (qualifiedResult == null) continue;
                    sameNameElements.add(Pair.create((Object)element2, (Object)qualifiedResult));
                }
                sameNameElements.sort(weightComparator);
                List processedItems = ContainerUtil.map((Collection)sameNameElements, p -> new FoundItemDescriptor(p.first, result2.matchingDegree));
                if (ContainerUtil.process((List)processedItems, consumer2)) continue;
                return false;
            }
            if (elements2.length != 1 || DefaultChooseByNameItemProvider.matchQualifiedName(model2, fullMatcher, elements2[0]) == null || consumer2.process((Object)new FoundItemDescriptor(elements2[0], matchResult.matchingDegree))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected PathProximityComparator getPathProximityComparator() {
        return new PathProximityComparator(this.myContext == null ? null : this.myContext.getElement());
    }

    @NotNull
    private static MinusculeMatcher getFullMatcher(@NotNull FindSymbolParameters parameters2, @NotNull ChooseByNameViewModel base) {
        if (parameters2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(62);
        }
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(63);
        }
        String fullRawPattern = DefaultChooseByNameItemProvider.buildFullPattern(base, parameters2.getCompletePattern());
        String fullNamePattern = DefaultChooseByNameItemProvider.buildFullPattern(base, base.transformPattern(parameters2.getCompletePattern()));
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcherWithFallback((String)fullRawPattern, (String)fullNamePattern, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        if (minusculeMatcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(64);
        }
        return minusculeMatcher;
    }

    @NotNull
    private static String buildFullPattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(65);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(66);
        }
        Object fullPattern = "*" + DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern);
        for (String separator : base.getModel().getSeparators()) {
            fullPattern = StringUtil.replace((String)fullPattern, (String)separator, (String)"*\u0000*");
        }
        String string = fullPattern;
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(67);
        }
        return string;
    }

    @NotNull
    private static String getNamePattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(68);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(69);
        }
        String transformedPattern = base.transformPattern(pattern);
        return DefaultChooseByNameItemProvider.getNamePattern(base.getModel(), transformedPattern);
    }

    @NotNull
    private static String getNamePattern(@NotNull ChooseByNameModel model2, @NotNull String pattern) {
        if (model2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(70);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(71);
        }
        String[] separators = model2.getSeparators();
        int lastSeparatorOccurrence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            if (idx == pattern.length() - 1) {
                idx = pattern.lastIndexOf(separator, idx - 1);
            }
            lastSeparatorOccurrence = Math.max(lastSeparatorOccurrence, idx == -1 ? idx : idx + separator.length());
        }
        String string = pattern.substring(lastSeparatorOccurrence);
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(72);
        }
        return string;
    }

    @Nullable
    private static MatchResult matchQualifiedName(@NotNull ChooseByNameModel model2, @NotNull MinusculeMatcher fullMatcher, @NotNull Object element2) {
        String fullName;
        if (model2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(73);
        }
        if (fullMatcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(74);
        }
        if (element2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(75);
        }
        if ((fullName = model2.getFullName(element2)) == null) {
            return null;
        }
        for (String separator : model2.getSeparators()) {
            fullName = StringUtil.replace((String)fullName, (String)separator, (String)UNIVERSAL_SEPARATOR);
        }
        return DefaultChooseByNameItemProvider.matchName(fullMatcher, fullName);
    }

    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, String @NotNull [] names2, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(76);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(77);
        }
        if (names2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(78);
        }
        List<String> list2 = this.filterNames((ChooseByNameViewModel)base, names2, pattern);
        if (list2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(79);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameViewModel base, String @NotNull [] names2, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(80);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(81);
        }
        if (names2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(82);
        }
        boolean preferStartMatches = pattern.startsWith("*");
        if ((pattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, pattern)).isEmpty() && !base.canShowListForEmptyPattern()) {
            List<String> list2 = Collections.emptyList();
            if (list2 != null) return list2;
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(83);
            return list2;
        }
        ArrayList<String> filtered2 = new ArrayList<String>();
        DefaultChooseByNameItemProvider.processNamesByPattern(base, names2, pattern, ProgressIndicatorProvider.getGlobalProgressIndicator(), (Consumer<? super MatchResult>)((Consumer)result2 -> {
            List list2 = filtered2;
            synchronized (list2) {
                filtered2.add(result2.elementName);
            }
        }), preferStartMatches);
        ArrayList<String> arrayList2 = filtered2;
        // MONITORENTER : arrayList2
        ArrayList<String> arrayList = filtered2;
        // MONITOREXIT : arrayList2
        if (arrayList != null) return arrayList;
        DefaultChooseByNameItemProvider.$$$reportNull$$$0(84);
        return arrayList;
    }

    private static void processNamesByPattern(@NotNull ChooseByNameViewModel base, String @NotNull [] names2, @NotNull String pattern, ProgressIndicator indicator, @NotNull Consumer<? super MatchResult> consumer2, boolean preferStartMatches) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(85);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(86);
        }
        if (consumer2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(87);
        }
        if (names2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(88);
        }
        MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(pattern, preferStartMatches);
        Processor processor2 = name -> {
            ProgressManager.checkCanceled();
            MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, name);
            if (result2 != null) {
                consumer2.consume((Object)result2);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(names2), indicator, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private static String convertToMatchingPattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(89);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(90);
        }
        return DefaultChooseByNameItemProvider.addSearchAnywherePatternDecorationIfNeeded(base, DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern));
    }

    @NotNull
    private static String addSearchAnywherePatternDecorationIfNeeded(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        String trimmedPattern;
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(91);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(92);
        }
        if (base.isSearchInAnyPlace() && !(trimmedPattern = ((String)pattern).trim()).isEmpty() && trimmedPattern.length() > 1) {
            pattern = "*" + (String)pattern;
        }
        String string = pattern;
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(93);
        }
        return string;
    }

    @NotNull
    private static String removeModelSpecificMarkup(@NotNull ChooseByNameModel model2, @NotNull String pattern) {
        if (model2 == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(94);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(95);
        }
        if (model2 instanceof ContributorsBasedGotoByModel) {
            pattern = ((ContributorsBasedGotoByModel)model2).removeModelSpecificMarkup(pattern);
        }
        String string = pattern;
        if (string == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(96);
        }
        return string;
    }

    @Nullable
    protected static MatchResult matches(@NotNull ChooseByNameViewModel base, @NotNull String pattern, @NotNull MinusculeMatcher matcher, @Nullable String name) {
        if (base == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(97);
        }
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(98);
        }
        if (matcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(99);
        }
        if (name == null) {
            return null;
        }
        if (base.getModel() instanceof CustomMatcherModel) {
            try {
                return ((CustomMatcherModel)base.getModel()).matches(name, pattern) ? new MatchResult(name, 0, true) : null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        return DefaultChooseByNameItemProvider.matchName(matcher, name);
    }

    @Nullable
    private static MatchResult matchName(@NotNull MinusculeMatcher matcher, @NotNull String name) {
        FList fragments;
        if (matcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(100);
        }
        if (name == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(101);
        }
        return (fragments = matcher.matchingFragments(name)) != null ? new MatchResult(name, matcher.matchingDegree(name, false, fragments), MinusculeMatcher.isStartMatch((Iterable)fragments)) : null;
    }

    @NotNull
    private static MinusculeMatcher buildPatternMatcher(@NotNull String pattern, boolean preferStartMatches) {
        if (pattern == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(102);
        }
        NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher((String)pattern).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE);
        if (preferStartMatches) {
            builder2 = builder2.preferringStartMatches();
        }
        MinusculeMatcher minusculeMatcher = builder2.build();
        if (minusculeMatcher == null) {
            DefaultChooseByNameItemProvider.$$$reportNull$$$0(103);
        }
        return minusculeMatcher;
    }

    private static /* synthetic */ boolean lambda$getAllNames$8(ProgressIndicator indicator, ChooseByNameViewModel base, String fullPattern, MinusculeMatcher matcher, CollectConsumer collect2, String sequence) {
        indicator.checkCanceled();
        MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, fullPattern, matcher, sequence);
        if (result2 != null) {
            collect2.consume((Object)result2);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 54: 
            case 64: 
            case 67: 
            case 72: 
            case 79: 
            case 83: 
            case 84: 
            case 93: 
            case 96: 
            case 103: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 54: 
            case 64: 
            case 67: 
            case 72: 
            case 79: 
            case 83: 
            case 84: 
            case 93: 
            case 96: 
            case 103: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 5: 
            case 17: 
            case 21: 
            case 33: 
            case 56: 
            case 66: 
            case 69: 
            case 71: 
            case 77: 
            case 81: 
            case 86: 
            case 90: 
            case 92: 
            case 95: 
            case 98: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 27: 
            case 31: 
            case 35: 
            case 38: 
            case 59: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: 
            case 37: 
            case 42: 
            case 48: 
            case 52: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: 
            case 13: 
            case 25: 
            case 29: 
            case 39: 
            case 41: 
            case 47: 
            case 51: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 54: 
            case 64: 
            case 67: 
            case 72: 
            case 79: 
            case 83: 
            case 84: 
            case 93: 
            case 96: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePattern";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesList";
                break;
            }
            case 70: 
            case 73: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullMatcher";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 78: 
            case 82: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 99: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/DefaultChooseByNameItemProvider";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedNamesForAllWildcards";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedNames";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNames";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullMatcher";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFullPattern";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePattern";
                break;
            }
            case 79: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNames";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "addSearchAnywherePatternDecorationIfNeeded";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModelSpecificMarkup";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPatternMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "filterElementsWithWeights";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getSortedNamesForAllWildcards";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 54: 
            case 64: 
            case 67: 
            case 72: 
            case 79: 
            case 83: 
            case 84: 
            case 93: 
            case 96: 
            case 103: {
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSortedNames";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getAllNames";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createParameters";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "processByNames";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getFullMatcher";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "buildFullPattern";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getNamePattern";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "matchQualifiedName";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "filterNames";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "processNamesByPattern";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "convertToMatchingPattern";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "addSearchAnywherePatternDecorationIfNeeded";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "removeModelSpecificMarkup";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "matchName";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "buildPatternMatcher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 54: 
            case 64: 
            case 67: 
            case 72: 
            case 79: 
            case 83: 
            case 84: 
            case 93: 
            case 96: 
            case 103: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class PathProximityComparator
    implements Comparator<Object> {
        @NotNull
        private final PsiProximityComparator myProximityComparator;

        private PathProximityComparator(@Nullable PsiElement context) {
            this.myProximityComparator = new PsiProximityComparator(context);
        }

        private static boolean isCompiledWithoutSource(Object o) {
            return o instanceof PsiCompiledElement && ((PsiCompiledElement)o).getNavigationElement() == o;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int rc = this.myProximityComparator.compare(o1, o2);
            if (rc != 0) {
                return rc;
            }
            int o1Weight = PathProximityComparator.isCompiledWithoutSource(o1) ? 1 : 0;
            int o2Weight = PathProximityComparator.isCompiledWithoutSource(o2) ? 1 : 0;
            return o1Weight - o2Weight;
        }
    }
}

