/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.OpenUntrustedProjectChoice;
import com.intellij.ide.impl.TrustChangeNotifier;
import com.intellij.ide.impl.TrustedCheckResult;
import com.intellij.ide.impl.TrustedPathsSettings;
import com.intellij.ide.impl.TrustedProjectSettings;
import com.intellij.ide.impl.TrustedProjectsStatistics;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u0004\u001a@\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u00042\b\b\u0001\u0010\u0011\u001a\u00020\u0004\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001e\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\b\u0010\u001a\u001a\u00020\u0006H\u0002\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\b\u001a\n\u0010\u001d\u001a\u00020\u0006*\u00020\b\u001a\u0012\u0010\u001e\u001a\u00020\u001f*\u00020\b2\u0006\u0010 \u001a\u00020\u0006\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TRUSTED_PROJECTS_HELP_TOPIC", "", "confirmLoadingUntrustedProject", "", "project", "Lcom/intellij/openapi/project/Project;", "title", "message", "trustButtonText", "distrustButtonText", "confirmOpeningUntrustedProject", "Lcom/intellij/ide/impl/OpenUntrustedProjectChoice;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "cancelButtonText", "createDoNotAskOptionForLocation", "Lcom/intellij/openapi/ui/DialogWrapper$DoNotAskOption;", "projectLocationPath", "getImplicitTrustedCheckResult", "Lcom/intellij/ide/impl/TrustedCheckResult;", "projectDir", "Ljava/nio/file/Path;", "isProjectImplicitlyTrusted", "isTrustedCheckDisabled", "getTrustedState", "Lcom/intellij/util/ThreeState;", "isTrusted", "setTrusted", "", "value", "intellij.platform.ide.impl"})
@JvmName(name="TrustedProjects")
@ApiStatus.Experimental
public final class TrustedProjects {
    @NotNull
    public static final String TRUSTED_PROJECTS_HELP_TOPIC = "Project_security";
    private static final Logger LOG;

    @NotNull
    public static final OpenUntrustedProjectChoice confirmOpeningUntrustedProject(@NotNull VirtualFile virtualFile, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @NotNull String message, @NlsContexts.Button @NotNull String trustButtonText, @NlsContexts.Button @NotNull String distrustButtonText, @NlsContexts.Button @NotNull String cancelButtonText) {
        OpenUntrustedProjectChoice openUntrustedProjectChoice;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)trustButtonText, (String)"trustButtonText");
        Intrinsics.checkNotNullParameter((Object)distrustButtonText, (String)"distrustButtonText");
        Intrinsics.checkNotNullParameter((Object)cancelButtonText, (String)"cancelButtonText");
        VirtualFile projectDir = virtualFile.isDirectory() ? virtualFile : virtualFile.getParent();
        TrustedCheckResult trustedCheckResult = TrustedProjects.getImplicitTrustedCheckResult$default(projectDir.toNioPath(), null, 2, null);
        if (trustedCheckResult instanceof TrustedCheckResult.Trusted) {
            return OpenUntrustedProjectChoice.IMPORT;
        }
        MessageDialogBuilder.YesNoCancel yesNoCancel = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.Companion.yesNoCancel(title, message).yesText(trustButtonText)).noText(distrustButtonText)).cancelText(cancelButtonText);
        VirtualFile virtualFile2 = projectDir;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"projectDir");
        VirtualFile virtualFile3 = virtualFile2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"projectDir.parent");
        String string = virtualFile3.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectDir.parent.path");
        int choice = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)yesNoCancel.doNotAsk(TrustedProjects.createDoNotAskOptionForLocation(string))).asWarning()).show(null);
        switch (choice) {
            case 0: {
                openUntrustedProjectChoice = OpenUntrustedProjectChoice.IMPORT;
                break;
            }
            case 1: {
                openUntrustedProjectChoice = OpenUntrustedProjectChoice.OPEN_WITHOUT_IMPORTING;
                break;
            }
            case 2: {
                openUntrustedProjectChoice = OpenUntrustedProjectChoice.CANCEL;
                break;
            }
            default: {
                LOG.error("Illegal choice " + choice);
                return OpenUntrustedProjectChoice.CANCEL;
            }
        }
        OpenUntrustedProjectChoice openChoice = openUntrustedProjectChoice;
        TrustedProjectsStatistics.Companion.getNEW_PROJECT_OPEN_OR_IMPORT_CHOICE().log((Object)openChoice);
        return openChoice;
    }

    public static final boolean confirmLoadingUntrustedProject(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DialogMessage @NotNull String message, @NlsContexts.Button @NotNull String trustButtonText, @NlsContexts.Button @NotNull String distrustButtonText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)trustButtonText, (String)"trustButtonText");
        Intrinsics.checkNotNullParameter((Object)distrustButtonText, (String)"distrustButtonText");
        TrustedCheckResult trustedCheckResult = TrustedProjects.getImplicitTrustedCheckResult(project);
        if (trustedCheckResult instanceof TrustedCheckResult.Trusted) {
            TrustedProjects.setTrusted(project, true);
            return true;
        }
        boolean answer = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(title, message).yesText(trustButtonText)).noText(distrustButtonText)).asWarning()).ask(project);
        TrustedProjects.setTrusted(project, answer);
        TrustedProjectsStatistics.Companion.getLOAD_UNTRUSTED_PROJECT_CONFIRMATION_CHOICE().log(project, (Object)answer);
        return answer;
    }

    public static final boolean isTrusted(@NotNull Project $this$isTrusted) {
        Intrinsics.checkNotNullParameter((Object)$this$isTrusted, (String)"$this$isTrusted");
        return TrustedProjects.getTrustedState($this$isTrusted) == ThreeState.YES;
    }

    @NotNull
    public static final ThreeState getTrustedState(@NotNull Project $this$getTrustedState) {
        Intrinsics.checkNotNullParameter((Object)$this$getTrustedState, (String)"$this$getTrustedState");
        Project $this$service$iv = $this$getTrustedState;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(TrustedProjectSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ThreeState explicit = ((TrustedProjectSettings)((Object)object)).getTrustedState();
        if (explicit != ThreeState.UNSURE) {
            return explicit;
        }
        return TrustedProjects.getImplicitTrustedCheckResult($this$getTrustedState) instanceof TrustedCheckResult.Trusted ? ThreeState.YES : ThreeState.UNSURE;
    }

    public static final void setTrusted(@NotNull Project $this$setTrusted, boolean value2) {
        Intrinsics.checkNotNullParameter((Object)$this$setTrusted, (String)"$this$setTrusted");
        Project $this$service$iv = $this$setTrusted;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(TrustedProjectSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        TrustedProjectSettings trustedProjectSettings = (TrustedProjectSettings)((Object)object);
        ThreeState threeState = ThreeState.fromBoolean((boolean)value2);
        Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"ThreeState.fromBoolean(value)");
        trustedProjectSettings.setTrustedState(threeState);
        if (value2) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            ((TrustChangeNotifier)application.getMessageBus().syncPublisher(TrustChangeNotifier.TOPIC)).projectTrusted($this$setTrusted);
        }
    }

    @NotNull
    public static final DialogWrapper.DoNotAskOption createDoNotAskOptionForLocation(@NotNull String projectLocationPath) {
        Intrinsics.checkNotNullParameter((Object)projectLocationPath, (String)"projectLocationPath");
        return (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(projectLocationPath){
            final /* synthetic */ String $projectLocationPath;

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected && exitCode == 0) {
                    TrustedProjectsStatistics.Companion.getTRUST_LOCATION_CHECKBOX_SELECTED().log();
                    boolean $i$f$service = false;
                    Object object = ApplicationManager.getApplication().getService(TrustedPathsSettings.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
                    ((TrustedPathsSettings)((Object)object)).addTrustedPath(this.$projectLocationPath);
                }
            }

            @NotNull
            public String getDoNotShowMessage() {
                String path = FileUtil.getLocationRelativeToUserHome((String)this.$projectLocationPath, (boolean)false);
                String string = IdeBundle.message((String)"untrusted.project.warning.trust.location.checkbox", (Object[])new Object[]{path});
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"untru\u2026location.checkbox\", path)");
                return string;
            }
            {
                this.$projectLocationPath = $captured_local_variable$0;
            }
        };
    }

    public static final boolean isProjectImplicitlyTrusted(@Nullable Path projectDir) {
        return TrustedProjects.getImplicitTrustedCheckResult$default(projectDir, null, 2, null) instanceof TrustedCheckResult.Trusted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isTrustedCheckDisabled() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) return true;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        if (application2.isHeadlessEnvironment()) return true;
        if (!SystemProperties.is((String)"idea.is.integration.test")) return false;
        return true;
    }

    private static final TrustedCheckResult getImplicitTrustedCheckResult(Project project) {
        Path path;
        String string = project.getBasePath();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            path = Paths.get(it, new String[0]);
        } else {
            path = null;
        }
        return TrustedProjects.getImplicitTrustedCheckResult(path, project);
    }

    private static final TrustedCheckResult getImplicitTrustedCheckResult(Path projectDir, Project project) {
        if (TrustedProjects.isTrustedCheckDisabled()) {
            return TrustedCheckResult.Trusted.INSTANCE;
        }
        if (projectDir != null) {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(TrustedPathsSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            if (((TrustedPathsSettings)((Object)object)).isPathTrusted(projectDir)) {
                TrustedProjectsStatistics.Companion.getPROJECT_IMPLICITLY_TRUSTED_BY_PATH().log(project);
                return TrustedCheckResult.Trusted.INSTANCE;
            }
        }
        return new TrustedCheckResult.NotTrusted(null);
    }

    static /* synthetic */ TrustedCheckResult getImplicitTrustedCheckResult$default(Path path, Project project, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        return TrustedProjects.getImplicitTrustedCheckResult(path, project);
    }

    static {
        Logger logger = Logger.getInstance((String)"com.intellij.ide.impl.TrustedProjects");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"com.\u2026de.impl.TrustedProjects\")");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$isTrustedCheckDisabled() {
        return TrustedProjects.isTrustedCheckDisabled();
    }
}

