/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.CommonBundle;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectNewWindowDoNotAskOption;
import com.intellij.ide.impl.SelectProjectOpenProcessorDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.JBProtocolOpenProjectCommand;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.ui.AppIcon;
import com.intellij.ui.GuiUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class ProjectUtil {
    private static final Logger LOG = Logger.getInstance(ProjectUtil.class);
    private static final String MODE_PROPERTY = "OpenOrAttachDialog.OpenMode";
    @NonNls
    private static final String MODE_ATTACH = "attach";
    private static final String MODE_REPLACE = "replace";
    private static final String MODE_NEW = "new";

    private ProjectUtil() {
    }

    @Deprecated
    public static void updateLastProjectLocation(@NotNull String projectFilePath) {
        if (projectFilePath == null) {
            ProjectUtil.$$$reportNull$$$0(0);
        }
        ProjectUtil.updateLastProjectLocation(Paths.get(projectFilePath, new String[0]));
    }

    public static void updateLastProjectLocation(@NotNull Path lastProjectLocation) {
        if (lastProjectLocation == null) {
            ProjectUtil.$$$reportNull$$$0(1);
        }
        if (Files.isRegularFile(lastProjectLocation, new LinkOption[0])) {
            lastProjectLocation = lastProjectLocation.getParent();
        }
        if (lastProjectLocation == null) {
            return;
        }
        if ((lastProjectLocation = lastProjectLocation.getParent()) == null) {
            return;
        }
        String path = lastProjectLocation.toString();
        try {
            path = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return;
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(PathUtil.toSystemIndependentName((String)path));
    }

    @Deprecated
    public static boolean closeAndDispose(@NotNull Project project) {
        if (project == null) {
            ProjectUtil.$$$reportNull$$$0(2);
        }
        return ProjectManagerEx.getInstanceEx().closeAndDispose(project);
    }

    public static Project openOrImport(@NotNull Path path, Project projectToClose, boolean forceOpenInNewFrame) {
        if (path == null) {
            ProjectUtil.$$$reportNull$$$0(3);
        }
        return ProjectUtil.openOrImport(path, OpenProjectTask.withProjectToClose(projectToClose, forceOpenInNewFrame));
    }

    public static Project openOrImport(@NotNull Path path) {
        if (path == null) {
            ProjectUtil.$$$reportNull$$$0(4);
        }
        return ProjectUtil.openOrImport(path, new OpenProjectTask());
    }

    @Nullable
    public static Project openOrImport(@NotNull String path, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        if (path == null) {
            ProjectUtil.$$$reportNull$$$0(5);
        }
        return ProjectUtil.openOrImport(Paths.get(path, new String[0]), OpenProjectTask.withProjectToClose(projectToClose, forceOpenInNewFrame));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Project openOrImport(@NotNull Path file2, @NotNull OpenProjectTask options2) {
        Project project;
        VirtualFile virtualFile;
        Project existing;
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(6);
        }
        if (options2 == null) {
            ProjectUtil.$$$reportNull$$$0(7);
        }
        if (!options2.getForceOpenInNewFrame() && (existing = ProjectUtil.findAndFocusExistingProjectForPath(file2)) != null) {
            return existing;
        }
        NullableLazyValue lazyVirtualFile = NullableLazyValue.createValue(() -> ProjectUtil.getFileAndRefresh(file2));
        for (Object provider2 : ProjectOpenProcessor.EXTENSION_POINT_NAME.getIterable()) {
            if (!provider2.isStrongProjectInfoHolder()) continue;
            virtualFile = (VirtualFile)lazyVirtualFile.getValue();
            if (virtualFile == null) {
                return null;
            }
            if (!provider2.canOpenProject(virtualFile)) continue;
            return ProjectUtil.chooseProcessorAndOpen(Collections.singletonList(provider2), virtualFile, options2);
        }
        if (ProjectUtil.isValidProjectPath(file2)) {
            return ProjectManagerEx.getInstanceEx().openProject(file2, options2.withRunConfigurators());
        }
        if (options2.checkDirectoryForFileBasedProjects && Files.isDirectory(file2, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream2 = Files.newDirectoryStream(file2);){
                for (Path child2 : directoryStream2) {
                    String childPath = child2.toString();
                    if (!childPath.endsWith(".ipr")) continue;
                    Project project2 = ProjectUtil.openProject(Paths.get(childPath, new String[0]), options2);
                    return project2;
                }
            }
            catch (IOException directoryStream2) {
                // empty catch block
            }
        }
        SmartList processors = new SmartList();
        ProjectOpenProcessor.EXTENSION_POINT_NAME.forEachExtensionSafe(arg_0 -> ProjectUtil.lambda$openOrImport$1(file2, (List)processors, lazyVirtualFile, arg_0));
        if (processors.isEmpty()) {
            return null;
        }
        if (processors.size() == 1 && processors.get(0) instanceof PlatformProjectOpenProcessor) {
            project = ProjectManagerEx.getInstanceEx().openProject(file2, options2.asNewProjectAndRunConfigurators().withBeforeOpenCallback(p -> {
                p.putUserData(PlatformProjectOpenProcessor.PROJECT_OPENED_BY_PLATFORM_PROCESSOR, (Object)Boolean.TRUE);
                return true;
            }));
        } else {
            virtualFile = (VirtualFile)lazyVirtualFile.getValue();
            if (virtualFile == null) {
                return null;
            }
            project = ProjectUtil.chooseProcessorAndOpen((List<ProjectOpenProcessor>)processors, virtualFile, options2);
        }
        if (project == null) {
            return null;
        }
        StartupManager.getInstance((Project)project).runAfterOpened(() -> GuiUtils.invokeLaterIfNeeded(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Project");
            if (toolWindow != null) {
                toolWindow.activate(null);
            }
        }, (ModalityState)ModalityState.NON_MODAL, (Condition)project.getDisposed()));
        return project;
    }

    @Nullable
    private static Project chooseProcessorAndOpen(@NotNull List<ProjectOpenProcessor> processors, @NotNull VirtualFile virtualFile, @NotNull OpenProjectTask options2) {
        ProjectOpenProcessor processor2;
        if (processors == null) {
            ProjectUtil.$$$reportNull$$$0(8);
        }
        if (virtualFile == null) {
            ProjectUtil.$$$reportNull$$$0(9);
        }
        if (options2 == null) {
            ProjectUtil.$$$reportNull$$$0(10);
        }
        if (processors.size() == 1) {
            processor2 = processors.get(0);
        } else {
            processors.removeIf(it -> it instanceof PlatformProjectOpenProcessor);
            if (processors.size() == 1) {
                processor2 = processors.get(0);
            } else {
                Ref ref = new Ref();
                ApplicationManager.getApplication().invokeAndWait(() -> ref.set((Object)new SelectProjectOpenProcessorDialog(processors, virtualFile).showAndGetChoice()));
                processor2 = (ProjectOpenProcessor)ref.get();
                if (processor2 == null) {
                    return null;
                }
            }
        }
        Ref result2 = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> result2.set((Object)processor2.doOpenProject(virtualFile, options2.getProjectToClose(), options2.getForceOpenInNewFrame())));
        return (Project)result2.get();
    }

    @ApiStatus.Internal
    @Nullable
    public static VirtualFile getFileAndRefresh(@NotNull Path file2) {
        VirtualFile virtualFile;
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(11);
        }
        if ((virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)file2.toString()))) == null || !virtualFile.isValid()) {
            return null;
        }
        virtualFile.refresh(false, false);
        return virtualFile;
    }

    @Nullable
    public static Project openProject(@NotNull String path, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        if (path == null) {
            ProjectUtil.$$$reportNull$$$0(12);
        }
        return ProjectUtil.openProject(Paths.get(path, new String[0]), OpenProjectTask.withProjectToClose(projectToClose, forceOpenInNewFrame));
    }

    @Nullable
    public static Project openProject(@NotNull Path file2, @NotNull OpenProjectTask options2) {
        Path dir;
        BasicFileAttributes fileAttributes;
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(13);
        }
        if (options2 == null) {
            ProjectUtil.$$$reportNull$$$0(14);
        }
        if ((fileAttributes = PathKt.basicAttributesIfExists((Path)file2)) == null) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{file2.toString()}), (String)CommonBundle.getErrorTitle());
            return null;
        }
        Project existing = ProjectUtil.findAndFocusExistingProjectForPath(file2);
        if (existing != null) {
            return existing;
        }
        if (ProjectUtil.isRemotePath(file2.toString()) && !RecentProjectsManager.getInstance().hasPath(FileUtil.toSystemIndependentName((String)file2.toString())) && !ProjectUtil.confirmLoadingFromRemotePath(file2.toString(), "warning.load.project.from.share", "title.load.project.from.share")) {
            return null;
        }
        String pathFromJBCommand = JetBrainsProtocolHandler.getMainParameter();
        if (pathFromJBCommand != null && file2.equals(JBProtocolOpenProjectCommand.toPath(pathFromJBCommand)) && !ProjectUtil.confirmLoadingFromRemotePath(file2.toString(), "warning.open.file.from.untrusted.source", "title.open.file.from.untrusted.source")) {
            return null;
        }
        if (fileAttributes.isDirectory() && !Files.isDirectory(dir = file2.resolve(".idea"), new LinkOption[0])) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{dir.toString()}), (String)CommonBundle.getErrorTitle());
            return null;
        }
        try {
            return ProjectManagerEx.getInstanceEx().openProject(file2, options2);
        }
        catch (Exception e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
    }

    public static boolean confirmLoadingFromRemotePath(@NotNull String path, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String msgKey, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (path == null) {
            ProjectUtil.$$$reportNull$$$0(15);
        }
        if (msgKey == null) {
            ProjectUtil.$$$reportNull$$$0(16);
        }
        if (titleKey == null) {
            ProjectUtil.$$$reportNull$$$0(17);
        }
        return ProjectUtil.showYesNoDialog(IdeBundle.message((String)msgKey, (Object[])new Object[]{path}), titleKey);
    }

    public static boolean showYesNoDialog(@NotNull @Nls String message, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (message == null) {
            ProjectUtil.$$$reportNull$$$0(18);
        }
        if (titleKey == null) {
            ProjectUtil.$$$reportNull$$$0(19);
        }
        return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)IdeBundle.message((String)titleKey, (Object[])new Object[0]), (String)message).icon(Messages.getWarningIcon())).ask((Component)ProjectUtil.getActiveFrameOrWelcomeScreen());
    }

    public static Window getActiveFrameOrWelcomeScreen() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null) {
            return window;
        }
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof IdeFrame) || !frame.isVisible()) continue;
            return frame;
        }
        return null;
    }

    public static boolean isRemotePath(@NotNull String path) {
        if (path == null) {
            ProjectUtil.$$$reportNull$$$0(20);
        }
        return path.contains("://") || path.contains("\\\\");
    }

    @NotNull
    public static @NotNull Project @NotNull [] getOpenProjects() {
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        Project[] projectArray = projectManager == null ? new Project[]{} : projectManager.getOpenProjects();
        if (projectArray == null) {
            ProjectUtil.$$$reportNull$$$0(21);
        }
        return projectArray;
    }

    @Nullable
    public static Project findAndFocusExistingProjectForPath(@NotNull Path file2) {
        Project[] openProjects;
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(22);
        }
        if ((openProjects = ProjectUtil.getOpenProjects()).length == 0) {
            return null;
        }
        for (Project project : openProjects) {
            if (!ProjectUtil.isSameProject(file2, project)) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return project;
        }
        return null;
    }

    public static int confirmOpenNewProject(boolean isNewProject) {
        int confirmOpenNewProject;
        GeneralSettings settings = GeneralSettings.getInstance();
        int n = confirmOpenNewProject = ApplicationManager.getApplication().isUnitTestMode() ? 0 : settings.getConfirmOpenNewProject();
        if (confirmOpenNewProject == -1) {
            if (isNewProject) {
                boolean openInExistingFrame = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)IdeBundle.message((String)"title.new.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0])).yesText(IdeBundle.message((String)"button.existing.frame", (Object[])new Object[0]))).noText(IdeBundle.message((String)"button.new.frame", (Object[])new Object[0]))).doNotAsk((DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption())).guessWindowAndAsk();
                int code = openInExistingFrame ? 1 : 0;
                LifecycleUsageTriggerCollector.onProjectFrameSelected(code);
                return code;
            }
            int exitCode = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0])).yesText(IdeBundle.message((String)"button.existing.frame", (Object[])new Object[0]))).noText(IdeBundle.message((String)"button.new.frame", (Object[])new Object[0]))).doNotAsk((DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption())).guessWindowAndAsk();
            int code = exitCode == 0 ? 1 : (exitCode == 1 ? 0 : 2);
            LifecycleUsageTriggerCollector.onProjectFrameSelected(code);
            return code;
        }
        return confirmOpenNewProject;
    }

    public static int confirmOpenOrAttachProject() {
        int returnValue;
        String mode = PropertiesComponent.getInstance().getValue(MODE_PROPERTY);
        int exitCode = Messages.showDialog((String)IdeBundle.message((String)"prompt.open.project.or.attach", (Object[])new Object[0]), (String)IdeBundle.message((String)"prompt.open.project.or.attach.title", (Object[])new Object[0]), (String[])new String[]{IdeBundle.message((String)"prompt.open.project.or.attach.button.this.window", (Object[])new Object[0]), IdeBundle.message((String)"prompt.open.project.or.attach.button.new.window", (Object[])new Object[0]), IdeBundle.message((String)"prompt.open.project.or.attach.button.attach", (Object[])new Object[0]), CommonBundle.getCancelButtonText()}, (int)(MODE_NEW.equals(mode) ? 1 : (MODE_REPLACE.equals(mode) ? 0 : (MODE_ATTACH.equals(mode) ? 2 : 0))), (Icon)Messages.getQuestionIcon());
        int n = exitCode == 0 ? 1 : (exitCode == 1 ? 0 : (returnValue = exitCode == 2 ? 2 : -1));
        if (returnValue != -1) {
            LifecycleUsageTriggerCollector.onProjectFrameSelected(returnValue);
        }
        return returnValue;
    }

    @Deprecated
    public static boolean isSameProject(@Nullable String projectFilePath, @NotNull Project project) {
        if (project == null) {
            ProjectUtil.$$$reportNull$$$0(23);
        }
        return projectFilePath != null && ProjectUtil.isSameProject(Paths.get(projectFilePath, new String[0]), project);
    }

    public static boolean isSameProject(@NotNull Path projectFile, @NotNull Project project) {
        IProjectStore projectStore;
        Path existingBaseDirPath;
        if (projectFile == null) {
            ProjectUtil.$$$reportNull$$$0(24);
        }
        if (project == null) {
            ProjectUtil.$$$reportNull$$$0(25);
        }
        if ((existingBaseDirPath = (projectStore = ProjectKt.getStateStore(project)).getProjectBasePath()).getFileSystem() != projectFile.getFileSystem()) {
            return false;
        }
        if (Files.isDirectory(projectFile, new LinkOption[0])) {
            try {
                return Files.isSameFile(projectFile, existingBaseDirPath);
            }
            catch (IOException ignore) {
                return false;
            }
        }
        if (projectStore.getStorageScheme() == StorageScheme.DEFAULT) {
            try {
                return Files.isSameFile(projectFile, projectStore.getProjectFilePath());
            }
            catch (IOException ignore) {
                return false;
            }
        }
        Path parent = projectFile.getParent();
        if (parent == null) {
            return false;
        }
        Path parentFileName = parent.getFileName();
        if (parentFileName != null && parentFileName.toString().equals(".idea")) {
            return (parent = parent.getParent()) != null && FileUtil.pathsEqual((String)parent.toString(), (String)existingBaseDirPath.toString());
        }
        return projectFile.getFileName().toString().endsWith(".ipr") && FileUtil.pathsEqual((String)parent.toString(), (String)existingBaseDirPath.toString());
    }

    public static void focusProjectWindow(@Nullable Project project, boolean stealFocusIfAppInactive) {
        JFrame frame = WindowManager.getInstance().getFrame(project);
        if (frame == null) {
            return;
        }
        if (stealFocusIfAppInactive) {
            AppIcon.getInstance().requestFocus((IdeFrame)frame);
        } else {
            if (!SystemInfo.isXWindow || KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() != null) {
                frame.toFront();
            }
            if (!SystemInfo.isWindows) {
                AppIcon.getInstance().requestAttention(project, true);
            }
        }
    }

    @NotNull
    public static String getBaseDir() {
        String defaultDirectory = GeneralSettings.getInstance().getDefaultProjectDirectory();
        if (Strings.isNotEmpty((String)defaultDirectory)) {
            String string = defaultDirectory.replace('/', File.separatorChar);
            if (string == null) {
                ProjectUtil.$$$reportNull$$$0(26);
            }
            return string;
        }
        String lastProjectLocation = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (lastProjectLocation != null) {
            String string = lastProjectLocation.replace('/', File.separatorChar);
            if (string == null) {
                ProjectUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        String userHome = SystemProperties.getUserHome();
        String productName = ApplicationNamesInfo.getInstance().getLowercaseProductName();
        if (PlatformUtils.isCLion() || PlatformUtils.isAppCode()) {
            productName = ApplicationNamesInfo.getInstance().getProductName();
        }
        String string = userHome.replace('/', File.separatorChar) + File.separator + productName + "Projects";
        if (string == null) {
            ProjectUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    public static Project tryOpenFileList(@Nullable Project project, @NotNull List<? extends File> list2, String location) {
        if (list2 == null) {
            ProjectUtil.$$$reportNull$$$0(29);
        }
        return ProjectUtil.tryOpenFiles(project, ContainerUtil.map(list2, file2 -> file2.toPath()), location);
    }

    @Nullable
    public static Project tryOpenFiles(@Nullable Project project, @NotNull List<Path> list2, String location) {
        if (list2 == null) {
            ProjectUtil.$$$reportNull$$$0(30);
        }
        Project result2 = null;
        for (Path file2 : list2) {
            result2 = ProjectUtil.openOrImport(file2.toAbsolutePath(), OpenProjectTask.withProjectToClose(project, true));
            if (result2 == null) continue;
            LOG.debug(location + ": load project from ", new Object[]{file2});
            return result2;
        }
        for (Path file2 : list2) {
            Project opened;
            if (!Files.exists(file2, new LinkOption[0])) continue;
            LOG.debug(location + ": open file ", new Object[]{file2});
            if (project != null) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtilRt.toSystemIndependentName((String)file2.toString()));
                if (virtualFile != null && virtualFile.isValid()) {
                    OpenFileAction.openFile(virtualFile, project);
                }
                result2 = project;
                continue;
            }
            CommandLineProjectOpenProcessor processor2 = CommandLineProjectOpenProcessor.getInstanceIfExists();
            if (processor2 == null || (opened = processor2.openProjectAndFile(file2, -1, -1, false)) == null || result2 != null) continue;
            result2 = opened;
        }
        return result2;
    }

    public static boolean isValidProjectPath(@NotNull Path file2) {
        if (file2 == null) {
            ProjectUtil.$$$reportNull$$$0(31);
        }
        return Files.isDirectory(file2.resolve(".idea"), new LinkOption[0]) || Strings.endsWith((CharSequence)file2.toString(), (CharSequence)".ipr") && Files.isRegularFile(file2, new LinkOption[0]);
    }

    private static /* synthetic */ void lambda$openOrImport$1(Path file2, List processors, NullableLazyValue lazyVirtualFile, ProjectOpenProcessor processor2) {
        if (processor2 instanceof PlatformProjectOpenProcessor) {
            if (Files.isDirectory(file2, new LinkOption[0])) {
                processors.add(processor2);
            }
        } else {
            VirtualFile virtualFile = (VirtualFile)lazyVirtualFile.getValue();
            if (virtualFile != null && processor2.canOpenProject(virtualFile)) {
                processors.add(processor2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFilePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastProjectLocation";
                break;
            }
            case 2: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processors";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msgKey";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleKey";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/ProjectUtil";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/ProjectUtil";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenProjects";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateLastProjectLocation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "closeAndDispose";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openOrImport";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "chooseProcessorAndOpen";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileAndRefresh";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "openProject";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "confirmLoadingFromRemotePath";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showYesNoDialog";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isRemotePath";
                break;
            }
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findAndFocusExistingProjectForPath";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isSameProject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryOpenFileList";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "tryOpenFiles";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isValidProjectPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

