/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import java.awt.Component;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class HeadlessDataManager
extends DataManagerImpl {
    private volatile DataProvider myTestDataProvider;
    private volatile boolean myUseProductionDataManager = false;

    @TestOnly
    public void setTestDataProvider(@Nullable DataProvider provider2) {
        this.myTestDataProvider = provider2;
    }

    @TestOnly
    public void setTestDataProvider(@Nullable DataProvider provider2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            HeadlessDataManager.$$$reportNull$$$0(0);
        }
        DataProvider previous = this.myTestDataProvider;
        this.myTestDataProvider = provider2;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myTestDataProvider = previous;
        });
    }

    @TestOnly
    public static void fallbackToProductionDataManager(@NotNull Disposable disposable2) {
        if (disposable2 == null) {
            HeadlessDataManager.$$$reportNull$$$0(1);
        }
        HeadlessDataManager manager2 = (HeadlessDataManager)DataManager.getInstance();
        if (manager2.myUseProductionDataManager) {
            throw new IllegalStateException("Already called and still not disposed.");
        }
        Disposer.register((Disposable)disposable2, () -> {
            manager2.myUseProductionDataManager = false;
        });
        manager2.myUseProductionDataManager = true;
    }

    @Override
    @NotNull
    public DataContext getDataContext() {
        return new HeadlessContext(this.myTestDataProvider, this.productionDataProvider(() -> super.getDataContext()));
    }

    @Override
    @NotNull
    public Promise<DataContext> getDataContextFromFocusAsync() {
        AsyncPromise promise = new AsyncPromise();
        promise.setResult((Object)this.getDataContext());
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            HeadlessDataManager.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    @Override
    @NotNull
    public DataContext getDataContext(Component component2) {
        return new HeadlessContext(this.myTestDataProvider, this.productionDataProvider(() -> super.getDataContext(component2)));
    }

    @Override
    @NotNull
    public DataContext getDataContext(@NotNull Component component2, int x, int y) {
        if (component2 == null) {
            HeadlessDataManager.$$$reportNull$$$0(3);
        }
        return new HeadlessContext(this.myTestDataProvider, this.productionDataProvider(() -> super.getDataContext(component2, x, y)));
    }

    private DataProvider productionDataProvider(Supplier<@NotNull DataContext> dataContextSupplier) {
        return this.myUseProductionDataManager ? dataId -> ((DataContext)dataContextSupplier.get()).getData(dataId) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/impl/HeadlessDataManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/impl/HeadlessDataManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataContextFromFocusAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTestDataProvider";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fallbackToProductionDataManager";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDataContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class HeadlessContext
    extends UserDataHolderBase
    implements DataContext {
        @Nullable
        private final DataProvider myProvider1;
        @Nullable
        private final DataProvider myProvider2;

        HeadlessContext(@Nullable DataProvider provider1, @Nullable DataProvider provider2) {
            this.myProvider1 = provider1;
            this.myProvider2 = provider2;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            Object result2;
            if (dataId == null) {
                HeadlessContext.$$$reportNull$$$0(0);
            }
            if (this.myProvider1 != null && (result2 = this.myProvider1.getData(dataId)) != null) {
                return result2;
            }
            if (this.myProvider2 != null && (result2 = this.myProvider2.getData(dataId)) != null) {
                return result2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/impl/HeadlessDataManager$HeadlessContext", "getData"));
        }
    }
}

