/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ToolwindowFusEventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowScrollable;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResizeToolWindowAction
extends AnAction
implements DumbAware,
FusAwareAction {
    private ToolWindow myLastWindow;
    private ToolWindowManager myLastManager;
    protected JLabel myScrollHelper;
    private ToolWindow myToolWindow;
    private boolean myListenerInstalled;

    protected ResizeToolWindowAction() {
    }

    protected ResizeToolWindowAction(@NlsActions.ActionText String text2) {
        super(text2);
    }

    protected ResizeToolWindowAction(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
        super(text2, description, icon2);
    }

    protected ResizeToolWindowAction(@NotNull ToolWindow toolWindow, @NonNls String originalAction, JComponent component2) {
        if (toolWindow == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(0);
        }
        this.myToolWindow = toolWindow;
        new ShadowAction((AnAction)this, ActionManager.getInstance().getAction(originalAction), component2, toolWindow.getDisposable());
    }

    public final void update(@NotNull AnActionEvent e) {
        Component owner;
        Project project;
        if (e == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            this.setDisabled(e);
            return;
        }
        if (!this.myListenerInstalled) {
            this.myListenerInstalled = true;
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ResizeToolWindowAction.this.setDisabled(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/ResizeToolWindowAction$1", "projectClosed"));
                }
            });
        }
        if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
            this.setDisabled(e);
            return;
        }
        Window windowAncestor = SwingUtilities.getWindowAncestor(owner);
        if (!(windowAncestor instanceof IdeFrame) || windowAncestor instanceof IdeFrame.Child) {
            this.setDisabled(e);
            return;
        }
        ToolWindowManager mgr = ToolWindowManager.getInstance((Project)project);
        ToolWindow window = this.getToolWindow(project);
        if (window != null) {
            if (!(window.isAvailable() && window.isVisible() && window.getType() != ToolWindowType.FLOATING && window.getType() != ToolWindowType.WINDOWED && window.isActive())) {
                this.setDisabled(e);
                return;
            }
            this.update(e, window, mgr);
            if (e.getPresentation().isEnabled()) {
                this.myLastWindow = window;
                this.myLastManager = mgr;
            } else {
                this.setDisabled(e);
            }
        } else {
            this.setDisabled(e);
        }
    }

    @Nullable
    private ToolWindow getToolWindow(@NotNull Project project) {
        if (project == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(2);
        }
        if (this.myToolWindow != null) {
            return this.myToolWindow;
        }
        ToolWindowManager manager2 = ToolWindowManager.getInstance((Project)project);
        String id2 = manager2.getActiveToolWindowId();
        if (id2 != null) {
            return manager2.getToolWindow(id2);
        }
        return null;
    }

    private void setDisabled(@Nullable AnActionEvent e) {
        if (e != null) {
            e.getPresentation().setEnabled(false);
        }
        this.myLastWindow = null;
        this.myLastManager = null;
        this.myToolWindow = null;
    }

    protected abstract void update(AnActionEvent var1, ToolWindow var2, ToolWindowManager var3);

    public final void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(3);
        }
        this.actionPerformed(e, this.myLastWindow, this.myLastManager);
    }

    @Override
    @NotNull
    public List<EventPair<?>> getAdditionalUsageData(@NotNull AnActionEvent event) {
        ToolWindow toolWindow;
        Project project;
        if (event == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(4);
        }
        if ((project = event.getProject()) != null && (toolWindow = this.getToolWindow(project)) != null) {
            List<EventPair<?>> list2 = Collections.singletonList(ToolwindowFusEventFields.TOOLWINDOW.with((Object)toolWindow.getId()));
            if (list2 == null) {
                ResizeToolWindowAction.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List<EventPair<?>> list3 = Collections.emptyList();
        if (list3 == null) {
            ResizeToolWindowAction.$$$reportNull$$$0(6);
        }
        return list3;
    }

    @Nullable
    private ToolWindowScrollable getScrollable(ToolWindow toolWindow, boolean isHorizontalStretchingOffered) {
        DefaultToolWindowScrollable scrollable = null;
        for (Component eachComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); eachComponent != null && SwingUtilities.isDescendingFrom(eachComponent, toolWindow.getComponent()); eachComponent = eachComponent.getParent()) {
            if (!(eachComponent instanceof ToolWindowScrollable)) continue;
            ToolWindowScrollable eachScrollable = (ToolWindowScrollable)eachComponent;
            if (isHorizontalStretchingOffered) {
                if (!eachScrollable.isHorizontalScrollingNeeded()) continue;
                scrollable = eachScrollable;
                break;
            }
            if (!eachScrollable.isVerticalScrollingNeeded()) continue;
            scrollable = eachScrollable;
            break;
        }
        if (scrollable == null) {
            scrollable = new DefaultToolWindowScrollable();
        }
        if (isHorizontalStretchingOffered && scrollable.isHorizontalScrollingNeeded() || !isHorizontalStretchingOffered && scrollable.isVerticalScrollingNeeded()) {
            return scrollable;
        }
        return null;
    }

    protected abstract void actionPerformed(AnActionEvent var1, ToolWindow var2, ToolWindowManager var3);

    protected void stretch(ToolWindow wnd, boolean isHorizontalStretching, boolean isIncrementAction) {
        ToolWindowScrollable scrollable = this.getScrollable(wnd, isHorizontalStretching);
        if (scrollable == null) {
            return;
        }
        ToolWindowAnchor anchor2 = wnd.getAnchor();
        if (isHorizontalStretching && !anchor2.isHorizontal()) {
            ResizeToolWindowAction.incWidth(wnd, scrollable.getNextHorizontalScroll(), anchor2 == ToolWindowAnchor.LEFT == isIncrementAction);
        } else if (!isHorizontalStretching && anchor2.isHorizontal()) {
            ResizeToolWindowAction.incHeight(wnd, scrollable.getNextVerticalScroll(), anchor2 == ToolWindowAnchor.TOP != isIncrementAction);
        }
    }

    private static void incWidth(ToolWindow wnd, int value2, boolean isPositive) {
        ((ToolWindowEx)wnd).stretchWidth(isPositive ? value2 : -value2);
    }

    private static void incHeight(ToolWindow wnd, int value2, boolean isPositive) {
        ((ToolWindowEx)wnd).stretchHeight(isPositive ? value2 : -value2);
    }

    private Dimension getReferenceSize() {
        if (this.myScrollHelper == null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.myScrollHelper = new JLabel("W");
            } else {
                return new Dimension(1, 1);
            }
        }
        return this.myScrollHelper.getPreferredSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ResizeToolWindowAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ResizeToolWindowAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUsageData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindow";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalUsageData";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DefaultToolWindowScrollable
    implements ToolWindowScrollable {
        private DefaultToolWindowScrollable() {
        }

        public boolean isHorizontalScrollingNeeded() {
            return true;
        }

        public int getNextHorizontalScroll() {
            return ResizeToolWindowAction.this.getReferenceSize().width * Registry.intValue((String)"ide.windowSystem.hScrollChars");
        }

        public boolean isVerticalScrollingNeeded() {
            return true;
        }

        public int getNextVerticalScroll() {
            return ResizeToolWindowAction.this.getReferenceSize().height * Registry.intValue((String)"ide.windowSystem.vScrollChars");
        }
    }

    public static class Down
    extends ResizeToolWindowAction {
        public Down() {
        }

        public Down(@NlsActions.ActionText String text2) {
            super(text2);
        }

        public Down(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
            super(text2, description, icon2);
        }

        public Down(ToolWindow toolWindow, JComponent c) {
            super(toolWindow, "ResizeToolWindowDown", c);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e, ToolWindow toolWindow, ToolWindowManager toolWindowManager) {
            this.stretch(toolWindow, false, false);
        }
    }

    public static class Up
    extends ResizeToolWindowAction {
        public Up() {
        }

        public Up(@NlsActions.ActionText String text2) {
            super(text2);
        }

        public Up(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
            super(text2, description, icon2);
        }

        public Up(ToolWindow toolWindow, JComponent c) {
            super(toolWindow, "ResizeToolWindowUp", c);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e, ToolWindow toolWindow, ToolWindowManager toolWindowManager) {
            this.stretch(toolWindow, false, true);
        }
    }

    public static class Right
    extends ResizeToolWindowAction {
        public Right() {
        }

        public Right(@NlsActions.ActionText String text2) {
            super(text2);
        }

        public Right(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
            super(text2, description, icon2);
        }

        public Right(ToolWindow toolWindow, JComponent c) {
            super(toolWindow, "ResizeToolWindowRight", c);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(!window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e, ToolWindow toolWindow, ToolWindowManager toolWindowManager) {
            this.stretch(toolWindow, true, true);
        }
    }

    public static class Left
    extends ResizeToolWindowAction {
        public Left() {
        }

        public Left(@NlsActions.ActionText String text2) {
            super(text2);
        }

        public Left(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
            super(text2, description, icon2);
        }

        public Left(@NotNull ToolWindow toolWindow, JComponent c) {
            if (toolWindow == null) {
                Left.$$$reportNull$$$0(0);
            }
            super(toolWindow, "ResizeToolWindowLeft", c);
        }

        @Override
        protected void update(AnActionEvent event, ToolWindow window, ToolWindowManager mgr) {
            event.getPresentation().setEnabled(!window.getAnchor().isHorizontal());
        }

        @Override
        protected void actionPerformed(AnActionEvent e, ToolWindow toolWindow, ToolWindowManager toolWindowManager) {
            this.stretch(toolWindow, true, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/actions/ResizeToolWindowAction$Left", "<init>"));
        }
    }
}

