/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CopyPasteManagerEx;
import com.intellij.ide.dnd.LinuxDragAndDropSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.JBIterable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class PsiCopyPasteManager {
    private static final Logger LOG = Logger.getInstance(PsiCopyPasteManager.class);
    private MyData myRecentData;
    private final CopyPasteManagerEx myCopyPasteManager = CopyPasteManagerEx.getInstanceEx();
    private static final DataFlavor ourDataFlavor;

    public static PsiCopyPasteManager getInstance() {
        return (PsiCopyPasteManager)ApplicationManager.getApplication().getService(PsiCopyPasteManager.class);
    }

    public PsiCopyPasteManager() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(PsiCopyPasteManager.this.myRecentData == null || PsiCopyPasteManager.this.myRecentData.isValid() && PsiCopyPasteManager.this.myRecentData.getProject() != project)) {
                    PsiCopyPasteManager.this.myRecentData = null;
                }
                Transferable[] contents = PsiCopyPasteManager.this.myCopyPasteManager.getAllContents();
                for (int i2 = contents.length - 1; i2 >= 0; --i2) {
                    MyData myData;
                    Transferable t = contents[i2];
                    if (!(t instanceof MyTransferable) || (myData = ((MyTransferable)t).myDataProxy).isValid() && myData.getProject() != project) continue;
                    PsiCopyPasteManager.this.myCopyPasteManager.removeContent(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/PsiCopyPasteManager$1", "projectClosing"));
            }
        });
    }

    public PsiElement @Nullable [] getElements(boolean[] isCopied) {
        try {
            Object transferData = this.myCopyPasteManager.getContents(ourDataFlavor);
            if (!(transferData instanceof MyData)) {
                return null;
            }
            MyData dataProxy = (MyData)transferData;
            if (!Comparing.equal((Object)dataProxy, (Object)this.myRecentData)) {
                return null;
            }
            if (isCopied != null) {
                isCopied[0] = this.myRecentData.isCopied();
            }
            return this.myRecentData.getElements();
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    static PsiElement @Nullable [] getElements(Transferable content2) {
        Object transferData;
        if (content2 == null) {
            return null;
        }
        try {
            transferData = content2.getTransferData(ourDataFlavor);
        }
        catch (UnsupportedFlavorException | InvalidDnDOperationException | IOException e) {
            return null;
        }
        return transferData instanceof MyData ? ((MyData)transferData).getElements() : null;
    }

    public void clear() {
        this.myRecentData = null;
        this.myCopyPasteManager.setContents(new StringSelection(""));
    }

    public void setElements(PsiElement[] elements2, boolean copied) {
        this.myRecentData = new MyData(elements2, copied);
        this.myCopyPasteManager.setContents(new MyTransferable(this.myRecentData));
    }

    public boolean isCutElement(Object element2) {
        if (this.myRecentData == null) {
            return false;
        }
        if (this.myRecentData.isCopied()) {
            return false;
        }
        PsiElement[] elements2 = this.myRecentData.getElements();
        if (elements2 == null) {
            return false;
        }
        for (PsiElement aElement : elements2) {
            if (aElement != element2) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static List<File> asFileList(PsiElement[] elements2) {
        ArrayList<File> result2 = new ArrayList<File>();
        for (PsiElement element2 : elements2) {
            VirtualFile vFile = PsiCopyPasteManager.asVirtualFile(element2);
            if (vFile == null || !(vFile.getFileSystem() instanceof LocalFileSystem)) continue;
            result2.add(new File(vFile.getPath()));
        }
        return result2.isEmpty() ? null : result2;
    }

    @Nullable
    public static VirtualFile asVirtualFile(@Nullable PsiElement element2) {
        PsiFileSystemItem psiFile = null;
        if (element2 instanceof PsiFileSystemItem) {
            psiFile = (PsiFileSystemItem)element2;
        } else if (element2 instanceof PsiDirectoryContainer) {
            PsiDirectory[] directories = ((PsiDirectoryContainer)element2).getDirectories();
            if (directories.length == 0) {
                LOG.error("No directories for " + element2 + " of " + element2.getClass());
                return null;
            }
            psiFile = directories[0];
        } else if (element2 != null) {
            psiFile = element2.getContainingFile();
        }
        if (psiFile != null) {
            return psiFile.getVirtualFile();
        }
        return null;
    }

    static {
        try {
            Class<MyData> flavorClass = MyData.class;
            Thread currentThread = Thread.currentThread();
            ClassLoader currentLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(flavorClass.getClassLoader());
                ourDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + flavorClass.getName());
            }
            finally {
                currentThread.setContextClassLoader(currentLoader);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class EscapeHandler
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent event) {
            if (event.isConsumed()) {
                return;
            }
            if (0 != event.getModifiers()) {
                return;
            }
            if (27 != event.getKeyCode()) {
                return;
            }
            boolean[] copied = new boolean[1];
            PsiCopyPasteManager manager2 = PsiCopyPasteManager.getInstance();
            if (manager2.getElements(copied) == null) {
                return;
            }
            if (copied[0]) {
                return;
            }
            manager2.clear();
            event.consume();
        }
    }

    public static class MyTransferable
    implements Transferable {
        private static final DataFlavor[] DATA_FLAVORS_COPY = new DataFlavor[]{ourDataFlavor, DataFlavor.stringFlavor, DataFlavor.javaFileListFlavor, LinuxDragAndDropSupport.uriListFlavor, LinuxDragAndDropSupport.gnomeFileListFlavor};
        private static final DataFlavor[] DATA_FLAVORS_CUT = new DataFlavor[]{ourDataFlavor, DataFlavor.stringFlavor, DataFlavor.javaFileListFlavor, LinuxDragAndDropSupport.uriListFlavor, LinuxDragAndDropSupport.gnomeFileListFlavor, LinuxDragAndDropSupport.kdeCutMarkFlavor};
        private final MyData myDataProxy;

        public MyTransferable(MyData data2) {
            this.myDataProxy = data2;
        }

        public MyTransferable(PsiElement[] selectedValues) {
            this(new MyData(selectedValues, true));
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            Object result2 = this.getTransferDataOrNull(flavor);
            if (result2 == null) {
                throw new IOException();
            }
            return result2;
        }

        @Nullable
        private Object getTransferDataOrNull(DataFlavor flavor) throws UnsupportedFlavorException {
            if (ourDataFlavor.equals(flavor)) {
                return this.myDataProxy;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                return this.getDataAsText();
            }
            if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                return this.getDataAsFileList();
            }
            if (flavor.equals(LinuxDragAndDropSupport.uriListFlavor)) {
                List<File> files2 = this.getDataAsFileList();
                return files2 == null ? null : LinuxDragAndDropSupport.toUriList(files2);
            }
            if (flavor.equals(LinuxDragAndDropSupport.gnomeFileListFlavor)) {
                List<File> files3 = this.getDataAsFileList();
                if (files3 == null) {
                    return null;
                }
                String string = (this.myDataProxy.isCopied() ? "copy\n" : "cut\n") + LinuxDragAndDropSupport.toUriList(files3);
                return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
            }
            if (flavor.equals(LinuxDragAndDropSupport.kdeCutMarkFlavor) && !this.myDataProxy.isCopied()) {
                return new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8));
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Nullable
        private String getDataAsText() {
            return (String)ReadAction.compute(() -> {
                String names2 = Stream.of(this.myDataProxy.getElements()).filter(PsiNamedElement.class::isInstance).map(e -> StringUtil.nullize((String)((PsiNamedElement)e).getName(), (boolean)true)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
                return names2.isEmpty() ? null : names2;
            });
        }

        @Nullable
        private List<File> getDataAsFileList() {
            return (List)ReadAction.compute(() -> PsiCopyPasteManager.asFileList(this.myDataProxy.getElements()));
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            Object[] flavors = this.myDataProxy.isCopied() ? DATA_FLAVORS_COPY : DATA_FLAVORS_CUT;
            return JBIterable.of((Object[])flavors).filter(flavor -> {
                try {
                    return this.getTransferDataOrNull((DataFlavor)flavor) != null;
                }
                catch (UnsupportedFlavorException ex) {
                    return false;
                }
            }).toList().toArray(new DataFlavor[0]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ArrayUtilRt.find((Object[])this.getTransferDataFlavors(), (Object)flavor) != -1;
        }

        public PsiElement[] getElements() {
            return this.myDataProxy.getElements();
        }
    }

    public static class MyData {
        private final Project myProject;
        private final List<SmartPsiElementPointer> myPointers = new ArrayList<SmartPsiElementPointer>();
        private final boolean myIsCopied;

        public MyData(PsiElement[] elements2, boolean copied) {
            this.myProject = elements2.length == 0 ? null : elements2[0].getProject();
            for (PsiElement element2 : elements2) {
                this.myPointers.add(SmartPointerManager.createPointer((PsiElement)element2));
            }
            this.myIsCopied = copied;
        }

        public PsiElement[] getElements() {
            return (PsiElement[])ReadAction.compute(() -> {
                ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
                for (SmartPsiElementPointer pointer : this.myPointers) {
                    PsiElement element2 = pointer.getElement();
                    if (element2 == null) continue;
                    result2.add(element2);
                }
                return result2.toArray(PsiElement.EMPTY_ARRAY);
            });
        }

        public boolean isCopied() {
            return this.myIsCopied;
        }

        public boolean isValid() {
            return this.myPointers.size() > 0 && this.myPointers.get(0).getElement() != null;
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }
    }
}

