/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findInProject;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindInProjectManager {
    private final Project myProject;
    private volatile boolean myIsFindInProgress;

    public static FindInProjectManager getInstance(Project project) {
        return (FindInProjectManager)ServiceManager.getService((Project)project, FindInProjectManager.class);
    }

    public FindInProjectManager(Project project) {
        this.myProject = project;
    }

    public void findInProject(@NotNull DataContext dataContext, @Nullable FindModel model2) {
        FindModel findModel;
        if (dataContext == null) {
            FindInProjectManager.$$$reportNull$$$0(0);
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        if (model2 != null) {
            findModel = model2.clone();
        } else {
            findModel = findManager.getFindInProjectModel().clone();
            findModel.setReplaceState(false);
            this.initModel(findModel, dataContext);
        }
        findManager.showFindDialog(findModel, () -> {
            if (findModel.isReplaceState()) {
                ReplaceInProjectManager.getInstance(this.myProject).replaceInPath(findModel);
            } else {
                this.findInPath(findModel);
            }
        });
    }

    public void findInPath(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectManager.$$$reportNull$$$0(1);
        }
        this.startFindInProject(findModel);
    }

    protected void initModel(@NotNull FindModel findModel, @NotNull DataContext dataContext) {
        if (findModel == null) {
            FindInProjectManager.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            FindInProjectManager.$$$reportNull$$$0(3);
        }
        FindInProjectUtil.setDirectoryName(findModel, dataContext);
        String text2 = (String)PlatformDataKeys.PREDEFINED_TEXT.getData(dataContext);
        if (text2 != null) {
            FindModel.initStringToFindNoMultiline((FindModel)findModel, (String)text2);
        } else {
            FindInProjectUtil.initStringToFindFromDataContext(findModel, dataContext);
        }
    }

    public void startFindInProject(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindInProjectManager.$$$reportNull$$$0(4);
        }
        if (findModel.getDirectoryName() != null && FindInProjectUtil.getDirectory(findModel) == null) {
            return;
        }
        UsageViewManager manager2 = UsageViewManager.getInstance((Project)this.myProject);
        if (manager2 == null) {
            return;
        }
        FindManager findManager = FindManager.getInstance((Project)this.myProject);
        findManager.getFindInProjectModel().copyFrom(findModel);
        FindModel findModelCopy = findModel.clone();
        UsageViewPresentation presentation2 = FindInProjectUtil.setupViewPresentation(findModelCopy);
        FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(this.myProject, presentation2);
        FindInProjectUtil.StringUsageTarget usageTarget = new FindInProjectUtil.StringUsageTarget(this.myProject, findModel);
        ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).getFindUsagesManager().addToHistory(usageTarget);
        manager2.searchAndShowUsages(new UsageTarget[]{usageTarget}, () -> processor2 -> {
            this.myIsFindInProgress = true;
            try {
                Processor consumer2 = info -> {
                    Usage usage = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun(info);
                    usage.getPresentation().getIcon();
                    return processor2.process((Object)usage);
                };
                FindInProjectUtil.findUsages(findModelCopy, this.myProject, (Processor<? super UsageInfo>)consumer2, processPresentation);
            }
            finally {
                this.myIsFindInProgress = false;
            }
        }, processPresentation, presentation2, null);
    }

    public boolean isWorkInProgress() {
        return this.myIsFindInProgress;
    }

    public boolean isEnabled() {
        return !this.myIsFindInProgress && !ReplaceInProjectManager.getInstance(this.myProject).isWorkInProgress();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/findInProject/FindInProjectManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findInProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findInPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "initModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startFindInProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

