/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.segmentedRunDebugWidget;

import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.segmentedRunDebugWidget.BaseExecutorActionWrapper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/segmentedRunDebugWidget/RunDebugConfigManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getState", "Lcom/intellij/execution/segmentedRunDebugWidget/RunDebugConfigManager$State;", "Companion", "State", "intellij.platform.execution.impl"})
public final class RunDebugConfigManager {
    private final Project project;
    private static final String ACTION_PREFIX = "RunDebugConfig_";
    @NotNull
    public static final String RUN_EXECUTOR_ID = "Run";
    @NotNull
    public static final String DEBUG_EXECUTOR_ID = "Debug";
    @NotNull
    public static final String PROFILE_EXECUTOR_ID = "Profiler";
    private static final List<String> ids;
    public static final Companion Companion;

    @NotNull
    public final State getState() {
        Map<String, List<RunnerAndConfigurationSettings>> runningMap = ExecutionManagerImpl.Companion.getInstance(this.project).getRunning(ids);
        boolean profiling = runningMap.containsKey(PROFILE_EXECUTOR_ID);
        boolean running = runningMap.containsKey(RUN_EXECUTOR_ID);
        boolean debugging = runningMap.containsKey(DEBUG_EXECUTOR_ID);
        if (profiling && running && debugging) {
            return State.RUNNING_DEBUGGING_PROFILING;
        }
        if (profiling && running && debugging) {
            return State.RUNNING_DEBUGGING_PROFILING;
        }
        if (running && debugging) {
            return State.RUNNING_DEBUGGING;
        }
        if (profiling && running) {
            return State.RUNNING_PROFILING;
        }
        if (profiling && debugging) {
            return State.DEBUGGING_PROFILING;
        }
        if (profiling) {
            List<RunnerAndConfigurationSettings> list2 = runningMap.get(PROFILE_EXECUTOR_ID);
            if (list2 != null) {
                List<RunnerAndConfigurationSettings> list3 = list2;
                boolean bl = false;
                boolean bl2 = false;
                List<RunnerAndConfigurationSettings> it = list3;
                boolean bl3 = false;
                return it.size() > 1 ? State.PROFILING_SEVERAL : State.PROFILING;
            }
        }
        if (debugging) {
            List<RunnerAndConfigurationSettings> list4 = runningMap.get(DEBUG_EXECUTOR_ID);
            if (list4 != null) {
                List<RunnerAndConfigurationSettings> list5 = list4;
                boolean bl = false;
                boolean bl4 = false;
                List<RunnerAndConfigurationSettings> it = list5;
                boolean bl5 = false;
                return it.size() > 1 ? State.DEBUGGING_SEVERAL : State.DEBUGGING;
            }
        }
        if (running) {
            List<RunnerAndConfigurationSettings> list6 = runningMap.get(RUN_EXECUTOR_ID);
            if (list6 != null) {
                List<RunnerAndConfigurationSettings> list7 = list6;
                boolean bl = false;
                boolean bl6 = false;
                List<RunnerAndConfigurationSettings> it = list7;
                boolean bl7 = false;
                return it.size() > 1 ? State.RUNNING_SEVERAL : State.RUNNING;
            }
        }
        return State.DEFAULT;
    }

    public RunDebugConfigManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        ids = CollectionsKt.listOf((Object[])new String[]{RUN_EXECUTOR_ID, DEBUG_EXECUTOR_ID, PROFILE_EXECUTOR_ID});
    }

    @JvmStatic
    @Nullable
    public static final AnAction wrapAction(@NotNull Executor executor, @NotNull AnAction action2) {
        return Companion.wrapAction(executor, action2);
    }

    @JvmStatic
    @NotNull
    public static final String generateActionID(@NotNull Executor executor) {
        return Companion.generateActionID(executor);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/execution/segmentedRunDebugWidget/RunDebugConfigManager$State;", "", "running", "", "debugging", "profiling", "(Ljava/lang/String;IZZZ)V", "getDebugging", "()Z", "getProfiling", "getRunning", "RUNNING_DEBUGGING_PROFILING", "RUNNING_PROFILING", "DEBUGGING_PROFILING", "RUNNING_DEBUGGING", "PROFILING_SEVERAL", "DEBUGGING_SEVERAL", "RUNNING_SEVERAL", "DEBUGGING_PAUSED", "PROFILING", "DEBUGGING", "RUNNING", "DEFAULT", "intellij.platform.execution.impl"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State RUNNING_DEBUGGING_PROFILING;
        public static final /* enum */ State RUNNING_PROFILING;
        public static final /* enum */ State DEBUGGING_PROFILING;
        public static final /* enum */ State RUNNING_DEBUGGING;
        public static final /* enum */ State PROFILING_SEVERAL;
        public static final /* enum */ State DEBUGGING_SEVERAL;
        public static final /* enum */ State RUNNING_SEVERAL;
        public static final /* enum */ State DEBUGGING_PAUSED;
        public static final /* enum */ State PROFILING;
        public static final /* enum */ State DEBUGGING;
        public static final /* enum */ State RUNNING;
        public static final /* enum */ State DEFAULT;
        private static final /* synthetic */ State[] $VALUES;
        private final boolean running;
        private final boolean debugging;
        private final boolean profiling;

        static {
            State[] stateArray = new State[12];
            State[] stateArray2 = stateArray;
            stateArray[0] = RUNNING_DEBUGGING_PROFILING = new State(true, true, true);
            stateArray[1] = RUNNING_PROFILING = new State("RUNNING_PROFILING", 1, true, false, true, 2, null);
            stateArray[2] = DEBUGGING_PROFILING = new State("DEBUGGING_PROFILING", 2, false, true, true, 1, null);
            stateArray[3] = RUNNING_DEBUGGING = new State("RUNNING_DEBUGGING", 3, true, true, false, 4, null);
            stateArray[4] = PROFILING_SEVERAL = new State("PROFILING_SEVERAL", 4, false, false, true, 3, null);
            stateArray[5] = DEBUGGING_SEVERAL = new State("DEBUGGING_SEVERAL", 5, false, true, false, 5, null);
            stateArray[6] = RUNNING_SEVERAL = new State("RUNNING_SEVERAL", 6, true, false, false, 6, null);
            stateArray[7] = DEBUGGING_PAUSED = new State("DEBUGGING_PAUSED", 7, false, true, false, 5, null);
            stateArray[8] = PROFILING = new State("PROFILING", 8, false, false, true, 3, null);
            stateArray[9] = DEBUGGING = new State("DEBUGGING", 9, false, true, false, 5, null);
            stateArray[10] = RUNNING = new State("RUNNING", 10, true, false, false, 6, null);
            stateArray[11] = DEFAULT = new State("DEFAULT", 11, false, false, false, 7, null);
            $VALUES = stateArray;
        }

        public final boolean getRunning() {
            return this.running;
        }

        public final boolean getDebugging() {
            return this.debugging;
        }

        public final boolean getProfiling() {
            return this.profiling;
        }

        private State(boolean running, boolean debugging, boolean profiling) {
            this.running = running;
            this.debugging = debugging;
            this.profiling = profiling;
        }

        /* synthetic */ State(String string, int n, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            if ((n2 & 4) != 0) {
                bl3 = false;
            }
            this(bl, bl2, bl3);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/segmentedRunDebugWidget/RunDebugConfigManager$Companion;", "", "()V", "ACTION_PREFIX", "", "DEBUG_EXECUTOR_ID", "PROFILE_EXECUTOR_ID", "RUN_EXECUTOR_ID", "ids", "", "generateActionID", "executor", "Lcom/intellij/execution/Executor;", "getInstance", "Lcom/intellij/execution/segmentedRunDebugWidget/RunDebugConfigManager;", "project", "Lcom/intellij/openapi/project/Project;", "wrapAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "action", "intellij.platform.execution.impl"})
    public static final class Companion {
        @NotNull
        public final RunDebugConfigManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(RunDebugConfigManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (RunDebugConfigManager)object;
        }

        @JvmStatic
        @Nullable
        public final AnAction wrapAction(@NotNull Executor executor, @NotNull AnAction action2) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            if (ids.contains(executor.getId())) {
                return new BaseExecutorActionWrapper(executor, action2);
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final String generateActionID(@NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            return "RunDebugConfig__" + executor.getId();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

