/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.logging.EditLogPatternDialog;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.ui.NestedGroupFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.SmartList;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LogsFragment<T extends RunConfigurationBase<?>>
extends NestedGroupFragment<T> {
    private final Map<LogFileOptions, PredefinedLogFile> myLog2Predefined = new HashMap<LogFileOptions, PredefinedLogFile>();
    private final List<PredefinedLogFile> myUnresolvedPredefined = new SmartList();
    private final TableView<LogFileOptions> myFilesTable;
    private final ListTableModel<LogFileOptions> myModel;

    public LogsFragment() {
        super("log.monitor", DiagnosticBundle.message("log.monitor.fragment.name", new Object[0]), DiagnosticBundle.message("log.monitor.fragment.group", new Object[0]), t -> !t.getLogFiles().isEmpty());
        this.setActionHint(ExecutionBundle.message((String)"the.ide.will.display.the.selected.logs.in.the.run.tool.window", (Object[])new Object[0]));
        TabNameColumnInfo TAB_NAME = new TabNameColumnInfo();
        FileColumnInfo FILE = new FileColumnInfo();
        MyIsActiveColumnInfo IS_SHOW = new MyIsActiveColumnInfo();
        MyIsSkipColumnInfo IS_SKIP_CONTENT = new MyIsSkipColumnInfo();
        this.myModel = new ListTableModel(new ColumnInfo[]{TAB_NAME, FILE, IS_SHOW, IS_SKIP_CONTENT});
        this.myFilesTable = new TableView(this.myModel);
        this.myFilesTable.getEmptyText().setText(DiagnosticBundle.message("log.monitor.no.files", new Object[0]));
        JTableHeader tableHeader = this.myFilesTable.getTableHeader();
        FontMetrics fontMetrics = tableHeader.getFontMetrics(tableHeader.getFont());
        int preferredWidth = fontMetrics.stringWidth(IS_SHOW.getName()) + 20;
        this.setUpColumnWidth(tableHeader, preferredWidth, 2);
        preferredWidth = fontMetrics.stringWidth(IS_SKIP_CONTENT.getName()) + 20;
        this.setUpColumnWidth(tableHeader, preferredWidth, 3);
        this.setUpColumnWidth(tableHeader, 100, 0);
        this.myFilesTable.setColumnSelectionAllowed(false);
        this.myFilesTable.setShowGrid(false);
        this.myFilesTable.setDragEnabled(false);
        this.myFilesTable.setShowHorizontalLines(false);
        this.myFilesTable.setShowVerticalLines(false);
        this.myFilesTable.setIntercellSpacing(new Dimension(0, 0));
        this.myFilesTable.setupEasyFocusTraversing();
        this.myComponent = ToolbarDecorator.createDecorator(this.myFilesTable).setToolbarPosition(ActionToolbarPosition.BOTTOM).setAddAction(button2 -> {
            ArrayList<LogFileOptions> newList = new ArrayList<LogFileOptions>(this.myModel.getItems());
            LogFileOptions newOptions = new LogFileOptions("", "", true);
            if (LogsFragment.showEditorDialog(newOptions)) {
                newList.add(newOptions);
                this.myModel.setItems(newList);
                int index = this.myModel.getRowCount() - 1;
                this.myModel.fireTableRowsInserted(index, index);
                this.myFilesTable.setRowSelectionInterval(index, index);
            }
        }).setRemoveAction(button2 -> {
            int i2;
            TableUtil.stopEditing(this.myFilesTable);
            int[] selected2 = this.myFilesTable.getSelectedRows();
            if (selected2.length == 0) {
                return;
            }
            for (i2 = selected2.length - 1; i2 >= 0; --i2) {
                this.myModel.removeRow(selected2[i2]);
            }
            for (i2 = selected2.length - 1; i2 >= 0; --i2) {
                int idx = selected2[i2];
                this.myModel.fireTableRowsDeleted(idx, idx);
            }
            int selection = selected2[0];
            if (selection >= this.myModel.getRowCount()) {
                selection = this.myModel.getRowCount() - 1;
            }
            if (selection >= 0) {
                this.myFilesTable.setRowSelectionInterval(selection, selection);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myFilesTable, true));
        }).setEditAction(button2 -> {
            int selectedRow = this.myFilesTable.getSelectedRow();
            LogsFragment.showEditorDialog((LogFileOptions)this.myFilesTable.getSelectedObject());
            this.myModel.fireTableDataChanged();
            this.myFilesTable.setRowSelectionInterval(selectedRow, selectedRow);
        }).setRemoveActionUpdater(e -> this.myFilesTable.getSelectedRowCount() >= 1 && !this.myLog2Predefined.containsKey(this.myFilesTable.getSelectedObject())).setEditActionUpdater(e -> this.myFilesTable.getSelectedRowCount() >= 1 && !this.myLog2Predefined.containsKey(this.myFilesTable.getSelectedObject()) && this.myFilesTable.getSelectedObject() != null).disableUpDownActions().createPanel();
    }

    private void setUpColumnWidth(JTableHeader tableHeader, int preferredWidth, int columnIdx) {
        this.myFilesTable.getColumnModel().getColumn(columnIdx).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        TableColumn tableColumn = tableHeader.getColumnModel().getColumn(columnIdx);
        tableColumn.setWidth(preferredWidth);
        tableColumn.setPreferredWidth(preferredWidth);
        tableColumn.setMinWidth(preferredWidth);
        tableColumn.setMaxWidth(preferredWidth);
    }

    protected void resetEditorFrom(@NotNull T configuration) {
        if (configuration == null) {
            LogsFragment.$$$reportNull$$$0(0);
        }
        super.resetEditorFrom(configuration);
        ArrayList<LogFileOptions> list2 = new ArrayList<LogFileOptions>();
        List logFiles = configuration.getLogFiles();
        for (LogFileOptions setting : logFiles) {
            list2.add(new LogFileOptions(setting.getName(), setting.getPathPattern(), setting.isEnabled(), setting.isSkipContent(), setting.isShowAll()));
        }
        this.myLog2Predefined.clear();
        this.myUnresolvedPredefined.clear();
        List predefinedLogFiles = configuration.getPredefinedLogFiles();
        for (PredefinedLogFile predefinedLogFile : predefinedLogFiles) {
            PredefinedLogFile logFile = new PredefinedLogFile();
            logFile.copyFrom((BaseState)predefinedLogFile);
            LogFileOptions options2 = configuration.getOptionsForPredefinedLogFile(logFile);
            if (options2 != null) {
                this.myLog2Predefined.put(options2, logFile);
                list2.add(options2);
                continue;
            }
            this.myUnresolvedPredefined.add(logFile);
        }
        this.myModel.setItems(list2);
    }

    protected void applyEditorTo(@NotNull T configuration) {
        if (configuration == null) {
            LogsFragment.$$$reportNull$$$0(1);
        }
        super.applyEditorTo(configuration);
        configuration.removeAllLogFiles();
        configuration.removeAllPredefinedLogFiles();
        if (!this.isSelected()) {
            return;
        }
        for (int i2 = 0; i2 < this.myModel.getRowCount(); ++i2) {
            LogFileOptions options2 = (LogFileOptions)this.myModel.getItem(i2);
            if (Objects.equals(options2.getPathPattern(), "")) continue;
            Boolean checked = (Boolean)this.myModel.getValueAt(i2, 2);
            Boolean skipped = (Boolean)this.myModel.getValueAt(i2, 3);
            PredefinedLogFile predefined = this.myLog2Predefined.get(options2);
            if (predefined != null) {
                PredefinedLogFile file2 = new PredefinedLogFile();
                file2.setId(predefined.getId());
                file2.setEnabled(options2.isEnabled());
                configuration.addPredefinedLogFile(file2);
                continue;
            }
            configuration.addLogFile(options2.getPathPattern(), options2.getName(), checked.booleanValue(), skipped.booleanValue(), options2.isShowAll());
        }
        for (PredefinedLogFile logFile : this.myUnresolvedPredefined) {
            configuration.addPredefinedLogFile(logFile);
        }
    }

    protected List<SettingsEditorFragment<T, ?>> createChildren() {
        TextFieldWithBrowseButton myOutputFile = new TextFieldWithBrowseButton();
        myOutputFile.addBrowseFolderListener(ExecutionBundle.message((String)"choose.file.to.save.console.output", (Object[])new Object[0]), ExecutionBundle.message((String)"console.output.would.be.saved.to.the.specified.file", (Object[])new Object[0]), null, FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        LabeledComponent component2 = LabeledComponent.create((JComponent)myOutputFile, (String)ExecutionBundle.message((String)"save.output.console.to.file", (Object[])new Object[0]), (String)"West");
        SettingsEditorFragment fragment = new SettingsEditorFragment("logs.save.output", ExecutionBundle.message((String)"save.output.console.to.file.option", (Object[])new Object[0]), null, (JComponent)component2, (t, component1) -> ((TextFieldWithBrowseButton)component1.getComponent()).setText(StringUtil.notNullize((String)t.getOutputFilePath())), (t, component1) -> {
            t.setFileOutputPath(((TextFieldWithBrowseButton)component1.getComponent()).getText());
            t.setSaveOutputToFile(StringUtil.isNotEmpty((String)((TextFieldWithBrowseButton)component2.getComponent()).getText()));
        }, t -> t.isSaveOutputToFile());
        fragment.setActionHint(ExecutionBundle.message((String)"write.the.output.of.the.application.to.a.file.for.later.inspection", (Object[])new Object[0]));
        SettingsEditorFragment stdOut = SettingsEditorFragment.createTag((String)"logs.stdout", (String)DiagnosticBundle.message("log.monitor.fragment.stdout", new Object[0]), null, t -> t.isShowConsoleOnStdOut(), (t, value2) -> t.setShowConsoleOnStdOut(value2.booleanValue()));
        stdOut.setActionHint(ExecutionBundle.message((String)"activate.the.console.when.the.application.writes.to.the.standard.output.stream", (Object[])new Object[0]));
        SettingsEditorFragment stdErr = SettingsEditorFragment.createTag((String)"logs.stderr", (String)DiagnosticBundle.message("log.monitor.fragment.stderr", new Object[0]), null, t -> t.isShowConsoleOnStdErr(), (t, value2) -> t.setShowConsoleOnStdErr(value2.booleanValue()));
        stdErr.setActionHint(ExecutionBundle.message((String)"activate.the.console.when.the.application.writes.to.the.standard.error.stream", (Object[])new Object[0]));
        return Arrays.asList(fragment, stdOut, stdErr);
    }

    public String getChildrenGroupName() {
        return DiagnosticBundle.message("log.monitor.fragment.settings", new Object[0]);
    }

    private static boolean showEditorDialog(@NotNull LogFileOptions options2) {
        if (options2 == null) {
            LogsFragment.$$$reportNull$$$0(2);
        }
        EditLogPatternDialog dialog2 = new EditLogPatternDialog();
        dialog2.init(options2.getName(), options2.getPathPattern(), options2.isShowAll());
        if (dialog2.showAndGet()) {
            options2.setName(dialog2.getName());
            options2.setPathPattern(dialog2.getLogPattern());
            options2.setShowAll(dialog2.isShowAllFiles());
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/logging/LogsFragment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showEditorDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyIsSkipColumnInfo
    extends ColumnInfo<LogFileOptions, Boolean> {
        protected MyIsSkipColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.is.skipped.column", new Object[0]));
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(LogFileOptions element2) {
            return element2.isSkipContent();
        }

        public boolean isCellEditable(LogFileOptions element2) {
            return !LogsFragment.this.myLog2Predefined.containsKey(element2);
        }

        public void setValue(LogFileOptions element2, Boolean skipped) {
            element2.setSkipContent(skipped.booleanValue());
        }
    }

    private class MyIsActiveColumnInfo
    extends ColumnInfo<LogFileOptions, Boolean> {
        protected MyIsActiveColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.is.active.column", new Object[0]));
        }

        public Class<?> getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(LogFileOptions object) {
            return object.isEnabled();
        }

        public boolean isCellEditable(LogFileOptions element2) {
            return true;
        }

        public void setValue(LogFileOptions element2, Boolean checked) {
            PredefinedLogFile predefinedLogFile = LogsFragment.this.myLog2Predefined.get(element2);
            if (predefinedLogFile != null) {
                predefinedLogFile.setEnabled(checked.booleanValue());
            }
            element2.setEnabled(checked.booleanValue());
        }
    }

    private class FileColumnInfo
    extends ColumnInfo<LogFileOptions, String> {
        FileColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.file.column", new Object[0]));
        }

        public String valueOf(LogFileOptions object) {
            return object.getPathPattern();
        }

        public void setValue(LogFileOptions options2, String value2) {
            options2.setPathPattern(value2);
        }

        public boolean isCellEditable(LogFileOptions o) {
            return !LogsFragment.this.myLog2Predefined.containsKey(o);
        }

        @Nullable
        public TableCellEditor getEditor(LogFileOptions options2) {
            return new LocalPathCellEditor();
        }
    }

    private class TabNameColumnInfo
    extends ColumnInfo<LogFileOptions, String> {
        TabNameColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.tab.name.column", new Object[0]));
        }

        @Nullable
        public TableCellRenderer getRenderer(LogFileOptions options2) {
            return new DefaultTableCellRenderer();
        }

        public String valueOf(LogFileOptions object) {
            return object.getName();
        }

        public void setValue(LogFileOptions options2, String value2) {
            options2.setName(value2);
        }

        public boolean isCellEditable(LogFileOptions o) {
            return !LogsFragment.this.myLog2Predefined.containsKey(o);
        }
    }
}

