/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.EditXmxVMOptionDialog;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.hprof.action.HeapDumpSnapshotRunnable;
import com.intellij.diagnostic.report.MemoryReportReason;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.IdeBundle;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.LowMemoryWatcher;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LowMemoryNotifier
implements Disposable {
    private static final int UI_RESPONSE_LOGGING_INTERVAL_MS = 100000;
    private static final int TOLERABLE_UI_LATENCY = 100;
    private final LowMemoryWatcher myWatcher = LowMemoryWatcher.register(this::onLowMemorySignalReceived, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC);
    private final AtomicBoolean myNotificationShown = new AtomicBoolean();
    private volatile long myPreviousLoggedUIResponse = 0L;

    LowMemoryNotifier() {
        final boolean isDebugEnabled = DebugAttachDetector.isDebugEnabled();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(IdePerformanceListener.TOPIC, (Object)new IdePerformanceListener(){

            public void uiFreezeFinished(long durationMs, @Nullable File reportDir) {
                if (!isDebugEnabled) {
                    LifecycleUsageTriggerCollector.onFreeze(durationMs);
                }
            }

            public void uiResponded(long latencyMs) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - LowMemoryNotifier.this.myPreviousLoggedUIResponse >= 100000L) {
                    LowMemoryNotifier.this.myPreviousLoggedUIResponse = currentTime;
                    UILatencyLogger.LATENCY.log((Object)latencyMs);
                }
                if (latencyMs >= 100L && !isDebugEnabled) {
                    UILatencyLogger.LAGGING.log((Object)latencyMs);
                }
            }
        });
    }

    private void onLowMemorySignalReceived() {
        if (this.myNotificationShown.compareAndSet(false, true)) {
            Notification notification2 = new Notification(NotificationGroup.createIdWithTitle((String)"Low Memory", (String)IdeBundle.message((String)"low.memory.notification.title", (Object[])new Object[0])), IdeBundle.message((String)"low.memory.notification.title", (Object[])new Object[0]), IdeBundle.message((String)"low.memory.notification.content", (Object[])new Object[0]), NotificationType.WARNING);
            notification2.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"low.memory.notification.analyze.action", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    new HeapDumpSnapshotRunnable(MemoryReportReason.UserInvoked, HeapDumpSnapshotRunnable.AnalysisOption.SCHEDULE_ON_NEXT_START).run();
                    notification2.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/diagnostic/LowMemoryNotifier$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            notification2.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"low.memory.notification.action", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (notification2 == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    Runtime rt = Runtime.getRuntime();
                    new EditXmxVMOptionDialog(rt.freeMemory(), rt.maxMemory()).show();
                    notification2.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/diagnostic/LowMemoryNotifier$3";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            Notifications.Bus.notify((Notification)notification2);
        }
    }

    public void dispose() {
        this.myWatcher.stop();
    }

    public static final class UILatencyLogger
    extends CounterUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("performance", 57);
        private static final EventId1<Long> LATENCY = GROUP.registerEvent("ui.latency", (EventField)EventFields.Long((String)"duration_ms"));
        private static final EventId1<Long> LAGGING = GROUP.registerEvent("ui.lagging", (EventField)EventFields.Long((String)"duration_ms"));

        public EventLogGroup getGroup() {
            return GROUP;
        }
    }
}

