/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.StatisticsUpdate;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.WeakReferenceDisposableWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.util.Alarm;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\bH\u0016J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/completion/StatisticsUpdate;", "Lcom/intellij/openapi/Disposable;", "myInfo", "Lcom/intellij/psi/statistics/StatisticsInfo;", "(Lcom/intellij/psi/statistics/StatisticsInfo;)V", "mySpared", "", "addSparedChars", "", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "dispose", "trackStatistics", "Companion", "DocumentChangeListener", "intellij.platform.lang.impl"})
public final class StatisticsUpdate
implements Disposable {
    private int mySpared;
    private final StatisticsInfo myInfo;
    private static final Alarm ourStatsAlarm;
    private static StatisticsUpdate ourPendingUpdate;
    public static final Companion Companion;

    public void dispose() {
    }

    public final void addSparedChars(@NotNull Lookup lookup2, @NotNull LookupElement item, @NotNull InsertionContext context) {
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String textInserted = null;
        if (context.getOffsetMap().containsOffset(CompletionInitializationContext.START_OFFSET) && context.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET) && context.getTailOffset() >= context.getStartOffset()) {
            Document document = context.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"context.document");
            textInserted = ((Object)document.getImmutableCharSequence().subSequence(context.getStartOffset(), context.getTailOffset())).toString();
        } else {
            String string = item.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.lookupString");
            textInserted = string;
        }
        String string = StringUtil.replace((String)textInserted, (List)CollectionsKt.listOf((Object[])new String[]{" ", "\t", "\n"}), (List)CollectionsKt.listOf((Object[])new String[]{"", "", ""}));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.replace(textI\u2026\\n\"), listOf(\"\", \"\", \"\"))");
        String withoutSpaces = string;
        int spared = withoutSpaces.length() - lookup2.itemPattern(item).length();
        char completionChar = context.getCompletionChar();
        if (!LookupEvent.isSpecialCompletionChar((char)completionChar) && StringsKt.contains$default((CharSequence)withoutSpaces, (CharSequence)String.valueOf(completionChar), (boolean)false, (int)2, null)) {
            --spared;
        }
        if (spared > 0) {
            this.mySpared += spared;
        }
    }

    public final void trackStatistics(@NotNull InsertionContext context) {
        int tailOffset;
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (ourPendingUpdate != this) {
            return;
        }
        if (!context.getOffsetMap().containsOffset(CompletionInitializationContext.START_OFFSET)) {
            return;
        }
        Document document = context.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"context.document");
        Document document2 = document;
        int startOffset = context.getStartOffset();
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"context.editor");
        if (editor.getSelectionModel().hasSelection()) {
            Editor editor2 = context.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"context.editor");
            SelectionModel selectionModel = editor2.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"context.editor.selectionModel");
            n = selectionModel.getSelectionStart();
        } else {
            Editor editor3 = context.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"context.editor");
            CaretModel caretModel = editor3.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"context.editor.caretModel");
            n = tailOffset = caretModel.getOffset();
        }
        if (startOffset < 0 || tailOffset <= startOffset) {
            return;
        }
        RangeMarker rangeMarker = document2.createRangeMarker(startOffset, tailOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"document.createRangeMark\u2026(startOffset, tailOffset)");
        RangeMarker marker = rangeMarker;
        DocumentChangeListener listener2 = new DocumentChangeListener(document2, marker);
        document2.addDocumentListener((DocumentListener)listener2);
        Disposer.register((Disposable)this, (Disposable)((Disposable)new WeakReferenceDisposableWrapper((Disposable)listener2)));
        ourStatsAlarm.addRequest(new Runnable(this){
            final /* synthetic */ StatisticsUpdate this$0;

            public final void run() {
                if (StatisticsUpdate.access$getOurPendingUpdate$cp() == this.this$0) {
                    StatisticsUpdate.Companion.applyLastCompletionStatisticsUpdate();
                }
            }
            {
                this.this$0 = statisticsUpdate;
            }
        }, 20000);
        Disposer.register((Disposable)this, (Disposable)trackStatistics.2.INSTANCE);
    }

    private StatisticsUpdate(StatisticsInfo myInfo) {
        this.myInfo = myInfo;
    }

    static {
        Companion = new Companion(null);
        ourStatsAlarm = new Alarm((Disposable)ApplicationManager.getApplication());
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)Companion.1.INSTANCE);
    }

    public static final /* synthetic */ Alarm access$getOurStatsAlarm$cp() {
        return ourStatsAlarm;
    }

    public /* synthetic */ StatisticsUpdate(StatisticsInfo myInfo, DefaultConstructorMarker $constructor_marker) {
        this(myInfo);
    }

    public static final /* synthetic */ void access$setMySpared$p(StatisticsUpdate $this, int n) {
        $this.mySpared = n;
    }

    @VisibleForTesting
    @JvmStatic
    @NotNull
    public static final StatisticsUpdate collectStatisticChanges(@NotNull LookupElement item) {
        return Companion.collectStatisticChanges(item);
    }

    @JvmStatic
    public static final void cancelLastCompletionStatisticsUpdate() {
        Companion.cancelLastCompletionStatisticsUpdate();
    }

    @JvmStatic
    public static final void applyLastCompletionStatisticsUpdate() {
        Companion.applyLastCompletionStatisticsUpdate();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/completion/StatisticsUpdate$DocumentChangeListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/openapi/Disposable;", "document", "Lcom/intellij/openapi/editor/Document;", "marker", "Lcom/intellij/openapi/editor/RangeMarker;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/RangeMarker;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "beforeDocumentChange", "", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "dispose", "intellij.platform.lang.impl"})
    private static final class DocumentChangeListener
    implements DocumentListener,
    Disposable {
        @NotNull
        private final Document document;
        @NotNull
        private final RangeMarker marker;

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.marker.isValid() || e.getOffset() > this.marker.getStartOffset() && e.getOffset() < this.marker.getEndOffset()) {
                Companion.cancelLastCompletionStatisticsUpdate();
            }
        }

        public void dispose() {
            this.document.removeDocumentListener((DocumentListener)this);
            this.marker.dispose();
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @NotNull
        public final RangeMarker getMarker() {
            return this.marker;
        }

        public DocumentChangeListener(@NotNull Document document, @NotNull RangeMarker marker) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            this.document = document;
            this.marker = marker;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/completion/StatisticsUpdate$Companion;", "", "()V", "ourPendingUpdate", "Lcom/intellij/codeInsight/completion/StatisticsUpdate;", "ourStatsAlarm", "Lcom/intellij/util/Alarm;", "applyLastCompletionStatisticsUpdate", "", "cancelLastCompletionStatisticsUpdate", "collectStatisticChanges", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @VisibleForTesting
        @JvmStatic
        @NotNull
        public final StatisticsUpdate collectStatisticChanges(@NotNull LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.applyLastCompletionStatisticsUpdate();
            StatisticsInfo statisticsInfo = StatisticsWeigher.getBaseStatisticsInfo(item, null);
            Intrinsics.checkNotNullExpressionValue((Object)statisticsInfo, (String)"StatisticsWeigher.getBas\u2026tatisticsInfo(item, null)");
            StatisticsInfo base = statisticsInfo;
            if (base == StatisticsInfo.EMPTY) {
                StatisticsInfo statisticsInfo2 = StatisticsInfo.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)statisticsInfo2, (String)"StatisticsInfo.EMPTY");
                return new StatisticsUpdate(statisticsInfo2, null);
            }
            StatisticsUpdate update2 = new StatisticsUpdate(base, null);
            ourPendingUpdate = update2;
            Disposer.register((Disposable)update2, (Disposable)collectStatisticChanges.1.INSTANCE);
            return update2;
        }

        @JvmStatic
        public final void cancelLastCompletionStatisticsUpdate() {
            boolean bl;
            boolean bl2;
            StatisticsUpdate statisticsUpdate = ourPendingUpdate;
            if (statisticsUpdate != null) {
                StatisticsUpdate statisticsUpdate2 = statisticsUpdate;
                bl2 = false;
                bl = false;
                StatisticsUpdate it = statisticsUpdate2;
                boolean bl3 = false;
                Disposer.dispose((Disposable)it);
            }
            boolean bl4 = ourPendingUpdate == null;
            bl2 = false;
            bl = false;
            if (_Assertions.ENABLED && !bl4) {
                boolean bl5 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }

        @JvmStatic
        public final void applyLastCompletionStatisticsUpdate() {
            StatisticsUpdate statisticsUpdate = ourPendingUpdate;
            if (statisticsUpdate != null) {
                StatisticsUpdate statisticsUpdate2 = statisticsUpdate;
                boolean bl = false;
                boolean bl2 = false;
                StatisticsUpdate it = statisticsUpdate2;
                boolean bl3 = false;
                StatisticsManager.getInstance().incUseCount(it.myInfo);
                FeatureUsageTracker featureUsageTracker = FeatureUsageTracker.getInstance();
                if (featureUsageTracker == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.featureStatistics.FeatureUsageTrackerImpl");
                }
                ((FeatureUsageTrackerImpl)featureUsageTracker).getCompletionStatistics().registerInvocation(it.mySpared);
            }
            this.cancelLastCompletionStatisticsUpdate();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

