/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ChangesDiffCalculator;
import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.NewCodeStyleSettingsPanel;
import com.intellij.ide.ui.search.ComponentHighlightingListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.PresentableEnumUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.border.AbstractBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleAbstractPanel
implements Disposable,
ComponentHighlightingListener {
    private static final long TIME_TO_HIGHLIGHT_PREVIEW_CHANGES_IN_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private static final Logger LOG = Logger.getInstance(CodeStyleAbstractPanel.class);
    private final List<TextRange> myPreviewRangesToHighlight;
    private final EditorEx myEditor;
    private final CodeStyleSettings mySettings;
    private boolean myShouldUpdatePreview;
    private long myLastDocumentModificationStamp;
    private String myTextToReformat;
    private final UserActivityWatcher myUserActivityWatcher;
    private final Alarm myUpdateAlarm;
    @Nullable
    private CodeStyleSchemesModel myModel;
    private boolean mySomethingChanged;
    private long myEndHighlightPreviewChangesTimeMillis;
    private boolean myShowsPreviewHighlighters;
    private final CodeStyleSettings myCurrentSettings;
    private final Language myDefaultLanguage;
    private Document myDocumentBeforeChanges;
    @Nullable
    private String myLastSearchString;

    protected CodeStyleAbstractPanel(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(0);
        }
        this(null, null, settings);
    }

    protected CodeStyleAbstractPanel(@Nullable Language defaultLanguage, @Nullable CodeStyleSettings currentSettings, @NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(1);
        }
        this.myPreviewRangesToHighlight = new ArrayList<TextRange>();
        this.myUserActivityWatcher = new UserActivityWatcher();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myEndHighlightPreviewChangesTimeMillis = -1L;
        this.myCurrentSettings = currentSettings;
        this.mySettings = settings;
        this.myDefaultLanguage = defaultLanguage;
        this.myEditor = this.createEditor();
        if (this.myEditor != null) {
            this.myUpdateAlarm.setActivationComponent(this.myEditor.getComponent());
        }
        this.myUserActivityWatcher.addUserActivityListener(() -> this.somethingChanged());
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ComponentHighlightingListener.TOPIC, (Object)this);
        this.updatePreview(true);
    }

    protected void setShouldUpdatePreview(boolean shouldUpdatePreview) {
        this.myShouldUpdatePreview = shouldUpdatePreview;
    }

    private synchronized void setSomethingChanged(boolean b) {
        this.mySomethingChanged = b;
    }

    private synchronized boolean isSomethingChanged() {
        return this.mySomethingChanged;
    }

    public void setModel(@NotNull CodeStyleSchemesModel model2) {
        if (model2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(2);
        }
        this.myModel = model2;
    }

    protected void somethingChanged() {
        if (this.myModel != null) {
            this.myModel.fireBeforeCurrentSettingsChanged();
        }
    }

    protected void addPanelToWatch(Component component2) {
        this.myUserActivityWatcher.register(component2);
    }

    @Nullable
    private EditorEx createEditor() {
        if (StringUtil.isEmpty((String)this.getPreviewText())) {
            return null;
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(editorDocument);
        CodeStyleAbstractPanel.fillEditorSettings(editor.getSettings());
        this.myLastDocumentModificationStamp = editor.getDocument().getModificationStamp();
        return editor;
    }

    private static void fillEditorSettings(EditorSettings editorSettings) {
        editorSettings.setWhitespacesShown(true);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(0);
        editorSettings.setAdditionalLinesCount(1);
        editorSettings.setUseSoftWraps(false);
        editorSettings.setSoftMargins(Collections.emptyList());
    }

    protected void updatePreview(boolean useDefaultSample) {
        if (this.myEditor == null) {
            return;
        }
        this.updateEditor(useDefaultSample);
        this.updatePreviewHighlighter(this.myEditor);
    }

    private void updateEditor(boolean useDefaultSample) {
        if (!this.myShouldUpdatePreview || !ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getComponent().isShowing()) {
            return;
        }
        if (this.myEditor.isDisposed()) {
            return;
        }
        if (this.myLastDocumentModificationStamp != this.myEditor.getDocument().getModificationStamp()) {
            this.myTextToReformat = this.myEditor.getDocument().getText();
        } else if (useDefaultSample || this.myTextToReformat == null) {
            this.myTextToReformat = StringUtil.convertLineSeparators((String)((String)ObjectUtils.notNull((Object)this.getPreviewText(), (Object)"")));
        }
        this.updateEditorState(true);
    }

    protected void setEditorText(@NotNull String text2, boolean updateHighlighter) {
        if (text2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(3);
        }
        this.myTextToReformat = StringUtil.convertLineSeparators((String)text2);
        if (updateHighlighter) {
            this.updatePreviewHighlighter(this.myEditor);
        }
        this.updateEditorState(false);
    }

    private void updateEditorState(boolean collectChanges) {
        int currOffs = this.myEditor.getScrollingModel().getVerticalScrollOffset();
        Project project = ProjectUtil.guessCurrentProject((JComponent)this.getPanel());
        CommandProcessor.getInstance().executeCommand(project, () -> this.replaceText(project, collectChanges), null, null);
        this.myEditor.getSettings().setRightMargin(this.getAdjustedRightMargin());
        this.myLastDocumentModificationStamp = this.myEditor.getDocument().getModificationStamp();
        this.myEditor.getScrollingModel().scrollVertically(currOffs);
    }

    private int getAdjustedRightMargin() {
        int result2 = this.getRightMargin();
        return result2 > 0 ? result2 : CodeStyle.getSettings((Project)ProjectUtil.guessCurrentProject((JComponent)this.getPanel())).getRightMargin(this.getDefaultLanguage());
    }

    protected abstract int getRightMargin();

    private void replaceText(Project project, boolean collectChanges) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                Document beforeReformat = null;
                if (collectChanges && this.myEditor.getDocument().getTextLength() > 0) {
                    beforeReformat = this.collectChangesBeforeCurrentSettingsAppliance(project);
                }
                PsiFile psiFile = this.createFileFromText(project, this.myTextToReformat);
                this.prepareForReformat(psiFile);
                this.applySettingsToModel();
                Ref formatted = Ref.create();
                CodeStyle.doWithTemporarySettings((Project)project, (CodeStyleSettings)this.mySettings, settings -> {
                    settings.setRightMargin(this.getDefaultLanguage(), this.getAdjustedRightMargin());
                    this.myEditor.getSettings().setTabSize(settings.getTabSize(this.getFileType()));
                    formatted.set((Object)this.doReformat(project, psiFile));
                });
                DocumentEx document = this.myEditor.getDocument();
                document.replaceString(0, document.getTextLength(), ((PsiFile)formatted.get()).getText());
                if (beforeReformat != null) {
                    this.highlightChanges(beforeReformat);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private void applySettingsToModel() {
        if (this.mySettings instanceof CodeStyleSchemesModel.ModelSettings && ((CodeStyleSchemesModel.ModelSettings)this.mySettings).isLocked()) {
            return;
        }
        try {
            if (this.myModel != null && this.myModel.isUiEventsEnabled()) {
                this.apply(this.mySettings);
                this.myModel.fireAfterCurrentSettingsChanged();
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @Nullable
    private Document collectChangesBeforeCurrentSettingsAppliance(Project project) {
        PsiFile psiFile = this.createFileFromText(project, this.myTextToReformat);
        this.prepareForReformat(psiFile);
        CodeStyle.doWithTemporarySettings((Project)project, (CodeStyleSettings)this.mySettings, settings -> {
            settings.setRightMargin(this.getDefaultLanguage(), this.getAdjustedRightMargin());
            this.doReformat(project, psiFile);
        });
        return this.getDocumentBeforeChanges(project, psiFile);
    }

    private Document getDocumentBeforeChanges(@NotNull Project project, @NotNull PsiFile file2) {
        Document document;
        PsiDocumentManager documentManager;
        if (project == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(5);
        }
        if ((documentManager = PsiDocumentManager.getInstance((Project)project)) != null && (document = documentManager.getDocument(file2)) != null) {
            return document;
        }
        if (this.myDocumentBeforeChanges == null) {
            this.myDocumentBeforeChanges = new DocumentImpl(file2.getText());
        } else {
            this.myDocumentBeforeChanges.replaceString(0, this.myDocumentBeforeChanges.getTextLength(), (CharSequence)file2.getText());
        }
        return this.myDocumentBeforeChanges;
    }

    protected void prepareForReformat(PsiFile psiFile) {
    }

    protected String getFileExt() {
        return this.getFileTypeExtension(this.getFileType());
    }

    @Deprecated
    protected PsiFile createFileFromText(Project project, String text2) {
        PsiFile file2;
        LanguageCodeStyleSettingsProvider provider2;
        Language language = this.getDefaultLanguage();
        if (language != null && (provider2 = LanguageCodeStyleSettingsProvider.forLanguage((Language)language)) != null && (file2 = provider2.createFileFromText(project, text2)) != null) {
            if (file2.isPhysical()) {
                LOG.error(provider2.getClass() + " creates a physical file with PSI events enabled");
            }
            return file2;
        }
        return PsiFileFactory.getInstance((Project)project).createFileFromText("a." + this.getFileExt(), this.getFileType(), (CharSequence)text2, LocalTimeCounter.currentTime(), false);
    }

    protected PsiFile doReformat(Project project, PsiFile psiFile) {
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
        return psiFile;
    }

    private void highlightChanges(Document beforeReformat) {
        this.myPreviewRangesToHighlight.clear();
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        markupModel.removeAllHighlighters();
        this.myPreviewRangesToHighlight.addAll(ChangesDiffCalculator.calculateDiff(beforeReformat, this.myEditor.getDocument()));
        if (!this.myPreviewRangesToHighlight.isEmpty()) {
            this.myEndHighlightPreviewChangesTimeMillis = System.currentTimeMillis() + TIME_TO_HIGHLIGHT_PREVIEW_CHANGES_IN_MILLIS;
            this.myShowsPreviewHighlighters = true;
        }
    }

    private static boolean isWithinBounds(VisualPosition targetPosition, VisualPosition startPosition, VisualPosition endPosition) {
        return targetPosition.line >= startPosition.line && targetPosition.line <= endPosition.line && targetPosition.column >= startPosition.column && targetPosition.column <= endPosition.column;
    }

    private void updatePreviewHighlighter(EditorEx editor) {
        EditorColorsScheme scheme = editor.getColorsScheme();
        editor.getSettings().setCaretRowShown(false);
        EditorHighlighter highlighter = this.createHighlighter(scheme);
        if (highlighter != null) {
            editor.setHighlighter(highlighter);
        } else {
            LOG.warn("No highlighter for " + this.getDefaultLanguage());
        }
    }

    @Nullable
    protected abstract EditorHighlighter createHighlighter(EditorColorsScheme var1);

    @NotNull
    protected abstract FileType getFileType();

    @NonNls
    @Nullable
    protected abstract String getPreviewText();

    public abstract void apply(CodeStyleSettings var1) throws ConfigurationException;

    public final void reset(CodeStyleSettings settings) {
        this.myShouldUpdatePreview = false;
        try {
            this.resetImpl(settings);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myShouldUpdatePreview = true;
        }
    }

    public abstract boolean isModified(CodeStyleSettings var1);

    @Nullable
    public abstract JComponent getPanel();

    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
        if (this.myEditor != null) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }
    }

    protected abstract void resetImpl(CodeStyleSettings var1);

    protected static void fillWrappingCombo(@NotNull JComboBox<CodeStyleSettings.WrapStyle> wrapCombo) {
        if (wrapCombo == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(6);
        }
        PresentableEnumUtil.fill(wrapCombo, CodeStyleSettings.WrapStyle.class);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readFromFile(@NotNull Class<?> resourceContainerClass, @NonNls @NotNull String fileName) {
        if (resourceContainerClass == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(7);
        }
        if (fileName == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(8);
        }
        try (InputStream stream = resourceContainerClass.getClassLoader().getResourceAsStream("codeStyle/preview/" + fileName);){
            String string;
            block18: {
                LineNumberReader lineNumberReader = stream == null ? null : new LineNumberReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                try {
                    String line;
                    if (stream == null) {
                        throw new IOException("Resource not found: codeStyle/preview/" + fileName);
                    }
                    StringBuilder result2 = new StringBuilder();
                    while ((line = lineNumberReader.readLine()) != null) {
                        result2.append(line);
                        result2.append("\n");
                    }
                    string = result2.toString();
                    if (lineNumberReader == null) break block18;
                }
                catch (Throwable throwable) {
                    if (lineNumberReader != null) {
                        try {
                            lineNumberReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                lineNumberReader.close();
            }
            return string;
        }
        catch (IOException e) {
            LOG.error("Cannot load codestyle preview from" + fileName, (Throwable)e);
            return "";
        }
    }

    protected void installPreviewPanel(JPanel previewPanel) {
        previewPanel.setLayout(new BorderLayout());
        previewPanel.add((Component)this.getEditor().getComponent(), "Center");
        previewPanel.setBorder(new AbstractBorder(){
            private static final int LEFT_WHITE_SPACE = 2;

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Editor editor = CodeStyleAbstractPanel.this.getEditor();
                if (editor instanceof EditorEx) {
                    g.setColor(((EditorEx)editor).getBackgroundColor());
                    g.fillRect(x + 1, y, 2, height);
                }
                g.setColor(OnePixelDivider.BACKGROUND);
                g.fillRect(x, y, 1, height);
            }

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                insets.set(0, 3, 0, 0);
                return insets;
            }
        });
    }

    @NonNls
    @NotNull
    protected String getFileTypeExtension(@NotNull FileType fileType) {
        if (fileType == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(9);
        }
        String string = fileType.getDefaultExtension();
        if (string == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void onSomethingChanged() {
        this.setSomethingChanged(true);
        if (this.myEditor != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.updateEditor(true);
            } else {
                UiNotifyConnector.doWhenFirstShown((JComponent)this.myEditor.getComponent(), () -> this.addUpdatePreviewRequest());
            }
        } else {
            this.applySettingsToModel();
        }
    }

    private void addUpdatePreviewRequest() {
        this.myUpdateAlarm.addComponentRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    CodeStyleAbstractPanel.this.myUpdateAlarm.cancelAllRequests();
                    Project project = CodeStyleAbstractPanel.this.myEditor.getProject();
                    if (CodeStyleAbstractPanel.this.myEditor.isDisposed() || project != null && project.isDisposed()) {
                        return;
                    }
                    if (CodeStyleAbstractPanel.this.isSomethingChanged()) {
                        CodeStyleAbstractPanel.this.updateEditor(false);
                    }
                    if (System.currentTimeMillis() <= CodeStyleAbstractPanel.this.myEndHighlightPreviewChangesTimeMillis && !CodeStyleAbstractPanel.this.myPreviewRangesToHighlight.isEmpty()) {
                        CodeStyleAbstractPanel.this.blinkHighlighters();
                        CodeStyleAbstractPanel.this.myUpdateAlarm.addComponentRequest((Runnable)this, 500);
                    } else {
                        CodeStyleAbstractPanel.this.myEditor.getMarkupModel().removeAllHighlighters();
                    }
                }
                finally {
                    CodeStyleAbstractPanel.this.setSomethingChanged(false);
                }
            }
        }, 300);
    }

    private void blinkHighlighters() {
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        if (this.myShowsPreviewHighlighters) {
            Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
            VisualPosition visualStart = this.myEditor.xyToVisualPosition(visibleArea.getLocation());
            VisualPosition visualEnd = this.myEditor.xyToVisualPosition(new Point(visibleArea.x + visibleArea.width, visibleArea.y + visibleArea.height));
            int endColumnCandidate = visibleArea.width / EditorUtil.getSpaceWidth(0, this.myEditor) + visualStart.column;
            if (endColumnCandidate > visualEnd.column) {
                visualEnd = new VisualPosition(visualEnd.line, endColumnCandidate);
            }
            int offsetToScroll = -1;
            CharSequence text2 = this.myEditor.getDocument().getCharsSequence();
            TextAttributes backgroundAttributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            TextAttributes borderAttributes = new TextAttributes(null, null, backgroundAttributes.getBackgroundColor(), EffectType.BOXED, 0);
            boolean scrollToChange = true;
            for (TextRange range2 : this.myPreviewRangesToHighlight) {
                if (scrollToChange) {
                    boolean rangeVisible = CodeStyleAbstractPanel.isWithinBounds(this.myEditor.offsetToVisualPosition(range2.getStartOffset()), visualStart, visualEnd) || CodeStyleAbstractPanel.isWithinBounds(this.myEditor.offsetToVisualPosition(range2.getEndOffset()), visualStart, visualEnd);
                    boolean bl = scrollToChange = !rangeVisible;
                    if (offsetToScroll < 0) {
                        if (text2.charAt(range2.getStartOffset()) != '\n') {
                            offsetToScroll = range2.getStartOffset();
                        } else if (range2.getEndOffset() > 0 && text2.charAt(range2.getEndOffset() - 1) != '\n') {
                            offsetToScroll = range2.getEndOffset() - 1;
                        }
                    }
                }
                TextAttributes attributesToUse = range2.getLength() > 0 ? backgroundAttributes : borderAttributes;
                markupModel.addRangeHighlighter(range2.getStartOffset(), range2.getEndOffset(), 6000, attributesToUse, HighlighterTargetArea.EXACT_RANGE);
            }
            if (scrollToChange) {
                if (offsetToScroll < 0 && !this.myPreviewRangesToHighlight.isEmpty()) {
                    offsetToScroll = this.myPreviewRangesToHighlight.get(0).getStartOffset();
                }
                if (offsetToScroll >= 0 && offsetToScroll < text2.length() - 1 && text2.charAt(offsetToScroll) != '\n') {
                    ++offsetToScroll;
                }
                if (offsetToScroll >= 0 && offsetToScroll < this.myEditor.getDocument().getTextLength()) {
                    this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(offsetToScroll), ScrollType.RELATIVE);
                }
            }
        } else {
            markupModel.removeAllHighlighters();
        }
        this.myShowsPreviewHighlighters = !this.myShowsPreviewHighlighters;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    protected CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = this.mySettings;
        if (codeStyleSettings == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(11);
        }
        return codeStyleSettings;
    }

    @NotNull
    public Set<String> processListOptions() {
        Set<String> set2 = Collections.emptySet();
        if (set2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(12);
        }
        return set2;
    }

    @NotNull
    public OptionsContainingConfigurable getOptionIndexer() {
        OptionsContainingConfigurable optionsContainingConfigurable = () -> this.processListOptions();
        if (optionsContainingConfigurable == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(13);
        }
        return optionsContainingConfigurable;
    }

    public final void applyPredefinedSettings(@NotNull PredefinedCodeStyle codeStyle) {
        if (codeStyle == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(14);
        }
        codeStyle.apply(this.mySettings, this.myDefaultLanguage);
        ((CodeStyleSchemesModel.ModelSettings)this.mySettings).doWithLockedSettings(() -> this.resetImpl(this.mySettings));
        if (this.myModel != null) {
            this.myModel.fireAfterCurrentSettingsChanged();
        }
    }

    @Nullable
    public Language getDefaultLanguage() {
        return this.myDefaultLanguage;
    }

    @NlsContexts.TabTitle
    @NotNull
    protected String getTabTitle() {
        String string = ApplicationBundle.message((String)"settings.code.style.tab.title.other", (Object[])new Object[0]);
        if (string == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(15);
        }
        return string;
    }

    protected CodeStyleSettings getCurrentSettings() {
        return this.myCurrentSettings;
    }

    @Nullable
    protected CodeStyleSettings getModelSettings() {
        CodeStyleSchemesModel model2 = this.myModel;
        return model2 != null ? model2.getCloneSettings(model2.getSelectedScheme()) : null;
    }

    public void setupCopyFromMenu(JPopupMenu copyMenu) {
        copyMenu.removeAll();
    }

    @Deprecated
    public boolean isCopyFromMenuAvailable() {
        return false;
    }

    @Override
    public final void highlight(@NotNull JComponent component2, @NotNull String searchString) {
        if (component2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(16);
        }
        if (searchString == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(17);
        }
        if (this.isNewSearchString(searchString) && this.isInsideThisPanel(component2)) {
            if (component2 instanceof TabLabel) {
                Container parent = component2.getParent();
                if (parent instanceof JBTabs) {
                    ((JBTabs)parent).select(((TabLabel)component2).getInfo(), false);
                }
            } else {
                JTabbedPane tabbedPane;
                int index;
                JPanel tabPanel = CodeStyleAbstractPanel.findTabbedPaneChild(component2);
                if (tabPanel != null && (index = (tabbedPane = (JTabbedPane)tabPanel.getParent()).indexOfComponent(tabPanel)) >= 0) {
                    tabbedPane.setSelectedIndex(index);
                }
            }
        }
    }

    private boolean isNewSearchString(@NotNull String searchString) {
        if (searchString == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(18);
        }
        if (searchString.equals(this.myLastSearchString)) {
            return false;
        }
        this.myLastSearchString = searchString;
        return true;
    }

    public void highlightOptions(@NotNull String searchString) {
        if (searchString == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(19);
        }
    }

    @Nullable
    private static JPanel findTabbedPaneChild(@NotNull JComponent component2) {
        if (component2 == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(20);
        }
        Container parent = component2.getParent();
        while (parent != null && !(parent instanceof NewCodeStyleSettingsPanel)) {
            Container nextParent = parent.getParent();
            if (nextParent instanceof JTabbedPane && parent instanceof JPanel) {
                return (JPanel)parent;
            }
            parent = nextParent;
        }
        return null;
    }

    private boolean isInsideThisPanel(@NotNull JComponent rootComponent) {
        if (rootComponent == null) {
            CodeStyleAbstractPanel.$$$reportNull$$$0(21);
        }
        JComponent thisPanel = this.getPanel();
        for (Container parent = rootComponent.getParent(); parent != null && !(parent instanceof NewCodeStyleSettingsPanel); parent = parent.getParent()) {
            if (parent != thisPanel) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapCombo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceContainerClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyleAbstractPanel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyle";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyleAbstractPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeExtension";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "processListOptions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionIndexer";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEditorText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentBeforeChanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillWrappingCombo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readFromFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeExtension";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyPredefinedSettings";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isNewSearchString";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "highlightOptions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findTabbedPaneChild";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInsideThisPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

