/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.utils;

import com.intellij.batch.constants.BatchClassesConstants;
import com.intellij.batch.model.BatchArtifactRefBean;
import com.intellij.batch.model.batch.BatchArtifactRef;
import com.intellij.batch.model.batch.BatchArtifacts;
import com.intellij.batch.model.job.Identified;
import com.intellij.batch.model.job.IdentifiedContainer;
import com.intellij.batch.model.job.Job;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.jam.JavaLibraryUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BatchCommonUtils {
    private BatchCommonUtils() {
    }

    public static boolean isBatchInstalled(@Nullable Module module) {
        return JavaLibraryUtils.hasLibraryClass((Module)module, (String)BatchClassesConstants.BATCHLET.javax()) || JavaLibraryUtils.hasLibraryClass((Module)module, (String)BatchClassesConstants.BATCHLET.jakarta());
    }

    public static Set<BatchArtifactRefBean> getBatchArtifactRefs(@NotNull Module module) {
        if (module == null) {
            BatchCommonUtils.$$$reportNull$$$0(0);
        }
        if (module.isDisposed()) {
            return Collections.emptySet();
        }
        HashSet<BatchArtifactRefBean> all = new HashSet<BatchArtifactRefBean>();
        for (CdiNamedBean namedBean : CdiJamModel.getModel((Module)module).getNamedBeans()) {
            all.add(new BatchArtifactRefBean.NAMED_BEAN(namedBean));
        }
        for (BatchArtifacts batchArtifacts : BatchCommonUtils.getBatchArtifacts(module)) {
            for (BatchArtifactRef ref : batchArtifacts.getRefs()) {
                all.add(new BatchArtifactRefBean.BATCH_ARTIFACT_REF(ref));
            }
        }
        return all;
    }

    @NotNull
    public static List<BatchArtifacts> getBatchArtifacts(@NotNull Module module) {
        if (module == null) {
            BatchCommonUtils.$$$reportNull$$$0(1);
        }
        List elements = DomService.getInstance().getFileElements(BatchArtifacts.class, module.getProject(), module.getModuleContentScope());
        List list = ContainerUtil.map((Collection)elements, element -> (BatchArtifacts)element.getRootElement());
        if (list == null) {
            BatchCommonUtils.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<Job> getBatchJobs(@NotNull Module module) {
        if (module == null) {
            BatchCommonUtils.$$$reportNull$$$0(3);
        }
        List elements = DomService.getInstance().getFileElements(Job.class, module.getProject(), module.getModuleContentScope());
        List list = ContainerUtil.map((Collection)elements, element -> (Job)element.getRootElement());
        if (list == null) {
            BatchCommonUtils.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static Job getBatchJob(@Nullable XmlFile file) {
        if (file == null) {
            return null;
        }
        DomFileElement fileElement = DomManager.getDomManager((Project)file.getProject()).getFileElement(file, Job.class);
        return fileElement != null && fileElement.isValid() ? (Job)fileElement.getRootElement() : null;
    }

    @NotNull
    public static List<Identified> getAllIdentified(@Nullable IdentifiedContainer identifiedContainer) {
        if (identifiedContainer == null) {
            List<Identified> list = Collections.emptyList();
            if (list == null) {
                BatchCommonUtils.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<Identified> identifiedList = new ArrayList<Identified>();
        BatchCommonUtils.addIdentified(identifiedContainer, identifiedList);
        ArrayList<Identified> arrayList = identifiedList;
        if (arrayList == null) {
            BatchCommonUtils.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void addIdentified(IdentifiedContainer identifiedContainer, List<Identified> identifiedList) {
        identifiedList.addAll(identifiedContainer.getDecisions());
        identifiedList.addAll(identifiedContainer.getSplits());
        identifiedList.addAll(identifiedContainer.getSteps());
        identifiedList.addAll(identifiedContainer.getFlows());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/batch/utils/BatchCommonUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/batch/utils/BatchCommonUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchArtifacts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchJobs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIdentified";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBatchArtifactRefs";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBatchArtifacts";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBatchJobs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

