/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.references;

import com.intellij.batch.model.job.Job;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class BatchJobXmlFileReference
extends PsiReferenceBase<PsiElement> {
    public BatchJobXmlFileReference(PsiLiteral element) {
        this(element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    public BatchJobXmlFileReference(PsiLiteral element, TextRange range) {
        super((PsiElement)element, range);
    }

    public PsiElement resolve() {
        String value = this.getValue();
        for (XmlFile xmlFile : this.getAllJobXmlFiles()) {
            String name = xmlFile.getName();
            if (!FileUtilRt.getNameWithoutExtension((String)name).equals(value)) continue;
            return xmlFile;
        }
        return null;
    }

    @NotNull
    private Set<XmlFile> getAllJobXmlFiles() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        if (module != null) {
            List fileElements = DomService.getInstance().getFileElements(Job.class, module.getProject(), module.getModuleContentScope());
            Set<XmlFile> set = fileElements.stream().map(element -> element.getFile()).collect(Collectors.toSet());
            if (set == null) {
                BatchJobXmlFileReference.$$$reportNull$$$0(0);
            }
            return set;
        }
        Set<XmlFile> set = Collections.emptySet();
        if (set == null) {
            BatchJobXmlFileReference.$$$reportNull$$$0(1);
        }
        return set;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            BatchJobXmlFileReference.$$$reportNull$$$0(2);
        }
        return this.getElement();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            BatchJobXmlFileReference.$$$reportNull$$$0(3);
        }
        return super.handleElementRename(FileUtilRt.getNameWithoutExtension((String)newElementName));
    }

    public Object @NotNull [] getVariants() {
        ArrayList<LookupElementBuilder> lookups = new ArrayList<LookupElementBuilder>();
        for (XmlFile file : this.getAllJobXmlFiles()) {
            String fileName = file.getName();
            lookups.add(LookupElementBuilder.create((String)FileUtilRt.getNameWithoutExtension((String)fileName)).withTypeText(fileName));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(lookups);
        if (objectArray == null) {
            BatchJobXmlFileReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/batch/references/BatchJobXmlFileReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJobXmlFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/batch/references/BatchJobXmlFileReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

