/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.providers;

import com.intellij.batch.utils.BatchCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlSchemaProvider;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchXmlSchemaProvider
extends XmlSchemaProvider {
    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            BatchXmlSchemaProvider.$$$reportNull$$$0(0);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return BatchCommonUtils.isBatchInstalled(module);
    }

    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            BatchXmlSchemaProvider.$$$reportNull$$$0(1);
        }
        if (baseFile == null) {
            BatchXmlSchemaProvider.$$$reportNull$$$0(2);
        }
        if (module == null) {
            return null;
        }
        String resourceName = BatchXmlSchemaProvider.getResourceName(url, baseFile);
        if (resourceName == null) {
            return null;
        }
        URL resource = BatchXmlSchemaProvider.class.getResource(resourceName);
        if (resource != null) {
            VirtualFile virtualFile = VfsUtil.findFileByURL((URL)resource);
            if (virtualFile == null) {
                return null;
            }
            PsiFile psiFile = baseFile.getManager().findFile(virtualFile);
            return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        }
        return null;
    }

    @Nullable
    private static String getResourceName(String url, PsiFile baseFile) {
        XmlTag rootTag;
        boolean isJakarta = url.startsWith("https://jakarta.ee/xml/ns/jakartaee");
        boolean isJavaee = url.startsWith("http://xmlns.jcp.org/xml/ns/javaee");
        if ((isJakarta || isJavaee) && baseFile instanceof XmlFile && (rootTag = ((XmlFile)baseFile).getRootTag()) != null) {
            String localName = rootTag.getLocalName();
            if (localName.equals("batch-artifacts")) {
                return isJakarta ? "/resources/schemas/batchXML_2_0.xsd" : "/resources/schemas/batchXML_1_0.xsd";
            }
            if (localName.equals("job")) {
                return isJakarta ? "/resources/schemas/jobXML_2_0.xsd" : "/resources/schemas/jobXML_1_0.xsd";
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/batch/providers/BatchXmlSchemaProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSchema";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

