/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.model.converters;

import com.intellij.batch.inspections.RequiredArtifactTypeInspection;
import com.intellij.batch.model.BatchArtifactRefBean;
import com.intellij.batch.utils.BatchCommonUtils;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchArtifactRefConverter
extends ResolvingConverter<BatchArtifactRefBean>
implements CustomReferenceConverter<BatchArtifactRefBean> {
    @Nullable
    public BatchArtifactRefBean fromString(@Nullable @NonNls String s, ConvertContext context) {
        Module module = context.getModule();
        if (s != null && module != null) {
            Set<BatchArtifactRefBean> refs = BatchCommonUtils.getBatchArtifactRefs(module);
            for (BatchArtifactRefBean ref : refs) {
                if (!s.equals(ref.getName())) continue;
                return ref;
            }
        }
        return null;
    }

    @Nullable
    public String toString(@Nullable BatchArtifactRefBean ref, ConvertContext context) {
        return ref == null ? "" : ref.getName();
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue<BatchArtifactRefBean> value, PsiElement element, ConvertContext context) {
        if (PsiReference.EMPTY_ARRAY == null) {
            BatchArtifactRefConverter.$$$reportNull$$$0(0);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    public Collection<? extends BatchArtifactRefBean> getVariants(ConvertContext context) {
        Module module = context.getModule();
        if (module != null) {
            return BatchArtifactRefConverter.getSmartVariants(module, context);
        }
        Set set = Collections.emptySet();
        if (set == null) {
            BatchArtifactRefConverter.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    private static Set<BatchArtifactRefBean> getSmartVariants(@NotNull Module module, ConvertContext context) {
        if (module == null) {
            BatchArtifactRefConverter.$$$reportNull$$$0(2);
        }
        List<PsiClass> requiredClasses = RequiredArtifactTypeInspection.getRequiredArtifactTypeClasses(context.getInvocationElement());
        Set<BatchArtifactRefBean> refs = BatchCommonUtils.getBatchArtifactRefs(module);
        return requiredClasses.size() == 0 ? refs : BatchArtifactRefConverter.filterArtifactsByType(refs, requiredClasses, module.getProject());
    }

    @NotNull
    private static Set<BatchArtifactRefBean> filterArtifactsByType(@NotNull Set<BatchArtifactRefBean> refs, @NotNull List<PsiClass> classes, @NotNull Project project) {
        if (refs == null) {
            BatchArtifactRefConverter.$$$reportNull$$$0(3);
        }
        if (classes == null) {
            BatchArtifactRefConverter.$$$reportNull$$$0(4);
        }
        if (project == null) {
            BatchArtifactRefConverter.$$$reportNull$$$0(5);
        }
        HashSet<BatchArtifactRefBean> filtered = new HashSet<BatchArtifactRefBean>();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        for (BatchArtifactRefBean ref : refs) {
            for (PsiClass requiredClass : classes) {
                PsiType type = ref.getType();
                if (type == null || !factory.createType(requiredClass).isAssignableFrom(type)) continue;
                filtered.add(ref);
            }
        }
        HashSet<BatchArtifactRefBean> hashSet = filtered;
        if (hashSet == null) {
            BatchArtifactRefConverter.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Nullable
    public LookupElement createLookupElement(BatchArtifactRefBean bean) {
        String name = bean.getName();
        PsiType type = bean.getType();
        if (name != null && type != null) {
            return LookupElementBuilder.create((String)name).withTypeText(type.getPresentableText());
        }
        return null;
    }

    @Nullable
    public PsiElement getPsiElement(@Nullable BatchArtifactRefBean resolvedValue) {
        return resolvedValue == null ? null : resolvedValue.getPsiElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/batch/model/converters/BatchArtifactRefConverter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/batch/model/converters/BatchArtifactRefConverter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterArtifactsByType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSmartVariants";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterArtifactsByType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

