/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.config;

import com.intellij.batch.config.BatchLibraryType;
import com.intellij.batch.resources.BatchBundle;
import com.intellij.framework.FrameworkGroup;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.LibraryBasedFrameworkSupportProvider;
import com.intellij.framework.library.LibraryBasedFrameworkType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.javaee.framework.JavaeeFrameworkGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchFrameworkType
extends LibraryBasedFrameworkType {
    protected BatchFrameworkType() {
        super("BatchApplications", BatchLibraryType.class);
    }

    @NotNull
    public String getPresentableName() {
        String string = BatchBundle.message("batch.jsr.name", new Object[0]);
        if (string == null) {
            BatchFrameworkType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public FrameworkGroup<?> getParentGroup() {
        return JavaeeFrameworkGroup.INSTANCE;
    }

    @NotNull
    public FrameworkSupportInModuleProvider createProvider() {
        return new LibraryBasedFrameworkSupportProvider((FrameworkTypeEx)this, this.getLibraryTypeClass()){

            @NotNull
            public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
                if (model == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new MyGenerateConfigurable();
            }

            public boolean isEnabledForModuleBuilder(@NotNull ModuleBuilder builder) {
                if (builder == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "LegacyJavaEE".equals(builder.getBuilderId());
            }

            public List<FrameworkSupportInModuleProvider.FrameworkDependency> getDependenciesFrameworkIds() {
                return Collections.singletonList(FrameworkSupportInModuleProvider.FrameworkDependency.optional((String)"web"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/batch/config/BatchFrameworkType$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createConfigurable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEnabledForModuleBuilder";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static String getMetaInfPath(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            BatchFrameworkType.$$$reportNull$$$0(1);
        }
        VirtualFile[] roots = rootModel.getSourceRoots();
        String defaultPath = null;
        for (VirtualFile file : roots) {
            String path = file.getUrl() + "/META-INF/";
            if (file.findChild("META-INF") != null) {
                return path;
            }
            defaultPath = path;
        }
        return defaultPath;
    }

    private static void createBatchXmlInWriteCommandAction(@NotNull Module module, @NotNull String path, @NotNull String fileTemplate, @NotNull Properties properties) {
        if (module == null) {
            BatchFrameworkType.$$$reportNull$$$0(2);
        }
        if (path == null) {
            BatchFrameworkType.$$$reportNull$$$0(3);
        }
        if (fileTemplate == null) {
            BatchFrameworkType.$$$reportNull$$$0(4);
        }
        if (properties == null) {
            BatchFrameworkType.$$$reportNull$$$0(5);
        }
        WriteCommandAction.writeCommandAction((Project)module.getProject()).run(() -> {
            try {
                File configFile = new File(FileUtil.toSystemDependentName((String)path));
                if (!configFile.exists()) {
                    FileTemplate template = FileTemplateManager.getInstance((Project)module.getProject()).getJ2eeTemplate(fileTemplate);
                    FileUtil.createIfDoesntExist((File)configFile);
                    VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configFile);
                    if (file != null) {
                        String text = template.getText(properties);
                        VfsUtil.saveText((VirtualFile)file, (String)text);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/batch/config/BatchFrameworkType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTemplate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/batch/config/BatchFrameworkType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMetaInfPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBatchXmlInWriteCommandAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyGenerateConfigurable
    extends FrameworkSupportInModuleConfigurable {
        private final JCheckBox myCreateBatchXml = new JCheckBox(BatchBundle.message("create.batch.xml", new Object[0]));
        private final JCheckBox myCreateSampleJobXml = new JCheckBox(BatchBundle.message("create.sample.job.xml", new Object[0]));

        private MyGenerateConfigurable() {
        }

        public JComponent createComponent() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0);
            panel.add((Component)this.myCreateBatchXml, gc);
            panel.add((Component)this.myCreateSampleJobXml, gc);
            return panel;
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
            if (module == null) {
                MyGenerateConfigurable.$$$reportNull$$$0(0);
            }
            if (rootModel == null) {
                MyGenerateConfigurable.$$$reportNull$$$0(1);
            }
            if (modifiableModelsProvider == null) {
                MyGenerateConfigurable.$$$reportNull$$$0(2);
            }
            Project project = module.getProject();
            if (this.myCreateBatchXml.isSelected()) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    String path = BatchFrameworkType.getMetaInfPath(rootModel);
                    if (path != null) {
                        String batchXmlPath = VfsUtilCore.urlToPath((String)(path + "batch.xml"));
                        BatchFrameworkType.createBatchXmlInWriteCommandAction(module, batchXmlPath, "batch.xml", FileTemplateManager.getInstance((Project)project).getDefaultProperties());
                    }
                });
            }
            if (this.myCreateSampleJobXml.isSelected()) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    String path = BatchFrameworkType.getMetaInfPath(rootModel);
                    if (path != null) {
                        String batchXmlPath = VfsUtilCore.urlToPath((String)(path + "batch-jobs/job.xml"));
                        Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
                        properties.setProperty("JOB_ID", "myJob");
                        BatchFrameworkType.createBatchXmlInWriteCommandAction(module, batchXmlPath, "job.xml", properties);
                    }
                });
            }
        }

        public CustomLibraryDescription createLibraryDescription() {
            return DownloadableLibraryService.getInstance().createDescriptionForType(BatchFrameworkType.this.getLibraryTypeClass());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modifiableModelsProvider";
                    break;
                }
            }
            objectArray[1] = "com/intellij/batch/config/BatchFrameworkType$MyGenerateConfigurable";
            objectArray[2] = "addSupport";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

