/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.optimizer;

import com.android.tools.apk.analyzer.optimizer.Analyzer;
import com.android.tools.apk.analyzer.optimizer.LintAnalyzer;
import com.android.tools.apk.analyzer.optimizer.Suggestion;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintRequest;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@Beta
public class SizeOptimizer {
    private File appArchive;
    private List<Analyzer> analyzers;

    public SizeOptimizer(File appArchive, LintClient client, LintRequest request) {
        this.appArchive = appArchive;
        this.analyzers = new ArrayList<Analyzer>(1);
        this.analyzers.add(new LintAnalyzer(client, request));
    }

    public List<Suggestion> analyze() {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>(this.analyzers.size());
        for (Analyzer analyzer : this.analyzers) {
            List<Suggestion> analyzerSuggestions = analyzer.analyze();
            if (analyzerSuggestions == null || analyzerSuggestions.isEmpty()) continue;
            suggestions.addAll(analyzerSuggestions);
        }
        return suggestions;
    }

    @VisibleForTesting
    void setAnalyzers(List<Analyzer> analyzers) {
        this.analyzers = analyzers;
    }
}

