/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveEntry;
import java.nio.file.Path;

public class ArchivePathEntry
extends ArchiveEntry {
    private long rawFileSize = -1L;
    private long downloadFileSize = -1L;

    public ArchivePathEntry(Archive archive, Path path, String pathPrefix) {
        super(archive, path, pathPrefix);
    }

    @Override
    public void setRawFileSize(long rawFileSize) {
        this.rawFileSize = rawFileSize;
    }

    @Override
    public long getRawFileSize() {
        return this.rawFileSize;
    }

    @Override
    public void setDownloadFileSize(long downloadFileSize) {
        this.downloadFileSize = downloadFileSize;
    }

    @Override
    public long getDownloadFileSize() {
        return this.downloadFileSize;
    }

    @Override
    public String getNodeDisplayString() {
        Path base = this.getPath().getFileName();
        String name = base == null ? "" : base.toString();
        return ArchivePathEntry.trimEnd(name, "/");
    }

    @Override
    public String getSummaryDisplayString() {
        return this.getPathPrefix() + this.getPath().toString();
    }

    private static String trimEnd(String s, String suffix) {
        boolean endsWith = s.endsWith(suffix);
        if (endsWith) {
            return s.substring(0, s.length() - suffix.length());
        }
        return s;
    }
}

