/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.settings;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.layout.LayoutOrientation;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.circular.CircularLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicLayouter;
import com.intellij.openapi.graph.layout.organic.SmartOrganicLayouter;
import com.intellij.openapi.graph.layout.orthogonal.DirectedOrthogonalLayouter;
import com.intellij.openapi.graph.layout.orthogonal.OrthogonalLayouter;
import com.intellij.openapi.graph.layout.tree.BalloonLayouter;
import com.intellij.openapi.graph.layout.tree.HVTreeLayouter;

public final class GraphSettings {
    private final HierarchicGroupLayouter myGroupLayouter = GraphManager.getGraphManager().createHierarchicGroupLayouter();
    private final CircularLayouter myCircularLayouter = GraphManager.getGraphManager().createCircularLayouter();
    private final DirectedOrthogonalLayouter myDirectedOrthogonalLayouter = GraphManager.getGraphManager().createDirectedOrthogonalLayouter();
    private final SmartOrganicLayouter myOrganicLayouter = GraphManager.getGraphManager().createSmartOrganicLayouter();
    private final OrthogonalLayouter myOrthogonalLayouter = GraphManager.getGraphManager().createOrthogonalLayouter();
    private final BalloonLayouter myBalloonLayouter = GraphManager.getGraphManager().createBalloonLayouter();
    private final HVTreeLayouter myHVTreeLayouter = GraphManager.getGraphManager().createHVTreeLayouter();
    private Layouter myCurrentLayouter;
    private boolean myFitContentAfterLayout = true;
    public static GraphSettings DEFAULT = new GraphSettings();

    public static GraphSettings create() {
        return new GraphSettings();
    }

    private GraphSettings() {
        this.myGroupLayouter.setOrientationLayouter(GraphManager.getGraphManager().createOrientationLayouter(LayoutOrientation.BOTTOM_TO_TOP));
        this.myGroupLayouter.setMinimalNodeDistance(20.0);
        this.myGroupLayouter.setMinimalLayerDistance(50.0);
        this.myGroupLayouter.setRoutingStyle(HierarchicLayouter.ROUTE_ORTHOGONAL);
        this.myOrthogonalLayouter.setGrid(40);
        this.myDirectedOrthogonalLayouter.setGrid(40);
        this.myOrganicLayouter.setNodeSizeAware(true);
        this.myOrganicLayouter.setMinimalNodeDistance(40.0);
        this.myOrganicLayouter.setNodeOverlapsAllowed(false);
        this.myHVTreeLayouter.setHorizontalSpace(40.0);
        this.myHVTreeLayouter.setVerticalSpace(40.0);
        this.myBalloonLayouter.setMinimalEdgeLength(40);
        this.myCurrentLayouter = this.myGroupLayouter;
    }

    public HierarchicGroupLayouter getGroupLayouter() {
        return this.myGroupLayouter;
    }

    public void setCurrentLayouter(Layouter currentLayouter) {
        this.myCurrentLayouter = currentLayouter;
    }

    public Layouter getCurrentLayouter() {
        return this.myCurrentLayouter;
    }

    public CircularLayouter getCircularLayouter() {
        return this.myCircularLayouter;
    }

    public DirectedOrthogonalLayouter getDirectedOrthogonalLayouter() {
        return this.myDirectedOrthogonalLayouter;
    }

    public SmartOrganicLayouter getOrganicLayouter() {
        return this.myOrganicLayouter;
    }

    public OrthogonalLayouter getOrthogonalLayouter() {
        return this.myOrthogonalLayouter;
    }

    public BalloonLayouter getBalloonLayouter() {
        return this.myBalloonLayouter;
    }

    public HVTreeLayouter getHVTreeLayouter() {
        return this.myHVTreeLayouter;
    }

    public boolean isFitContentAfterLayout() {
        return this.myFitContentAfterLayout;
    }

    public void setFitContentAfterLayout(boolean fitContentAfterLayout) {
        this.myFitContentAfterLayout = fitContentAfterLayout;
    }
}

