/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.laf.win10;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaPasswordFieldUI;
import com.intellij.laf.win10.WinIntelliJTextBorder;
import com.intellij.laf.win10.WinIntelliJTextFieldUI;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class WinIntelliJPasswordFieldUI
extends DarculaPasswordFieldUI {
    private MouseListener hoverListener;

    public static ComponentUI createUI(JComponent c) {
        return new WinIntelliJPasswordFieldUI();
    }

    public void installListeners() {
        super.installListeners();
        JTextComponent passwordField = this.getComponent();
        this.hoverListener = new DarculaUIUtil.MouseHoverPropertyTrigger((JComponent)passwordField, "JTextField.hover");
        passwordField.addMouseListener(this.hoverListener);
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        JTextComponent passwordField = this.getComponent();
        if (this.hoverListener != null) {
            passwordField.removeMouseListener(this.hoverListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Container parent = c.getParent();
            if (c.isOpaque() && parent != null) {
                g2.setColor(parent.getBackground());
                g2.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            if (c.getBorder() instanceof WinIntelliJTextBorder) {
                WinIntelliJTextFieldUI.paintTextFieldBackground(c, g2);
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected int getMinimumHeight(int originHeight) {
        JTextComponent component = this.getComponent();
        Insets insets = component.getInsets();
        return WinIntelliJTextBorder.MINIMUM_HEIGHT.get() + insets.top + insets.bottom;
    }
}

