/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.settings;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.reactivestreams.ReactiveStreamsBundle;
import com.intellij.reactivestreams.settings.ReactiveStreamsConfigurable;
import com.intellij.reactivestreams.settings.ReactiveStreamsNotificationManager;
import com.intellij.reactivestreams.settings.ReactiveStreamsSettings;
import com.intellij.util.xmlb.XmlSerializerUtil;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ReactorNotificationsSettings", storages={@Storage(value="other.xml")})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00182\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\n\u0010\f\u001a\u0004\u0018\u00010\u0000H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/reactivestreams/settings/ReactiveStreamsNotificationManagerImpl;", "Lcom/intellij/reactivestreams/settings/ReactiveStreamsNotificationManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "()V", "REACTOR_NOTIFICATION_LOUD_GROUP", "Lcom/intellij/notification/NotificationGroup;", "REACTOR_NOTIFICATION_SILENT_GROUP", "isDebugNotificationEnabled", "", "()Z", "setDebugNotificationEnabled", "(Z)V", "getState", "loadState", "", "state", "showDebugNotification", "project", "Lcom/intellij/openapi/project/Project;", "showDebugWithAgentImpossibleNotification", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "type", "Lcom/intellij/reactivestreams/settings/ReactiveStreamsNotificationManager$ImpossibleType;", "Companion", "intellij.reactivestreams"})
public final class ReactiveStreamsNotificationManagerImpl
implements ReactiveStreamsNotificationManager,
PersistentStateComponent<ReactiveStreamsNotificationManagerImpl> {
    private boolean isDebugNotificationEnabled = true;
    private final NotificationGroup REACTOR_NOTIFICATION_LOUD_GROUP = new NotificationGroup("Reactor Notifications loud", NotificationDisplayType.STICKY_BALLOON, false, null, null, 24, null);
    private final NotificationGroup REACTOR_NOTIFICATION_SILENT_GROUP = new NotificationGroup("Reactor Notification silent", NotificationDisplayType.NONE, true, null, null, 24, null);
    private static final String OPEN_SETTINGS_DESCRIPTION = "OpenSettings";
    private static final String DO_NOT_SHOW_AGAIN_DESCRIPTION = "DoNotShowAgain";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isDebugNotificationEnabled() {
        return this.isDebugNotificationEnabled;
    }

    @Override
    public void setDebugNotificationEnabled(boolean bl) {
        this.isDebugNotificationEnabled = bl;
    }

    @Nullable
    public ReactiveStreamsNotificationManagerImpl getState() {
        return this;
    }

    public void loadState(@NotNull ReactiveStreamsNotificationManagerImpl state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @Override
    public void showDebugNotification(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (ReactiveStreamsSettings.Companion.getInstance(project).isNotificationShown() || !ReactiveStreamsNotificationManager.Companion.getInstance().isDebugNotificationEnabled()) {
            return;
        }
        ReactiveStreamsSettings.Companion.getInstance(project).setNotificationShown(true);
        Companion this_$iv = Companion;
        boolean $i$f$notificationListener = false;
        this.REACTOR_NOTIFICATION_LOUD_GROUP.createNotification(ReactiveStreamsBundle.message("notifications.title", new Object[0]), ReactiveStreamsBundle.message("notifications.first.debug.message", new Object[0]), NotificationType.INFORMATION, new NotificationListener(project){
            final /* synthetic */ Project $project;
            {
                this.$project = project;
            }

            public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    String string = event.getDescription();
                    if (string != null) {
                        switch (string) {
                            case "OpenSettings": {
                                ShowSettingsUtil.getInstance().showSettingsDialog(this.$project, ReactiveStreamsConfigurable.class);
                                break;
                            }
                            case "DoNotShowAgain": {
                                boolean bl = false;
                                ReactiveStreamsNotificationManager.Companion.getInstance().setDebugNotificationEnabled(false);
                            }
                        }
                    }
                    notification.expire();
                }
            }
        }).notify(project);
    }

    @Override
    public void showDebugWithAgentImpossibleNotification(@NotNull Project project, @NotNull RunProfile profile, @NotNull ReactiveStreamsNotificationManager.ImpossibleType type) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!ReactiveStreamsSettings.Companion.getInstance(project).isDebugImpossibleNotificationsEnabled()) {
            return;
        }
        Companion this_$iv = Companion;
        boolean $i$f$notificationListener = false;
        this.REACTOR_NOTIFICATION_SILENT_GROUP.createNotification(ReactiveStreamsBundle.message("notifications.title", new Object[0]), ReactiveStreamsBundle.message("notifications.agent.impossible.message.pattern", profile.getName(), type.getMessage()), NotificationType.WARNING, new NotificationListener(project, project){
            final /* synthetic */ Project $project;
            final /* synthetic */ Project $project$inlined;
            {
                this.$project = project;
                this.$project$inlined = project2;
            }

            public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    String string = event.getDescription();
                    if (string != null) {
                        switch (string) {
                            case "OpenSettings": {
                                ShowSettingsUtil.getInstance().showSettingsDialog(this.$project, ReactiveStreamsConfigurable.class);
                                break;
                            }
                            case "DoNotShowAgain": {
                                boolean bl = false;
                                ReactiveStreamsSettings.Companion.getInstance(this.$project$inlined).setDebugImpossibleNotificationsEnabled(false);
                            }
                        }
                    }
                    notification.expire();
                }
            }
        }).notify(project);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0004\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0082\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/reactivestreams/settings/ReactiveStreamsNotificationManagerImpl$Companion;", "", "()V", "DO_NOT_SHOW_AGAIN_DESCRIPTION", "", "OPEN_SETTINGS_DESCRIPTION", "notificationListener", "Lcom/intellij/notification/NotificationListener;", "project", "Lcom/intellij/openapi/project/Project;", "doNotShowAction", "Lkotlin/Function0;", "", "intellij.reactivestreams"})
    public static final class Companion {
        private final NotificationListener notificationListener(Project project, Function0<Unit> doNotShowAction) {
            int $i$f$notificationListener = 0;
            return new NotificationListener(project, doNotShowAction){
                final /* synthetic */ Project $project;
                final /* synthetic */ Function0 $doNotShowAction;

                public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                        String string = event.getDescription();
                        if (string != null) {
                            switch (string) {
                                case "OpenSettings": {
                                    ShowSettingsUtil.getInstance().showSettingsDialog(this.$project, ReactiveStreamsConfigurable.class);
                                    break;
                                }
                                case "DoNotShowAgain": {
                                    this.$doNotShowAction.invoke();
                                    break;
                                }
                            }
                        }
                        notification.expire();
                    }
                }
                {
                    this.$project = project;
                    this.$doNotShowAction = function0;
                }
            };
        }

        private Companion() {
        }

        public static final /* synthetic */ NotificationListener access$notificationListener(Companion $this, Project project, Function0 doNotShowAction) {
            return $this.notificationListener(project, (Function0<Unit>)doNotShowAction);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

