/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.inspections.reactor;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBaseNonBlockingScopeInspection;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBlockingScopeCheckResult;
import com.intellij.reactivestreams.reactor.util.ReactorLibraryUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;

public class ReactorBlockingMethodChecker
implements BlockingMethodChecker {
    private static final String BLOCKING_NAME_PREFIX = "block";

    public boolean isApplicable(@NotNull PsiFile file) {
        if (file == null) {
            ReactorBlockingMethodChecker.$$$reportNull$$$0(0);
        }
        return JavaPsiFacade.getInstance((Project)file.getProject()).findClass("reactor.core.publisher.Mono", file.getResolveScope()) != null;
    }

    public boolean isMethodBlocking(@NotNull PsiMethod method) {
        if (method == null) {
            ReactorBlockingMethodChecker.$$$reportNull$$$0(1);
        }
        return ReactiveStreamsBaseNonBlockingScopeInspection.isMethodFromPublisher(method) && ReactorBlockingMethodChecker.isReactorBlockingMethod(method);
    }

    private static boolean isReactorBlockingMethod(@NotNull PsiMethod method) {
        String methodName;
        if (method == null) {
            ReactorBlockingMethodChecker.$$$reportNull$$$0(2);
        }
        if ((methodName = method.getName()).startsWith(BLOCKING_NAME_PREFIX)) {
            return true;
        }
        PsiType returnType = method.getReturnType();
        if (ReactorLibraryUtil.isReactorPublisher(returnType)) {
            return false;
        }
        if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.lang.Iterable")) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.Stream");
    }

    public LocalQuickFix @NotNull [] getQuickFixesFor(@NotNull PsiElement element) {
        UCallExpression callExpression;
        if (element == null) {
            ReactorBlockingMethodChecker.$$$reportNull$$$0(3);
        }
        if ((callExpression = AnalysisUastUtil.getUCallExpression((PsiElement)element)) == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                ReactorBlockingMethodChecker.$$$reportNull$$$0(4);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ReactiveStreamsBlockingScopeCheckResult result = ReactiveStreamsBaseNonBlockingScopeInspection.isCalledInNonBlockingContext(callExpression);
        if (result instanceof ReactiveStreamsBlockingScopeCheckResult.Unknown) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                ReactorBlockingMethodChecker.$$$reportNull$$$0(5);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] localQuickFixArray = ((ReactiveStreamsBlockingScopeCheckResult.NonBlocking)result).getQuickFixes();
        if (localQuickFixArray == null) {
            ReactorBlockingMethodChecker.$$$reportNull$$$0(6);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/reactivestreams/reactor/inspections/reactor/ReactorBlockingMethodChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/reactivestreams/reactor/inspections/reactor/ReactorBlockingMethodChecker";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMethodBlocking";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isReactorBlockingMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesFor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

