/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.inspections;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.reactivestreams.reactor.inspections.ReactorUastInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;

public abstract class ReactorUnusedCallResultInspectionBase
extends ReactorUastInspectionBase {
    @InspectionMessage
    protected abstract String getProblemDescriptionsByReturnType(String var1);

    protected LocalQuickFix @NotNull [] getLocalQuickFixesByReturnType(String returnType) {
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            ReactorUnusedCallResultInspectionBase.$$$reportNull$$$0(0);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            ReactorUnusedCallResultInspectionBase.$$$reportNull$$$0(1);
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                UCallExpression callExpression;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((callExpression = AnalysisUastUtil.getUCallExpression((PsiElement)element)) == null) {
                    return;
                }
                PsiElement methodIdentifierPsi = AnalysisUastUtil.getMethodIdentifierSourcePsi((UCallExpression)callExpression);
                if (methodIdentifierPsi == null) {
                    return;
                }
                String problemDescription = ReactorUnusedCallResultInspectionBase.this.getTargetProblemDescription(callExpression);
                if (problemDescription != null) {
                    ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor(methodIdentifierPsi, problemDescription, isOnTheFly, ReactorUnusedCallResultInspectionBase.this.getLocalQuickFixes(callExpression), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    holder.registerProblem(problemDescriptor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/reactivestreams/reactor/inspections/ReactorUnusedCallResultInspectionBase$1", "visitElement"));
            }
        };
    }

    @Nullable
    @InspectionMessage
    private String getTargetProblemDescription(UCallExpression expression) {
        String returnTypeFqnName = AnalysisUastUtil.getExpressionReturnTypePsiClassFqn((UCallExpression)expression);
        if (returnTypeFqnName != null) {
            return AnalysisUastUtil.isExpressionResultValueUsed((UCallExpression)expression) ? null : this.getProblemDescriptionsByReturnType(returnTypeFqnName);
        }
        return null;
    }

    private LocalQuickFix @NotNull [] getLocalQuickFixes(UCallExpression expression) {
        String returnTypeFqnName = AnalysisUastUtil.getExpressionReturnTypePsiClassFqn((UCallExpression)expression);
        LocalQuickFix[] localQuickFixArray = this.getLocalQuickFixesByReturnType(returnTypeFqnName);
        if (localQuickFixArray == null) {
            ReactorUnusedCallResultInspectionBase.$$$reportNull$$$0(2);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/reactivestreams/reactor/inspections/ReactorUnusedCallResultInspectionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalQuickFixesByReturnType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/reactivestreams/reactor/inspections/ReactorUnusedCallResultInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doBuildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

