/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBaseNonBlockingScopeInspection;
import com.intellij.reactivestreams.reactor.ReactorCoreBundle;
import com.intellij.reactivestreams.reactor.util.ReactorLibraryUtil;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;

public class BlockingOperatorInNonBlockingScopeInspection
extends ReactiveStreamsBaseNonBlockingScopeInspection {
    private static final String BLOCKING_NAME_PREFIX = "block";

    @Override
    protected boolean isAvailable(@NotNull Project project) {
        if (project == null) {
            BlockingOperatorInNonBlockingScopeInspection.$$$reportNull$$$0(0);
        }
        return ReactorLibraryUtil.hasReactorLibrary(project);
    }

    @Override
    protected void report(@NotNull ProblemsHolder holder, @NotNull PsiElement methodIdentifierPsi, LocalQuickFix @NotNull [] quickFixes) {
        if (holder == null) {
            BlockingOperatorInNonBlockingScopeInspection.$$$reportNull$$$0(1);
        }
        if (methodIdentifierPsi == null) {
            BlockingOperatorInNonBlockingScopeInspection.$$$reportNull$$$0(2);
        }
        if (quickFixes == null) {
            BlockingOperatorInNonBlockingScopeInspection.$$$reportNull$$$0(3);
        }
        holder.registerProblem(methodIdentifierPsi, ReactorCoreBundle.message("inspections.blocking.operator.in.non.blocking.scope.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickFixes);
    }

    @Override
    protected boolean shouldReportCall(UExpression receiver, UCallExpression expression) {
        String methodName = expression.getMethodName();
        if (methodName != null && methodName.startsWith(BLOCKING_NAME_PREFIX)) {
            return true;
        }
        if (ReactiveStreamsUtils.isPublisher(expression.getReturnType())) {
            return false;
        }
        PsiType returnType = expression.getReturnType();
        if (Objects.equals(BlockingOperatorInNonBlockingScopeInspection.getContainingType(receiver.getExpressionType()), BlockingOperatorInNonBlockingScopeInspection.getContainingType(returnType))) {
            if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.lang.Iterable")) {
                return true;
            }
            if (InheritanceUtil.isInheritor((PsiType)returnType, (String)"java.util.stream.Stream")) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiType getContainingType(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiType[] parameters = ((PsiClassType)type).getParameters();
        if (parameters.length != 1) {
            return null;
        }
        return GenericsUtil.eliminateWildcards((PsiType)parameters[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodIdentifierPsi";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/reactivestreams/reactor/inspections/BlockingOperatorInNonBlockingScopeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

