/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.debugger;

import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OnAssemblyInfo {
    @Nullable
    private final String reactorMethod;
    private final String positionClass;
    private final String positionMethod;
    private final int positionLine;
    private static final Pattern ASSEMBLY_INFO_SPLITTER = Pattern.compile("\\s*\u21e2(\\s*at)?\\s*");
    private static final Pattern CHECKPOINT_WITHOUT_STACKTRACE = Pattern.compile("\\s*checkpoint\\(\".*\"\\)\\s*");
    private static final String POSSIBLE_INFO_PREFIX = "at ";
    private static final String NO_ASSEMBLY_INFORMATION = "[no operator assembly information]";

    @Nullable
    static OnAssemblyInfo from(String onAssemblyInfo) {
        if (CHECKPOINT_WITHOUT_STACKTRACE.matcher(onAssemblyInfo).matches()) {
            return null;
        }
        if (NO_ASSEMBLY_INFORMATION.equals(onAssemblyInfo)) {
            return null;
        }
        return new OnAssemblyInfo(onAssemblyInfo);
    }

    OnAssemblyInfo(@NotNull String onAssemblyInfo) {
        int userInfoIndex;
        if (onAssemblyInfo == null) {
            OnAssemblyInfo.$$$reportNull$$$0(0);
        }
        String[] dividedByArrow = ASSEMBLY_INFO_SPLITTER.split(onAssemblyInfo);
        switch (dividedByArrow.length) {
            case 2: {
                userInfoIndex = 1;
                this.reactorMethod = dividedByArrow[0].trim();
                break;
            }
            case 1: {
                userInfoIndex = 0;
                this.reactorMethod = null;
                dividedByArrow[0] = StringUtil.trimStart((String)dividedByArrow[0], (String)POSSIBLE_INFO_PREFIX);
                break;
            }
            default: {
                throw new StrangeAssemblyInfoException(onAssemblyInfo);
            }
        }
        try {
            String beforeParenthesis = dividedByArrow[userInfoIndex].substring(0, dividedByArrow[userInfoIndex].indexOf("("));
            this.positionMethod = beforeParenthesis.substring(beforeParenthesis.lastIndexOf(".") + 1);
            this.positionClass = dividedByArrow[userInfoIndex].substring(0, beforeParenthesis.lastIndexOf(".")).trim();
            this.positionLine = Integer.parseInt(dividedByArrow[userInfoIndex].substring(dividedByArrow[userInfoIndex].indexOf(":") + 1, dividedByArrow[userInfoIndex].indexOf(")")));
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
            throw new StrangeAssemblyInfoException(onAssemblyInfo);
        }
    }

    String positionSimpleClassName() {
        int indexOfClass = this.positionClass.lastIndexOf(".");
        return indexOfClass == -1 ? this.positionClass : this.positionClass.substring(indexOfClass + 1);
    }

    @Nullable
    String positionPackage() {
        int indexOfClass = this.positionClass.lastIndexOf(".");
        return indexOfClass == -1 ? null : this.positionClass.substring(0, indexOfClass);
    }

    @Nullable
    String getReactorMethod() {
        return this.reactorMethod;
    }

    String getPositionMethod() {
        return this.positionMethod;
    }

    int getPositionLine() {
        return this.positionLine;
    }

    String getPositionClass() {
        return this.positionClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onAssemblyInfo", "com/intellij/reactivestreams/reactor/debugger/OnAssemblyInfo", "<init>"));
    }

    private static final class StrangeAssemblyInfoException
    extends RuntimeException {
        private StrangeAssemblyInfoException(String assemblyInfo) {
            super("Strange reactor assembly info: " + assemblyInfo);
        }
    }
}

