/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.reactivestreams.ReactiveStreamsBundle;
import com.intellij.reactivestreams.implementations.ReactiveStreamsInspectionsManager;
import com.intellij.reactivestreams.inspections.ReactiveStreamsUastInspectionBase;
import com.intellij.reactivestreams.intentions.CollapseFiltersWithPreviousIntention;
import com.intellij.reactivestreams.intentions.CollapseMapsWithPreviousIntention;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import com.intellij.ultimate.PluginVerifier;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsTooLongSameOperatorsChainInspection;", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsUastInspectionBase;", "()V", "maxChainLength", "", "createOptionsPanel", "Ljavax/swing/JComponent;", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "onTheFly", "", "getSameMethodsChain", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/uast/UCallExpression;", "methodCall", "Companion", "intellij.reactivestreams.core"})
public final class ReactiveStreamsTooLongSameOperatorsChainInspection
extends ReactiveStreamsUastInspectionBase {
    @JvmField
    public int maxChainLength;
    private static final int DEFAULT_MAX_CHAIN_LENGTH = 2;
    private static final Set<String> methodsToCheck;
    public static final Companion Companion;

    @Nullable
    public JComponent createOptionsPanel() {
        return (JComponent)new SingleIntegerFieldOptionsPanel(ReactiveStreamsBundle.message("inspections.too.long.map.chain.settings.field", new Object[0]), (InspectionProfileEntry)this, "maxChainLength", 2);
    }

    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(this, holder, onTheFly){
            final /* synthetic */ ReactiveStreamsTooLongSameOperatorsChainInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $onTheFly;

            /*
             * WARNING - void declaration
             */
            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement $this$toUElementOfType$iv = element;
                boolean $i$f$toUElementOfType = false;
                UCallExpression uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UCallExpression.class);
                if (uCallExpression == null) {
                    return;
                }
                UCallExpression methodCall = uCallExpression;
                if (!CollectionsKt.contains((Iterable)ReactiveStreamsTooLongSameOperatorsChainInspection.access$getMethodsToCheck$cp(), (Object)methodCall.getMethodName())) {
                    return;
                }
                String string = methodCall.getMethodName();
                Intrinsics.checkNotNull((Object)string);
                String currentMethodName = string;
                UCallExpression uCallExpression2 = ReactiveStreamsUtils.getPrevCallInChain(methodCall);
                if (Intrinsics.areEqual((Object)(uCallExpression2 != null ? uCallExpression2.getMethodName() : null), (Object)currentMethodName)) {
                    return;
                }
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"holder.project");
                if (!ReactiveStreamsInspectionsManager.Companion.getInstance(project).shouldBeCollapsed(methodCall)) {
                    return;
                }
                Sequence $this$forEachIndexed$iv = ReactiveStreamsTooLongSameOperatorsChainInspection.access$getSameMethodsChain(this.this$0, methodCall);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (E item$iv : $this$forEachIndexed$iv) {
                    void h;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    UCallExpression uCallExpression3 = (UCallExpression)item$iv;
                    int methodCallNumber = n;
                    boolean bl2 = false;
                    this.registerProblem((UCallExpression)h, currentMethodName, methodCallNumber + 1);
                }
            }

            private final void registerProblem(UCallExpression $this$registerProblem, String methodName, int methodCallNumber) {
                LocalQuickFix[] localQuickFixArray;
                if (!this.$onTheFly && methodCallNumber <= this.this$0.maxChainLength) {
                    return;
                }
                if (methodCallNumber == 0) {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"LocalQuickFix.EMPTY_ARRAY");
                } else if (Intrinsics.areEqual((Object)methodName, (Object)"map")) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new CollapseMapsWithPreviousIntention();
                } else if (Intrinsics.areEqual((Object)methodName, (Object)"filter")) {
                    LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray3;
                    localQuickFixArray3[0] = new CollapseFiltersWithPreviousIntention();
                } else {
                    return;
                }
                LocalQuickFix[] quickFixes = localQuickFixArray;
                UIdentifier uIdentifier = $this$registerProblem.getMethodIdentifier();
                if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
                    return;
                }
                this.$holder.registerProblem(this.$holder.getManager().createProblemDescriptor((PsiElement)uIdentifier, ReactiveStreamsBundle.message("inspections.too.long.map.chain.description", methodName), this.$onTheFly, quickFixes, methodCallNumber > this.this$0.maxChainLength ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION));
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
                this.$onTheFly = $captured_local_variable$2;
            }
        };
    }

    private final Sequence<UCallExpression> getSameMethodsChain(UCallExpression methodCall) {
        return SequencesKt.generateSequence((Object)methodCall, (Function1)((Function1)new Function1<UCallExpression, UCallExpression>(methodCall){
            final /* synthetic */ UCallExpression $methodCall;

            @Nullable
            public final UCallExpression invoke(@NotNull UCallExpression call) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                UCallExpression uCallExpression = ReactiveStreamsUtils.getNextCallInChain(call);
                if (uCallExpression != null) {
                    UCallExpression uCallExpression2 = uCallExpression;
                    boolean bl = false;
                    boolean bl2 = false;
                    UCallExpression it = uCallExpression2;
                    boolean bl3 = false;
                    object = Intrinsics.areEqual((Object)it.getMethodName(), (Object)this.$methodCall.getMethodName()) ? uCallExpression2 : null;
                } else {
                    object = null;
                }
                return object;
            }
            {
                this.$methodCall = uCallExpression;
                super(1);
            }
        }));
    }

    public ReactiveStreamsTooLongSameOperatorsChainInspection() {
        super(new Class[0]);
        PluginVerifier.verifyUltimatePlugin();
        this.maxChainLength = 2;
    }

    static {
        Companion = new Companion(null);
        methodsToCheck = SetsKt.setOf((Object[])new String[]{"filter", "map"});
    }

    public static final /* synthetic */ Set access$getMethodsToCheck$cp() {
        return methodsToCheck;
    }

    public static final /* synthetic */ Sequence access$getSameMethodsChain(ReactiveStreamsTooLongSameOperatorsChainInspection $this, UCallExpression methodCall) {
        return $this.getSameMethodsChain(methodCall);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsTooLongSameOperatorsChainInspection$Companion;", "", "()V", "DEFAULT_MAX_CHAIN_LENGTH", "", "methodsToCheck", "", "", "intellij.reactivestreams.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

