/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.reactivestreams.ReactiveStreamsBundle;
import com.intellij.reactivestreams.implementations.ReactiveStreamsInspectionsManager;
import com.intellij.reactivestreams.implementations.info.ThrowReplacementInfo;
import com.intellij.reactivestreams.inspections.InternalReplacementStrategy;
import com.intellij.reactivestreams.inspections.ReactiveStreamsThrowInOperatorInspection;
import com.intellij.reactivestreams.inspections.ReactiveStreamsThrowInOperatorInspectionKt;
import com.intellij.reactivestreams.inspections.ReactiveStreamsUastInspectionBase;
import com.intellij.reactivestreams.uast.ex.UFunctionalObject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsThrowInOperatorInspection;", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsUastInspectionBase;", "()V", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "onTheFly", "", "intellij.reactivestreams.core"})
public final class ReactiveStreamsThrowInOperatorInspection
extends ReactiveStreamsUastInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(holder, onTheFly){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $onTheFly;

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                UFunctionalObject<T> uFunctionalObject = UFunctionalObject.Companion.from(element, (Function1)new Function1<UElement, ThrowReplacementInfo>(element){
                    final /* synthetic */ PsiElement $element;

                    @Nullable
                    public final ThrowReplacementInfo invoke(@NotNull UElement funcObj) {
                        Intrinsics.checkNotNullParameter((Object)funcObj, (String)"funcObj");
                        UElement uElement = funcObj.getUastParent();
                        if (!(uElement instanceof UCallExpression)) {
                            uElement = null;
                        }
                        UCallExpression uCallExpression = (UCallExpression)uElement;
                        if (uCallExpression == null) {
                            return null;
                        }
                        UCallExpression methodCall = uCallExpression;
                        Project project = this.$element.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
                        return ReactiveStreamsInspectionsManager.Companion.getInstance(project).createThrowReplacementInfo(methodCall, funcObj);
                    }
                    {
                        this.$element = psiElement;
                        super(1);
                    }
                });
                if (uFunctionalObject == null) {
                    return;
                }
                UFunctionalObject<T> functionalObject2 = uFunctionalObject;
                UCallExpression methodCall = ((ThrowReplacementInfo)functionalObject2.getContext()).getCallExpression();
                InternalReplacementStrategy logicStrategy = ReactiveStreamsThrowInOperatorInspectionKt.access$createReplacementStrategy(functionalObject2);
                int throwsCount = ReactiveStreamsThrowInOperatorInspectionKt.access$calculateThrowExpressionsCount(functionalObject2);
                functionalObject2.accept((UastVisitor)new AbstractUastVisitor(this, functionalObject2, methodCall, logicStrategy, throwsCount){
                    final /* synthetic */ doBuildVisitor.1 this$0;
                    final /* synthetic */ UFunctionalObject $functionalObject;
                    final /* synthetic */ UCallExpression $methodCall;
                    final /* synthetic */ InternalReplacementStrategy $logicStrategy;
                    final /* synthetic */ int $throwsCount;

                    public boolean visitThrowExpression(@NotNull UThrowExpression node) {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        if (!this.$functionalObject.checkExpressionIsInsideFunction((UExpression)node)) {
                            return true;
                        }
                        ProblemsHolder problemsHolder = this.this$0.$holder;
                        InspectionManager inspectionManager = this.this$0.$holder.getManager();
                        PsiElement psiElement = node.getSourcePsi();
                        if (psiElement == null) {
                            return true;
                        }
                        Object[] objectArray = new Object[3];
                        objectArray[0] = ((ThrowReplacementInfo)this.$functionalObject.getContext()).getFrameworkName();
                        String string = this.$methodCall.getMethodName();
                        Intrinsics.checkNotNull((Object)string);
                        objectArray[1] = string;
                        objectArray[2] = ((ThrowReplacementInfo)this.$functionalObject.getContext()).getMethodType();
                        problemsHolder.registerProblem(inspectionManager.createProblemDescriptor(psiElement, ReactiveStreamsBundle.message("inspections.throw.in.operator.description", objectArray), this.this$0.$onTheFly, ReactiveStreamsThrowInOperatorInspectionKt.access$getQuickFixes(this.$logicStrategy, this.$throwsCount), ProblemHighlightType.WEAK_WARNING));
                        return true;
                    }
                    {
                        this.this$0 = this$0;
                        this.$functionalObject = $captured_local_variable$1;
                        this.$methodCall = $captured_local_variable$2;
                        this.$logicStrategy = $captured_local_variable$3;
                        this.$throwsCount = $captured_local_variable$4;
                    }
                });
            }
            {
                this.$holder = $captured_local_variable$0;
                this.$onTheFly = $captured_local_variable$1;
            }
        };
    }

    public ReactiveStreamsThrowInOperatorInspection() {
        super(new Class[0]);
    }
}

