/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reactivestreams.ReactiveStreamsBundle;
import com.intellij.reactivestreams.implementations.ReactiveStreamsInspectionsManager;
import com.intellij.reactivestreams.implementations.ReactiveStreamsNonBlockingAnalysisManager;
import com.intellij.reactivestreams.implementations.info.SchedulingMethodCallInfo;
import com.intellij.reactivestreams.implementations.info.SchedulingType;
import com.intellij.reactivestreams.inspections.NonBlockingAnalysisCache;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBlockingScopeCheckResult;
import com.intellij.reactivestreams.inspections.ReactiveStreamsNonBlockingSchedulerChecker;
import com.intellij.reactivestreams.inspections.ReactiveStreamsNonBlockingSchedulerCheckerKt;
import com.intellij.reactivestreams.inspections.Scope;
import com.intellij.reactivestreams.settings.ReactiveStreamsSettings;
import com.intellij.reactivestreams.uast.ex.FunctionalObjectsUtil;
import com.intellij.reactivestreams.uast.ex.UCallExpressionContext;
import com.intellij.reactivestreams.uast.ex.UFunctionalObject;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.analysis.Dependency;
import org.jetbrains.uast.analysis.Dependent;
import org.jetbrains.uast.analysis.UastLocalUsageDependencyGraph;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010\u0016\u001a\u00020\u0017*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J0\u0010\u0019\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00072\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "maxRecursionDepth", "", "checkDepth", "", "depth", "isCalledInNonBlockingScope", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsBlockingScopeCheckResult;", "callExpression", "Lorg/jetbrains/uast/UCallExpression;", "calculateScope", "Lcom/intellij/reactivestreams/inspections/Scope;", "Lcom/intellij/reactivestreams/inspections/NonBlockingAnalysisCache;", "dependencyGraph", "Lorg/jetbrains/uast/analysis/UastLocalUsageDependencyGraph;", "element", "Lorg/jetbrains/uast/UElement;", "getScopeByDependants", "Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$ScopeWithDepth;", "lastScope", "getScopeByDependencies", "subscribeOnScope", "FindCauseBecauseSchedulingFix", "ScopeWithDepth", "TooDeepRecursionException", "intellij.reactivestreams"})
public final class ReactiveStreamsNonBlockingSchedulerChecker {
    private static final Logger LOG;
    private static final int maxRecursionDepth;
    public static final ReactiveStreamsNonBlockingSchedulerChecker INSTANCE;

    @NotNull
    public final ReactiveStreamsBlockingScopeCheckResult isCalledInNonBlockingScope(@NotNull UCallExpression callExpression) {
        ReactiveStreamsBlockingScopeCheckResult reactiveStreamsBlockingScopeCheckResult;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                Object object = callExpression.getSourcePsi();
                if (object == null || (object = object.getProject()) == null) break block10;
                PsiElement psiElement = object;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement it = psiElement;
                boolean bl3 = false;
                PsiElement psiElement2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it");
                object = ReactiveStreamsSettings.Companion.getInstance((Project)psiElement2);
                if (object != null && object.isAdvancedNonBlockingAnalysisEnabled()) break block11;
            }
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        PsiElement psiElement = callExpression.getSourcePsi();
        Intrinsics.checkNotNull((Object)psiElement);
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"callExpression.sourcePsi!!.project");
        Project project2 = project;
        UFunctionalObject uFunctionalObject = UFunctionalObject.Companion.fromSuitableParent((UElement)callExpression, (Function1)new Function1<UElement, UCallExpressionContext>(project2){
            final /* synthetic */ Project $project;

            @Nullable
            public final UCallExpressionContext invoke(@NotNull UElement uElement) {
                Intrinsics.checkNotNullParameter((Object)uElement, (String)"uElement");
                UElement uElement2 = uElement.getUastParent();
                if (!(uElement2 instanceof UCallExpression)) {
                    uElement2 = null;
                }
                UCallExpression uCallExpression = (UCallExpression)uElement2;
                if (uCallExpression == null) {
                    return null;
                }
                UCallExpression operatorCall2 = uCallExpression;
                if (!ReactiveStreamsInspectionsManager.Companion.getInstance(this.$project).isOperatorMethodName(operatorCall2.getMethodName())) {
                    return null;
                }
                if (!ReactiveStreamsUtils.isMethodDefinedInKnownPublisher(operatorCall2.resolve()) || !ReactiveStreamsUtils.isPublisher(operatorCall2.getReturnType())) {
                    return null;
                }
                return FunctionalObjectsUtil.asContext(operatorCall2);
            }
            {
                this.$project = project;
                super(1);
            }
        });
        if (uFunctionalObject == null) {
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        UFunctionalObject functionalObject2 = uFunctionalObject;
        if (!functionalObject2.checkExpressionIsInsideFunction((UExpression)callExpression)) {
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)functionalObject2);
        if (uMethod == null) {
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        UMethod method = uMethod;
        UastLocalUsageDependencyGraph uastLocalUsageDependencyGraph = UastLocalUsageDependencyGraph.Companion.getGraphByUElement((UElement)method);
        if (uastLocalUsageDependencyGraph == null) {
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        UastLocalUsageDependencyGraph dependencyGraph = uastLocalUsageDependencyGraph;
        NonBlockingAnalysisCache nonBlockingAnalysisCache = NonBlockingAnalysisCache.Companion.getCache(method);
        if (nonBlockingAnalysisCache == null) {
            return ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        NonBlockingAnalysisCache analysisCache = nonBlockingAnalysisCache;
        try {
            reactiveStreamsBlockingScopeCheckResult = this.calculateScope(analysisCache, dependencyGraph, (UElement)functionalObject2.getContext().getCallExpression()) instanceof Scope.NonBlocking ? (ReactiveStreamsBlockingScopeCheckResult)new ReactiveStreamsBlockingScopeCheckResult.NonBlocking(new LocalQuickFix[]{FindCauseBecauseSchedulingFix.INSTANCE}) : (ReactiveStreamsBlockingScopeCheckResult)ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        catch (TooDeepRecursionException e) {
            reactiveStreamsBlockingScopeCheckResult = ReactiveStreamsBlockingScopeCheckResult.Unknown.INSTANCE;
        }
        return reactiveStreamsBlockingScopeCheckResult;
    }

    private final void checkDepth(int depth) {
        if (depth > maxRecursionDepth) {
            LOG.info("too deep recursion: " + depth + ", max is " + maxRecursionDepth);
            throw (Throwable)TooDeepRecursionException.INSTANCE;
        }
    }

    private final Scope calculateScope(NonBlockingAnalysisCache $this$calculateScope, UastLocalUsageDependencyGraph dependencyGraph, UElement element) {
        Scope scopeBefore = ReactiveStreamsNonBlockingSchedulerChecker.getScopeByDependencies$default(this, $this$calculateScope, dependencyGraph, element, 0, null, 8, null);
        if (scopeBefore instanceof Scope.NonBlocking && ((Scope.NonBlocking)scopeBefore).getType() == SchedulingType.NEXT_OPERATORS || scopeBefore instanceof Scope.DeclaredPossiblyBlocking) {
            return scopeBefore;
        }
        ScopeWithDepth scopeWithDepth = this.getScopeByDependants($this$calculateScope, dependencyGraph, element, 0, new ScopeWithDepth(Scope.Unknown.INSTANCE, -1));
        Scope scopeAfter = scopeWithDepth.component1();
        if (Intrinsics.areEqual((Object)scopeAfter, (Object)Scope.DeclaredPossiblyBlocking.INSTANCE) || scopeAfter instanceof Scope.NonBlocking) {
            return scopeAfter;
        }
        return scopeBefore;
    }

    /*
     * Unable to fully structure code
     */
    private final ScopeWithDepth getScopeByDependants(NonBlockingAnalysisCache $this$getScopeByDependants, UastLocalUsageDependencyGraph dependencyGraph, UElement element, int depth, ScopeWithDepth lastScope) {
        block27: {
            block30: {
                block29: {
                    ProgressManager.checkCanceled();
                    this.checkDepth(depth);
                    v0 = element.getSourcePsi();
                    if (v0 != null && (v0 = v0.getProject()) != null) {
                        var7_6 = v0;
                        var8_7 = false;
                        var9_9 = false;
                        it = var7_6;
                        $i$a$-let-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$nonBlockingAnalysisManager$1 = false;
                        v1 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                        v2 = ReactiveStreamsNonBlockingAnalysisManager.Companion.getInstance((Project)v1);
                    } else {
                        v2 = null;
                    }
                    nonBlockingAnalysisManager = v2;
                    cachedResult = $this$getScopeByDependants.getDownCache(element);
                    if (cachedResult != null) {
                        return new ScopeWithDepth(cachedResult, depth);
                    }
                    v3 = (Set)dependencyGraph.getDependents().get(element);
                    if (v3 == null) break block29;
                    $this$filter$iv = v3;
                    $i$f$filter = false;
                    $i$a$-let-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$nonBlockingAnalysisManager$1 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Dependent)element$iv$iv;
                        $i$a$-filter-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$dependantsResult$1 = false;
                        if (!(it instanceof Dependent.CallExpression == false && it instanceof Dependent.BinaryOperatorDependent == false)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Dependent)item$iv$iv;
                        var25_43 = destination$iv$iv;
                        $i$a$-map-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$dependantsResult$2 = false;
                        callExpression = ReactiveStreamsUtils.getCallExpressionSelectorOrThis(dependent.getElement());
                        v4 = callExpression;
                        if (v4 == null) ** GOTO lbl-1000
                        if (ReactiveStreamsNonBlockingSchedulerCheckerKt.access$isSchedulingOnNonBlockingScope(v4, SchedulingType.ALL_CHAIN)) {
                            v5 = ReactiveStreamsNonBlockingSchedulerChecker.INSTANCE.getScopeByDependants($this$getScopeByDependants, dependencyGraph, dependent.getElement(), depth + 1, new ScopeWithDepth(new Scope.NonBlocking(callExpression, SchedulingType.ALL_CHAIN), depth));
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (callExpression != null) {
                                var20_37 = false;
                                var21_39 = false;
                                it = var19_34;
                                $i$a$-let-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$dependantsResult$2$calculatedRes$1 = false;
                                v6 = nonBlockingAnalysisManager;
                                v7 = v6 != null ? v6.getSchedulingMethodInfo(it, SchedulingType.ALL_CHAIN) : null;
                            } else {
                                v7 = null;
                            }
                            v5 = v7 != null ? ReactiveStreamsNonBlockingSchedulerChecker.INSTANCE.getScopeByDependants($this$getScopeByDependants, dependencyGraph, dependent.getElement(), depth + 1, new ScopeWithDepth(Scope.DeclaredPossiblyBlocking.INSTANCE, depth)) : ReactiveStreamsNonBlockingSchedulerChecker.INSTANCE.getScopeByDependants($this$getScopeByDependants, dependencyGraph, dependent.getElement(), depth + 1, lastScope);
                        }
                        calculatedRes = v5;
                        var26_44 = calculatedRes;
                        var25_43.add(var26_44);
                    }
                    v8 = (List)destination$iv$iv;
                    break block30;
                }
                v8 = null;
            }
            $this$allDeclaredPossiblyBlocking$iv = dependantsResult = v8;
            $i$f$allDeclaredPossiblyBlocking = false;
            v9 = $this$allDeclaredPossiblyBlocking$iv;
            if (v9 == null) ** GOTO lbl-1000
            destination$iv$iv = v9;
            $i$f$mapTo = false;
            if (!(destination$iv$iv.isEmpty() == false)) ** GOTO lbl-1000
            $this$all$iv$iv = $this$allDeclaredPossiblyBlocking$iv;
            $i$f$all = false;
            if ($this$all$iv$iv instanceof Collection && ((Collection)$this$all$iv$iv).isEmpty()) {
                v10 = true;
            } else {
                var14_22 = $this$all$iv$iv.iterator();
                while (var14_22.hasNext()) {
                    it$iv = element$iv$iv = var14_22.next();
                    $i$a$-all-ReactiveStreamsNonBlockingSchedulerCheckerKt$allDeclaredPossiblyBlocking$1$iv = false;
                    receiver = it$iv;
                    $i$a$-unknown-Object = false;
                    if (((ScopeWithDepth)receiver).getScope() instanceof Scope.DeclaredPossiblyBlocking) continue;
                    v10 = false;
                    break block27;
                }
                v10 = true;
            }
        }
        if (v10) {
            v11 = true;
        } else lbl-1000:
        // 3 sources

        {
            v11 = false;
        }
        if (v11) {
            v12 = dependantsResult;
            Intrinsics.checkNotNull(v12);
            $this$maxByOrNull$iv = v12;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v13 = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v13 = maxElem$iv;
                } else {
                    it = (ScopeWithDepth)maxElem$iv;
                    $i$a$-maxByOrNull-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$resultFromDependents$2 = false;
                    maxValue$iv = it.getDepth();
                    do {
                        e$iv = iterator$iv.next();
                        it = (ScopeWithDepth)e$iv;
                        $i$a$-maxByOrNull-ReactiveStreamsNonBlockingSchedulerChecker$getScopeByDependants$resultFromDependents$2 = false;
                        v$iv = it.getDepth();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v13 = maxElem$iv;
                }
            }
            v14 = v13;
        } else {
            block28: {
                $this$findNonBlocking$iv = dependantsResult;
                $i$f$findNonBlocking = false;
                v15 = $this$findNonBlocking$iv;
                if (v15 != null) {
                    var12_19 = v15;
                    var13_20 = false;
                    var14_22 = var12_19;
                    var15_27 = false;
                    var16_28 = var14_22.iterator();
                    while (var16_28.hasNext()) {
                        it$iv = var17_32 = var16_28.next();
                        $i$a$-find-ReactiveStreamsNonBlockingSchedulerCheckerKt$findNonBlocking$1$iv = false;
                        receiver = it$iv;
                        $i$a$-unknown-Object = false;
                        if (!(((ScopeWithDepth)receiver).getScope() instanceof Scope.NonBlocking)) continue;
                        v16 = var17_32;
                        break block28;
                    }
                    v16 = null;
                } else {
                    v16 = null;
                }
            }
            v14 = v16;
        }
        if ((v17 = (resultFromDependents = v14)) == null) {
            v17 = result = lastScope;
        }
        if (result.getDepth() > depth) {
            $this$getScopeByDependants.putDownCache(element, result.getScope());
        } else {
            $this$getScopeByDependants.putDownCache(element, Scope.Unknown.INSTANCE);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Scope getScopeByDependencies(NonBlockingAnalysisCache $this$getScopeByDependencies, UastLocalUsageDependencyGraph dependencyGraph, UElement element, int depth, Scope subscribeOnScope) {
        Scope scope;
        Scope resultFromDependencies;
        Scope scope2;
        List scopes;
        block26: {
            List list;
            Set set;
            ReactiveStreamsNonBlockingAnalysisManager nonBlockingAnalysisManager;
            block25: {
                ReactiveStreamsNonBlockingAnalysisManager reactiveStreamsNonBlockingAnalysisManager;
                ProgressManager.checkCanceled();
                this.checkDepth(depth);
                Scope currentScopeInfo = $this$getScopeByDependencies.getUpCache(element);
                if (currentScopeInfo != null) {
                    return currentScopeInfo;
                }
                PsiElement psiElement = element.getSourcePsi();
                if (psiElement != null && (psiElement = psiElement.getProject()) != null) {
                    PsiElement psiElement2 = psiElement;
                    boolean bl = false;
                    boolean bl2 = false;
                    PsiElement psiElement3 = psiElement2;
                    boolean bl3 = false;
                    PsiElement psiElement4 = psiElement3;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"it");
                    reactiveStreamsNonBlockingAnalysisManager = ReactiveStreamsNonBlockingAnalysisManager.Companion.getInstance((Project)psiElement4);
                } else {
                    reactiveStreamsNonBlockingAnalysisManager = null;
                }
                nonBlockingAnalysisManager = reactiveStreamsNonBlockingAnalysisManager;
                set = (Set)dependencyGraph.getDependencies().get(element);
                if (set != null) break block25;
                list = null;
                break block26;
            }
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : iterable) {
                Object object;
                Collection collection;
                block24: {
                    block30: {
                        boolean bl;
                        void var18_24;
                        void dependency;
                        block28: {
                            UCallExpression uCallExpression;
                            block29: {
                                block27: {
                                    Dependency dependency2 = (Dependency)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl4 = false;
                                    var18_24 = dependency;
                                    if (!(var18_24 instanceof Dependency.BranchingDependency)) break block27;
                                    Iterable $this$map$iv2 = dependency.getElements();
                                    boolean $i$f$map2 = false;
                                    Iterable iterable2 = $this$map$iv2;
                                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                                    boolean $i$f$mapTo2 = false;
                                    for (Object item$iv$iv2 : iterable2) {
                                        void it;
                                        UElement uElement = (UElement)item$iv$iv2;
                                        Collection collection2 = destination$iv$iv2;
                                        boolean bl5 = false;
                                        Scope scope3 = INSTANCE.getScopeByDependencies($this$getScopeByDependencies, dependencyGraph, (UElement)it, depth + 1, subscribeOnScope);
                                        collection2.add(scope3);
                                    }
                                    List list2 = (List)destination$iv$iv2;
                                    Scope branchesResult = ReactiveStreamsNonBlockingSchedulerCheckerKt.access$allDeclaredPossiblyBlocking(list2) ? (Scope)Scope.DeclaredPossiblyBlocking.INSTANCE : ReactiveStreamsNonBlockingSchedulerCheckerKt.access$findNonBlocking(list2);
                                    object = branchesResult;
                                    if (object == null) {
                                        object = Scope.Unknown.INSTANCE;
                                    }
                                    break block24;
                                }
                                if (!(var18_24 instanceof Dependency.CommonDependency)) break block28;
                                uCallExpression = ReactiveStreamsUtils.getCallExpressionSelectorOrThis(((Dependency.CommonDependency)dependency).getElement());
                                UCallExpression uCallExpression2 = uCallExpression;
                                if (uCallExpression2 == null || !ReactiveStreamsNonBlockingSchedulerCheckerKt.access$isSchedulingOnNonBlockingScope(uCallExpression2, SchedulingType.NEXT_OPERATORS)) break block29;
                                object = new Scope.NonBlocking(uCallExpression, SchedulingType.NEXT_OPERATORS);
                                break block24;
                            }
                            UCallExpression uCallExpression3 = uCallExpression;
                            if (uCallExpression3 != null && ReactiveStreamsNonBlockingSchedulerCheckerKt.access$isSchedulingOnNonBlockingScope(uCallExpression3, SchedulingType.ALL_CHAIN)) {
                                UElement uElement = ((Dependency.CommonDependency)dependency).getElement();
                                Scope scope4 = subscribeOnScope;
                                if (scope4 == null) {
                                    scope4 = new Scope.NonBlocking(uCallExpression, SchedulingType.ALL_CHAIN);
                                }
                                object = INSTANCE.getScopeByDependencies($this$getScopeByDependencies, dependencyGraph, uElement, depth + 1, scope4);
                                break block24;
                            } else {
                                SchedulingMethodCallInfo schedulingMethodCallInfo;
                                if (uCallExpression != null) {
                                    UCallExpression uCallExpression4;
                                    bl = false;
                                    boolean bl6 = false;
                                    UCallExpression it = uCallExpression4;
                                    boolean bl7 = false;
                                    ReactiveStreamsNonBlockingAnalysisManager reactiveStreamsNonBlockingAnalysisManager = nonBlockingAnalysisManager;
                                    schedulingMethodCallInfo = reactiveStreamsNonBlockingAnalysisManager != null ? reactiveStreamsNonBlockingAnalysisManager.getSchedulingMethodInfo(it, SchedulingType.ALL_CHAIN) : null;
                                } else {
                                    schedulingMethodCallInfo = null;
                                }
                                if (schedulingMethodCallInfo != null) {
                                    UElement uElement = ((Dependency.CommonDependency)dependency).getElement();
                                    Scope scope5 = subscribeOnScope;
                                    if (scope5 == null) {
                                        scope5 = Scope.Unknown.INSTANCE;
                                    }
                                    object = INSTANCE.getScopeByDependencies($this$getScopeByDependencies, dependencyGraph, uElement, depth + 1, scope5);
                                    break block24;
                                } else {
                                    SchedulingMethodCallInfo schedulingMethodCallInfo2;
                                    if (uCallExpression != null) {
                                        UCallExpression uCallExpression5;
                                        bl = false;
                                        boolean bl8 = false;
                                        UCallExpression it = uCallExpression5;
                                        boolean bl9 = false;
                                        ReactiveStreamsNonBlockingAnalysisManager reactiveStreamsNonBlockingAnalysisManager = nonBlockingAnalysisManager;
                                        schedulingMethodCallInfo2 = reactiveStreamsNonBlockingAnalysisManager != null ? reactiveStreamsNonBlockingAnalysisManager.getSchedulingMethodInfo(it, SchedulingType.NEXT_OPERATORS) : null;
                                    } else {
                                        schedulingMethodCallInfo2 = null;
                                    }
                                    object = schedulingMethodCallInfo2 == null ? INSTANCE.getScopeByDependencies($this$getScopeByDependencies, dependencyGraph, ((Dependency.CommonDependency)dependency).getElement(), depth + 1, subscribeOnScope) : (Scope)Scope.DeclaredPossiblyBlocking.INSTANCE;
                                }
                            }
                            break block24;
                        }
                        if (!(var18_24 instanceof Dependency.ArgumentDependency)) {
                            throw new NoWhenBranchMatchedException();
                        }
                        object = ((Dependency.ArgumentDependency)dependency).getElement().getSourcePsi();
                        if (object == null || (object = object.getProject()) == null) break block30;
                        Object object2 = object;
                        boolean bl10 = false;
                        bl = false;
                        Object object3 = object2;
                        boolean bl11 = false;
                        Object object4 = object3;
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it");
                        object = ReactiveStreamsNonBlockingAnalysisManager.Companion.getInstance((Project)object4);
                        if (object == null || (object = object.getAnalysableArgument((Dependency.ArgumentDependency)dependency)) == null) break block30;
                        Object object5 = object;
                        bl10 = false;
                        bl = false;
                        Object object6 = object5;
                        boolean bl12 = false;
                        object = INSTANCE.getScopeByDependencies($this$getScopeByDependencies, dependencyGraph, (UElement)object6, depth + 1, subscribeOnScope);
                        if (object != null) break block24;
                    }
                    object = Scope.DeclaredPossiblyBlocking.INSTANCE;
                }
                Object object7 = object;
                Object object8 = object7;
                collection.add(object8);
            }
            list = scopes = (List)destination$iv$iv;
        }
        if ((scope2 = (resultFromDependencies = ReactiveStreamsNonBlockingSchedulerCheckerKt.access$allDeclaredPossiblyBlocking(scopes) ? (Scope)Scope.DeclaredPossiblyBlocking.INSTANCE : ReactiveStreamsNonBlockingSchedulerCheckerKt.access$findNonBlocking(scopes))) == null) {
            scope2 = scope = subscribeOnScope;
        }
        if (scope2 == null) {
            scope = Scope.Unknown.INSTANCE;
        }
        Scope calculatedResult = scope;
        $this$getScopeByDependencies.putUpCache(element, calculatedResult);
        return calculatedResult;
    }

    static /* synthetic */ Scope getScopeByDependencies$default(ReactiveStreamsNonBlockingSchedulerChecker reactiveStreamsNonBlockingSchedulerChecker, NonBlockingAnalysisCache nonBlockingAnalysisCache, UastLocalUsageDependencyGraph uastLocalUsageDependencyGraph, UElement uElement, int n, Scope scope, int n2, Object object) {
        if ((n2 & 8) != 0) {
            scope = null;
        }
        return reactiveStreamsNonBlockingSchedulerChecker.getScopeByDependencies(nonBlockingAnalysisCache, uastLocalUsageDependencyGraph, uElement, n, scope);
    }

    private ReactiveStreamsNonBlockingSchedulerChecker() {
    }

    static {
        ReactiveStreamsNonBlockingSchedulerChecker reactiveStreamsNonBlockingSchedulerChecker;
        INSTANCE = reactiveStreamsNonBlockingSchedulerChecker = new ReactiveStreamsNonBlockingSchedulerChecker();
        Logger logger = Logger.getInstance(ReactiveStreamsNonBlockingSchedulerChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\n    \u2026dulerChecker::class.java)");
        LOG = logger;
        maxRecursionDepth = Registry.intValue((String)"reactor.non.blocking.scheduler.checker.max.recursion.limit", (int)300);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$TooDeepRecursionException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "()V", "intellij.reactivestreams"})
    private static final class TooDeepRecursionException
    extends RuntimeException {
        public static final TooDeepRecursionException INSTANCE;

        private TooDeepRecursionException() {
            super("too deep recursion while traversing graph", null, false, false);
        }

        static {
            TooDeepRecursionException tooDeepRecursionException;
            INSTANCE = tooDeepRecursionException = new TooDeepRecursionException();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$ScopeWithDepth;", "", "scope", "Lcom/intellij/reactivestreams/inspections/Scope;", "depth", "", "(Lcom/intellij/reactivestreams/inspections/Scope;I)V", "getDepth", "()I", "getScope", "()Lcom/intellij/reactivestreams/inspections/Scope;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.reactivestreams"})
    private static final class ScopeWithDepth {
        @NotNull
        private final Scope scope;
        private final int depth;

        @NotNull
        public final Scope getScope() {
            return this.scope;
        }

        public final int getDepth() {
            return this.depth;
        }

        public ScopeWithDepth(@NotNull Scope scope, int depth) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.scope = scope;
            this.depth = depth;
        }

        @NotNull
        public final Scope component1() {
            return this.scope;
        }

        public final int component2() {
            return this.depth;
        }

        @NotNull
        public final ScopeWithDepth copy(@NotNull Scope scope, int depth) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            return new ScopeWithDepth(scope, depth);
        }

        public static /* synthetic */ ScopeWithDepth copy$default(ScopeWithDepth scopeWithDepth, Scope scope, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                scope = scopeWithDepth.scope;
            }
            if ((n2 & 2) != 0) {
                n = scopeWithDepth.depth;
            }
            return scopeWithDepth.copy(scope, n);
        }

        @NotNull
        public String toString() {
            return "ScopeWithDepth(scope=" + this.scope + ", depth=" + this.depth + ")";
        }

        public int hashCode() {
            Scope scope = this.scope;
            return (scope != null ? scope.hashCode() : 0) * 31 + Integer.hashCode(this.depth);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ScopeWithDepth)) break block3;
                    ScopeWithDepth scopeWithDepth = (ScopeWithDepth)object;
                    if (!Intrinsics.areEqual((Object)this.scope, (Object)scopeWithDepth.scope) || this.depth != scopeWithDepth.depth) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingSchedulerChecker$FindCauseBecauseSchedulingFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "startInWriteAction", "", "intellij.reactivestreams"})
    public static final class FindCauseBecauseSchedulingFix
    implements LocalQuickFix {
        public static final FindCauseBecauseSchedulingFix INSTANCE;

        @NotNull
        public String getFamilyName() {
            return ReactiveStreamsBundle.message("inspections.blocking.in.non.blocking.quickfix.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            UFunctionalObject uFunctionalObject;
            block17: {
                block16: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    uFunctionalObject = UastContextKt.toUElement((PsiElement)descriptor.getPsiElement());
                    if (uFunctionalObject == null) break block16;
                    UFunctionalObject uFunctionalObject2 = uFunctionalObject;
                    boolean bl = false;
                    boolean bl2 = false;
                    UFunctionalObject uElement = uFunctionalObject2;
                    boolean bl3 = false;
                    uFunctionalObject = UFunctionalObject.Companion.fromSuitableParent(uElement, applyFix.operatorCall.1.1.INSTANCE);
                    if (uFunctionalObject != null && (uFunctionalObject = uFunctionalObject.getContext()) != null && (uFunctionalObject = uFunctionalObject.getCallExpression()) != null) break block17;
                }
                return;
            }
            UFunctionalObject operatorCall2 = uFunctionalObject;
            UMethod uMethod = UastUtils.getContainingUMethod((UElement)operatorCall2);
            if (uMethod == null) {
                return;
            }
            UMethod containingUMethod = uMethod;
            UastLocalUsageDependencyGraph uastLocalUsageDependencyGraph = UastLocalUsageDependencyGraph.Companion.getGraphByUElement((UElement)containingUMethod);
            if (uastLocalUsageDependencyGraph == null) {
                return;
            }
            UastLocalUsageDependencyGraph dependencyGraph = uastLocalUsageDependencyGraph;
            NonBlockingAnalysisCache nonBlockingAnalysisCache = NonBlockingAnalysisCache.Companion.getCache(containingUMethod);
            if (nonBlockingAnalysisCache == null) {
                return;
            }
            NonBlockingAnalysisCache cache = nonBlockingAnalysisCache;
            Scope scope = INSTANCE.calculateScope(cache, dependencyGraph, operatorCall2);
            if (!(scope instanceof Scope.NonBlocking)) {
                scope = null;
            }
            Scope.NonBlocking nonBlocking = (Scope.NonBlocking)scope;
            if (nonBlocking == null) {
                return;
            }
            Scope.NonBlocking scope2 = nonBlocking;
            SchedulingMethodCallInfo schedulingMethodCallInfo = ReactiveStreamsNonBlockingAnalysisManager.Companion.getInstance(project).getSchedulingMethodInfo(scope2.getCause(), SchedulingType.ALL);
            if (schedulingMethodCallInfo == null) {
                return;
            }
            SchedulingMethodCallInfo schedulingInfo = schedulingMethodCallInfo;
            String hintText = null;
            UIdentifier navigablePsi = null;
            if (schedulingInfo.getScheduler() != null) {
                UCallExpression scheduler = schedulingInfo.getScheduler();
                UIdentifier uIdentifier = scheduler.getMethodIdentifier();
                if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
                    return;
                }
                navigablePsi = uIdentifier;
                String string = scheduler.getMethodName();
                if (string == null) {
                    return;
                }
                String schedulerName = string;
                hintText = ReactiveStreamsBundle.message("inspections.blocking.in.non.blocking.quickfix.text", schedulerName);
            } else {
                UIdentifier uIdentifier = schedulingInfo.getCallExpression().getMethodIdentifier();
                if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
                    return;
                }
                navigablePsi = uIdentifier;
                Object object = schedulingInfo.getCallExpression().resolve();
                if (object == null || (object = ReactiveStreamsNonBlockingSchedulerCheckerKt.access$getNameWithClassName$p(object)) == null) {
                    return;
                }
                Object methodName = object;
                hintText = ReactiveStreamsBundle.message("inspections.blocking.in.non.blocking.quickfix.alternative.text", methodName, schedulingInfo.getSchedulerInfo());
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
            Editor editor = fileEditorManager.getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"FileEditorManager.getIns\u2026ectedTextEditor ?: return");
            Editor editor2 = editor;
            PsiNavigationSupport psiNavigationSupport = PsiNavigationSupport.getInstance();
            PsiFile psiFile = navigablePsi.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"navigablePsi.containingFile");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            TextRange textRange = navigablePsi.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"navigablePsi.textRange");
            psiNavigationSupport.createNavigatable(project, virtualFile, textRange.getStartOffset()).navigate(true);
            HintManager hintManager = HintManager.getInstance();
            hintManager.showInformationHint(editor2, hintText);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private FindCauseBecauseSchedulingFix() {
        }

        static {
            FindCauseBecauseSchedulingFix findCauseBecauseSchedulingFix;
            INSTANCE = findCauseBecauseSchedulingFix = new FindCauseBecauseSchedulingFix();
        }
    }
}

