/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBlockingScopeCheckResult;
import com.intellij.reactivestreams.inspections.ReactiveStreamsNonBlockingSchedulerChecker;
import com.intellij.reactivestreams.inspections.ReactiveStreamsUastInspectionBase;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;

public abstract class ReactiveStreamsBaseNonBlockingScopeInspection
extends ReactiveStreamsUastInspectionBase {
    public ReactiveStreamsBaseNonBlockingScopeInspection() {
        super(new Class[0]);
    }

    protected abstract boolean isAvailable(@NotNull Project var1);

    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ReactiveStreamsBaseNonBlockingScopeInspection.$$$reportNull$$$0(0);
        }
        if (!this.isAvailable(holder.getProject())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ReactiveStreamsBaseNonBlockingScopeInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                UCallExpression callExpression;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((callExpression = AnalysisUastUtil.getUCallExpression((PsiElement)element)) == null) {
                    return;
                }
                if (!ReactiveStreamsBaseNonBlockingScopeInspection.this.isSuspiciousCallOnPublisher(callExpression)) {
                    return;
                }
                ReactiveStreamsBlockingScopeCheckResult checkResult = ReactiveStreamsBaseNonBlockingScopeInspection.isCalledInNonBlockingContext(callExpression);
                if (checkResult instanceof ReactiveStreamsBlockingScopeCheckResult.Unknown) {
                    return;
                }
                PsiElement methodIdentifierPsi = AnalysisUastUtil.getMethodIdentifierSourcePsi((UCallExpression)callExpression);
                if (methodIdentifierPsi == null) {
                    return;
                }
                ReactiveStreamsBaseNonBlockingScopeInspection.this.report(holder, methodIdentifierPsi, ((ReactiveStreamsBlockingScopeCheckResult.NonBlocking)checkResult).getQuickFixes());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/reactivestreams/inspections/ReactiveStreamsBaseNonBlockingScopeInspection$1", "visitElement"));
            }
        };
    }

    protected abstract void report(@NotNull ProblemsHolder var1, @NotNull PsiElement var2, LocalQuickFix @NotNull [] var3);

    protected boolean isSuspiciousCallOnPublisher(UCallExpression callExpression) {
        UExpression receiver = callExpression.getReceiver();
        if (receiver == null) {
            return false;
        }
        if (!ReactiveStreamsUtils.isMethodDefinedInKnownPublisher(callExpression.resolve())) {
            return false;
        }
        if (!ReactiveStreamsBaseNonBlockingScopeInspection.isMethodFromPublisher(callExpression)) {
            return false;
        }
        return this.shouldReportCall(receiver, callExpression);
    }

    protected abstract boolean shouldReportCall(UExpression var1, UCallExpression var2);

    private static boolean isMethodFromPublisher(UCallExpression expression) {
        PsiMethod calledMethod = expression.resolve();
        if (calledMethod == null) {
            return false;
        }
        return ReactiveStreamsBaseNonBlockingScopeInspection.isMethodFromPublisher(calledMethod);
    }

    public static boolean isMethodFromPublisher(@NotNull PsiMethod calledMethod) {
        PsiMethod[] superMethods;
        if (calledMethod == null) {
            ReactiveStreamsBaseNonBlockingScopeInspection.$$$reportNull$$$0(2);
        }
        if ((superMethods = calledMethod.findDeepestSuperMethods()).length == 0) {
            PsiClass methodClass = calledMethod.getContainingClass();
            return ReactiveStreamsUtils.isPublisherFromImplementation(methodClass);
        }
        for (PsiMethod superMethod : superMethods) {
            PsiClass methodClass = superMethod.getContainingClass();
            if (ReactiveStreamsUtils.isPublisherFromImplementation(methodClass)) continue;
            return false;
        }
        return true;
    }

    public static ReactiveStreamsBlockingScopeCheckResult isCalledInNonBlockingContext(@NotNull UCallExpression expression) {
        PsiType contextMethodReturnType;
        if (expression == null) {
            ReactiveStreamsBaseNonBlockingScopeInspection.$$$reportNull$$$0(3);
        }
        if (ReactiveStreamsUtils.isPublisher(contextMethodReturnType = AnalysisUastUtil.getContainingMethodOrLambdaReturnType((UCallExpression)expression))) {
            return new ReactiveStreamsBlockingScopeCheckResult.NonBlocking(LocalQuickFix.EMPTY_ARRAY);
        }
        return ReactiveStreamsNonBlockingSchedulerChecker.INSTANCE.isCalledInNonBlockingScope(expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/reactivestreams/inspections/ReactiveStreamsBaseNonBlockingScopeInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/reactivestreams/inspections/ReactiveStreamsBaseNonBlockingScopeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doBuildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMethodFromPublisher";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCalledInNonBlockingContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

