/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.context;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.artifact.GavCalculator;
import org.sonatype.nexus.artifact.M2GavCalculator;
import org.sonatype.nexus.index.context.DocumentFilter;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.context.IndexUtils;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.context.NexusAnalyzer;
import org.sonatype.nexus.index.context.NexusIndexWriter;
import org.sonatype.nexus.index.context.UnsupportedExistingLuceneIndexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIndexingContext
implements IndexingContext {
    private static final String INDEX_DIRECTORY = ".index";
    private static final String FLD_DESCRIPTOR = "DESCRIPTOR";
    private static final String FLD_DESCRIPTOR_CONTENTS = "NexusIndex";
    private static final String FLD_IDXINFO = "IDXINFO";
    private static final String VERSION = "1.0";
    private static final Term DESCRIPTOR_TERM = new Term("DESCRIPTOR", "NexusIndex");
    private Object indexLock = new Object();
    private Directory indexDirectory;
    private File indexDirectoryFile;
    private String id;
    private boolean searchable;
    private String repositoryId;
    private File repository;
    private String repositoryUrl;
    private String indexUpdateUrl;
    private Analyzer analyzer;
    private IndexReader indexReader;
    private IndexSearcher indexSearcher;
    private NexusIndexWriter indexWriter;
    private Date timestamp;
    private List<? extends IndexCreator> indexCreators;
    private GavCalculator gavCalculator;

    private DefaultIndexingContext(String id, String repositoryId, File repository, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators) {
        this.id = id;
        this.searchable = true;
        this.repositoryId = repositoryId;
        this.repository = repository;
        this.repositoryUrl = repositoryUrl;
        this.indexUpdateUrl = indexUpdateUrl;
        this.analyzer = new NexusAnalyzer();
        this.indexReader = null;
        this.indexWriter = null;
        this.indexCreators = indexCreators;
        this.gavCalculator = new M2GavCalculator();
    }

    public DefaultIndexingContext(String id, String repositoryId, File repository, File indexDirectoryFile, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        this(id, repositoryId, repository, repositoryUrl, indexUpdateUrl, indexCreators);
        this.indexDirectoryFile = indexDirectoryFile;
        this.indexDirectory = FSDirectory.getDirectory((File)indexDirectoryFile);
        this.prepareIndex(reclaimIndex);
    }

    public DefaultIndexingContext(String id, String repositoryId, File repository, Directory indexDirectory, String repositoryUrl, String indexUpdateUrl, List<? extends IndexCreator> indexCreators, boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        this(id, repositoryId, repository, repositoryUrl, indexUpdateUrl, indexCreators);
        this.indexDirectory = indexDirectory;
        if (indexDirectory instanceof FSDirectory) {
            this.indexDirectoryFile = ((FSDirectory)indexDirectory).getFile();
        }
        this.prepareIndex(reclaimIndex);
    }

    @Override
    public Directory getIndexDirectory() {
        return this.indexDirectory;
    }

    @Override
    public File getIndexDirectoryFile() {
        return this.indexDirectoryFile;
    }

    private void prepareIndex(boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        if (IndexReader.indexExists((Directory)this.indexDirectory)) {
            if (IndexReader.isLocked((Directory)this.indexDirectory)) {
                IndexReader.unlock((Directory)this.indexDirectory);
            }
            this.checkAndUpdateIndexDescriptor(reclaimIndex);
        } else {
            if (StringUtils.isEmpty((String)this.getRepositoryId())) {
                throw new IllegalArgumentException("The repositoryId cannot be null when creating new repository!");
            }
            new NexusIndexWriter(this.indexDirectory, this.analyzer, true).close();
            this.storeDescriptor();
        }
        this.timestamp = IndexUtils.getTimestamp(this.indexDirectory);
    }

    private void checkAndUpdateIndexDescriptor(boolean reclaimIndex) throws IOException, UnsupportedExistingLuceneIndexException {
        if (reclaimIndex) {
            this.storeDescriptor();
            return;
        }
        Hits hits = this.getIndexSearcher().search((Query)new TermQuery(DESCRIPTOR_TERM));
        if (hits == null || hits.length() == 0) {
            throw new UnsupportedExistingLuceneIndexException("The existing index has no NexusIndexer descriptor");
        }
        Document descriptor = hits.doc(0);
        if (hits.length() != 1) {
            this.storeDescriptor();
            return;
        }
        String[] h = StringUtils.split((String)descriptor.get(FLD_IDXINFO), (String)"|");
        String repoId = h[1];
        if (this.getRepositoryId() == null) {
            this.repositoryId = repoId;
        } else if (!this.getRepositoryId().equals(repoId)) {
            throw new UnsupportedExistingLuceneIndexException("The existing index is for repository [" + repoId + "] and not for repository [" + this.getRepositoryId() + "]");
        }
    }

    private void storeDescriptor() throws IOException {
        Document hdr = new Document();
        hdr.add((Fieldable)new Field(FLD_DESCRIPTOR, FLD_DESCRIPTOR_CONTENTS, Field.Store.YES, Field.Index.UN_TOKENIZED));
        hdr.add((Fieldable)new Field(FLD_IDXINFO, "1.0|" + this.getRepositoryId(), Field.Store.YES, Field.Index.NO));
        IndexWriter w = this.getIndexWriter();
        w.updateDocument(DESCRIPTOR_TERM, hdr);
        w.flush();
    }

    private void deleteIndexFiles() throws IOException {
        String[] names = this.indexDirectory.list();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                this.indexDirectory.deleteFile(names[i]);
            }
        }
        IndexUtils.deleteTimestamp(this.indexDirectory);
    }

    @Override
    public boolean isSearchable() {
        return this.searchable;
    }

    @Override
    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void updateTimestamp() throws IOException {
        this.updateTimestamp(false);
    }

    @Override
    public void updateTimestamp(boolean save) throws IOException {
        this.updateTimestamp(save, new Date());
    }

    @Override
    public void updateTimestamp(boolean save, Date timestamp) throws IOException {
        this.timestamp = timestamp;
        if (save) {
            IndexUtils.updateTimestamp(this.indexDirectory, this.getTimestamp());
        }
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public File getRepository() {
        return this.repository;
    }

    @Override
    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Override
    public String getIndexUpdateUrl() {
        if (this.repositoryUrl != null && (this.indexUpdateUrl == null || this.indexUpdateUrl.trim().length() == 0)) {
            return this.repositoryUrl + (this.repositoryUrl.endsWith("/") ? "" : "/") + INDEX_DIRECTORY;
        }
        return this.indexUpdateUrl;
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexWriter getIndexWriter() throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            if (this.indexWriter == null || this.indexWriter.isClosed()) {
                this.indexWriter = new NexusIndexWriter(this.indexDirectory, this.analyzer, false);
                this.indexWriter.setRAMBufferSizeMB(2.0);
            }
            return this.indexWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexReader getIndexReader() throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            if (this.indexReader == null || !this.indexReader.isCurrent()) {
                if (this.indexReader != null) {
                    this.indexReader.close();
                }
                this.indexReader = IndexReader.open((Directory)this.indexDirectory);
            }
            return this.indexReader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexSearcher getIndexSearcher() throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            if (this.indexSearcher == null || this.getIndexReader() != this.indexSearcher.getIndexReader()) {
                if (this.indexSearcher != null) {
                    this.indexSearcher.close();
                    this.indexSearcher.getIndexReader().close();
                }
                this.indexSearcher = new IndexSearcher(this.getIndexReader());
            }
            return this.indexSearcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimize() throws CorruptIndexException, IOException {
        IndexWriter w = this.getIndexWriter();
        try {
            w.optimize();
            w.flush();
        }
        finally {
            w.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean deleteFiles) throws IOException {
        if (this.indexDirectory != null) {
            Object object = this.indexLock;
            synchronized (object) {
                IndexUtils.updateTimestamp(this.indexDirectory, this.getTimestamp());
                this.closeReaders();
                if (deleteFiles) {
                    this.deleteIndexFiles();
                }
                this.indexDirectory.close();
            }
        }
        this.indexDirectory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            this.closeReaders();
            this.deleteIndexFiles();
            try {
                this.prepareIndex(true);
            }
            catch (UnsupportedExistingLuceneIndexException unsupportedExistingLuceneIndexException) {
                // empty catch block
            }
            this.rebuildGroups();
            this.updateTimestamp(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(Directory directory) throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            this.closeReaders();
            this.deleteIndexFiles();
            Directory.copy((Directory)directory, (Directory)this.indexDirectory, (boolean)false);
            this.storeDescriptor();
            this.timestamp = IndexUtils.getTimestamp(directory);
            IndexUtils.updateTimestamp(this.indexDirectory, this.getTimestamp());
            this.optimize();
        }
    }

    @Override
    public void merge(Directory directory) throws IOException {
        this.merge(directory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(Directory directory, DocumentFilter filter) throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            this.closeReaders();
            IndexWriter w = this.getIndexWriter();
            IndexSearcher s = this.getIndexSearcher();
            IndexReader r = IndexReader.open((Directory)directory);
            try {
                int numDocs = r.maxDoc();
                for (int i = 0; i < numDocs; ++i) {
                    if (r.isDeleted(i)) continue;
                    Document d = r.document(i);
                    if (filter != null && !filter.accept(d)) continue;
                    String uinfo = d.get("u");
                    if (uinfo != null) {
                        Hits hits = s.search((Query)new TermQuery(new Term("u", uinfo)));
                        if (hits.length() != 0) continue;
                        w.addDocument(IndexUtils.updateDocument(d, this));
                        continue;
                    }
                    String deleted = d.get("del");
                    if (deleted == null) continue;
                    w.deleteDocuments(new Term("u", deleted));
                }
            }
            finally {
                r.close();
                this.closeReaders();
            }
            this.rebuildGroups();
            Date mergedTimestamp = IndexUtils.getTimestamp(directory);
            if (this.getTimestamp() != null && mergedTimestamp != null && mergedTimestamp.after(this.getTimestamp())) {
                this.updateTimestamp(true, mergedTimestamp);
            } else {
                this.updateTimestamp(true);
            }
            this.optimize();
        }
    }

    private void closeReaders() throws CorruptIndexException, IOException {
        if (this.indexWriter != null) {
            if (!this.indexWriter.isClosed()) {
                this.indexWriter.close();
            }
            this.indexWriter = null;
        }
        if (this.indexSearcher != null) {
            this.indexSearcher.close();
            this.indexSearcher.getIndexReader().close();
            this.indexSearcher = null;
        }
        if (this.indexReader != null) {
            this.indexReader.close();
            this.indexReader = null;
        }
    }

    @Override
    public GavCalculator getGavCalculator() {
        return this.gavCalculator;
    }

    @Override
    public List<IndexCreator> getIndexCreators() {
        return Collections.unmodifiableList(this.indexCreators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildGroups() throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            IndexUtils.rebuildGroups(this);
        }
    }

    @Override
    public Set<String> getAllGroups() throws IOException {
        return IndexUtils.getAllGroups(this);
    }

    @Override
    public void setAllGroups(Collection<String> groups) throws IOException {
        IndexUtils.setAllGroups(this, groups);
    }

    @Override
    public Set<String> getRootGroups() throws IOException {
        return IndexUtils.getRootGroups(this);
    }

    @Override
    public void setRootGroups(Collection<String> groups) throws IOException {
        IndexUtils.setRootGroups(this, groups);
    }

    public String toString() {
        return this.id + " : " + this.timestamp;
    }
}

