/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftp.FtpRandomAccessContent;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.Messages;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.jetbrains.annotations.NotNull;

public class FtpFileObject
extends AbstractFileObject<FtpFileSystem> {
    private static final Map<String, FTPFile> EMPTY_FTP_FILE_MAP = Collections.unmodifiableMap(new TreeMap());
    private static final FTPFile UNKNOWN = new FTPFile();
    private final Log log = LogFactory.getLog(FtpFileObject.class);
    private final String relPath;
    private FTPFile fileInfo;
    private Map<String, FTPFile> children;
    private FtpFileObject linkDestination;
    private long mdtm;
    private boolean inRefresh;

    protected FtpFileObject(@NotNull AbstractFileName name, FtpFileSystem fileSystem, FileName rootName) throws FileSystemException {
        super(name, fileSystem);
        String relPath = UriParser.decode(rootName.getRelativeName(name));
        this.relPath = ".".equals(relPath) ? null : relPath;
    }

    private FTPFile getChildFile(String name, boolean flush) throws IOException {
        if (flush && !this.inRefresh) {
            this.children = null;
        }
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        FTPFile ftpFile = this.children.get(name);
        return ftpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetChildren() throws IOException {
        if (this.children != null) {
            return;
        }
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            String path = this.fileInfo != null && this.fileInfo.isSymbolicLink() ? this.getFileSystem().getFileSystemManager().resolveName(this.getParent().getName(), this.fileInfo.getLink()).getPath() : this.relPath;
            FTPFile[] tmpChildren = client.listFiles(path);
            if (tmpChildren == null || tmpChildren.length == 0) {
                this.children = EMPTY_FTP_FILE_MAP;
            } else {
                this.children = new TreeMap<String, FTPFile>();
                for (int i = 0; i < tmpChildren.length; ++i) {
                    FTPFile child = tmpChildren[i];
                    if (child == null) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)Messages.getString("vfs.provider.ftp/invalid-directory-entry.debug", i, this.relPath));
                        continue;
                    }
                    if (".".equals(child.getName()) || "..".equals(child.getName())) continue;
                    this.children.put(child.getName(), child);
                }
            }
        }
        finally {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
        }
    }

    @Override
    protected void doAttach() {
    }

    private void getInfo(boolean flush) throws IOException {
        FTPFile newFileInfo;
        FtpFileObject parent = (FtpFileObject)FileObjectUtils.getAbstractFileObject(this.getParent());
        if (parent != null) {
            newFileInfo = parent.getChildFile(UriParser.decode(this.getName().getBaseName()), flush);
        } else {
            newFileInfo = new FTPFile();
            newFileInfo.setType(1);
        }
        this.fileInfo = newFileInfo == null ? UNKNOWN : newFileInfo;
        if (flush) {
            this.mdtm = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws FileSystemException {
        if (!this.inRefresh) {
            try {
                this.inRefresh = true;
                super.refresh();
                FileSystem fileSystem = this.getFileSystem();
                synchronized (fileSystem) {
                    this.fileInfo = null;
                    this.children = null;
                }
            }
            finally {
                this.inRefresh = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDetach() {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            this.fileInfo = null;
            this.children = null;
            this.mdtm = 0L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onChildrenChanged(FileName child, FileType newType) {
        if (this.children != null && newType.equals((Object)FileType.IMAGINARY)) {
            try {
                if (this.children.isEmpty()) return;
                this.children.remove(UriParser.decode(child.getBaseName()));
                return;
            }
            catch (FileSystemException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.children = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onChange() throws IOException {
        this.children = null;
        if (this.getType().equals((Object)FileType.IMAGINARY)) {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                this.fileInfo = UNKNOWN;
            }
            return;
        }
        this.getInfo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileType doGetType() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo == null) {
                this.getInfo(false);
            }
            if (this.fileInfo == UNKNOWN) {
                return FileType.IMAGINARY;
            }
            if (this.fileInfo.isDirectory()) {
                return FileType.FOLDER;
            }
            if (this.fileInfo.isFile()) {
                return FileType.FILE;
            }
            if (this.fileInfo.isSymbolicLink()) {
                FtpFileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return FileType.IMAGINARY;
                }
                return linkDest.getType();
            }
        }
        throw new FileSystemException("vfs.provider.ftp/get-type.error", (Object)this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FtpFileObject getLinkDestination() throws FileSystemException {
        if (this.linkDestination == null) {
            String path;
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                path = this.fileInfo.getLink();
            }
            FileName relativeTo = this.getName().getParent();
            if (relativeTo == null) {
                relativeTo = this.getName();
            }
            FileName linkDestinationName = this.getFileSystem().getFileSystemManager().resolveName(relativeTo, path);
            this.linkDestination = (FtpFileObject)this.getFileSystem().resolveFile(linkDestinationName);
        }
        return this.linkDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileObject[] doListChildrenResolved() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo != null && this.fileInfo.isSymbolicLink()) {
                FtpFileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return null;
                }
                return linkDest.getChildren();
            }
        }
        return null;
    }

    @Override
    public FileObject[] getChildren() throws FileSystemException {
        try {
            if (this.doGetType() != FileType.FOLDER) {
                throw new FileNotFolderException(this.getName());
            }
        }
        catch (Exception ex) {
            throw new FileNotFolderException(this.getName(), (Throwable)ex);
        }
        try {
            this.inRefresh = true;
            FileObject[] fileObjectArray = super.getChildren();
            return fileObjectArray;
        }
        finally {
            this.inRefresh = false;
        }
    }

    @Override
    protected String[] doListChildren() throws Exception {
        this.doGetChildren();
        if (this.children == null) {
            return null;
        }
        String[] childNames = new String[this.children.size()];
        int childNum = -1;
        for (FTPFile child : this.children.values()) {
            childNames[++childNum] = child.getName();
        }
        return UriParser.encode(childNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean ok;
            FtpClient ftpClient = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
            try {
                ok = this.fileInfo.isDirectory() ? ftpClient.removeDirectory(this.relPath) : ftpClient.deleteFile(this.relPath);
            }
            finally {
                ((FtpFileSystem)this.getAbstractFileSystem()).putClient(ftpClient);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/delete-file.error", (Object)this.getName());
            }
            this.fileInfo = null;
            this.children = EMPTY_FTP_FILE_MAP;
            this.mdtm = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRename(FileObject newFile) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            boolean ok;
            FtpClient ftpClient = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
            try {
                ok = ftpClient.rename(this.relPath, ((FtpFileObject)newFile).relPath);
            }
            finally {
                ((FtpFileSystem)this.getAbstractFileSystem()).putClient(ftpClient);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/rename-file.error", this.getName().toString(), newFile);
            }
            this.fileInfo = null;
            this.children = EMPTY_FTP_FILE_MAP;
            this.mdtm = 0L;
        }
    }

    @Override
    protected void doCreateFolder() throws Exception {
        boolean ok;
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            ok = client.makeDirectory(this.relPath);
        }
        finally {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
        }
        if (!ok) {
            throw new FileSystemException("vfs.provider.ftp/create-folder.error", (Object)this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetContentSize() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo.isSymbolicLink()) {
                FtpFileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return this.fileInfo.getSize();
                }
                return linkDest.getContent().getSize();
            }
            return this.fileInfo.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long doGetLastModifiedTime(boolean accurate) throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.fileInfo.isSymbolicLink()) {
                FtpFileObject linkDest = this.getLinkDestination();
                if (this.isCircular(linkDest)) {
                    return this.getTimestamp(accurate);
                }
                return linkDest.getContent().getLastModifiedTime(accurate);
            }
            return this.getTimestamp(accurate);
        }
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            InputStream instr = client.retrieveFileStream(this.relPath);
            if (instr == null) {
                throw new FileNotFoundException(this.getName().toString());
            }
            return new FtpInputStream(client, instr);
        }
        catch (Exception e) {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
            throw e;
        }
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) {
        return new FtpRandomAccessContent(this, mode);
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            OutputStream out = null;
            out = bAppend ? client.appendFileStream(this.relPath) : client.storeFileStream(this.relPath);
            if (out == null) {
                throw new FileSystemException("vfs.provider.ftp/output-error.debug", this.getName(), client.getReplyString());
            }
            return new FtpOutputStream(client, out);
        }
        catch (Exception e) {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
            throw e;
        }
    }

    String getRelPath() {
        return this.relPath;
    }

    private long getTimestamp(boolean accurate) throws FileSystemException {
        if (this.mdtm > 0L) {
            return this.mdtm;
        }
        if (accurate && this.hasMDTM()) {
            return this.mdtm;
        }
        Calendar timestamp = this.fileInfo.getTimestamp();
        return timestamp == null ? 0L : timestamp.getTime().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCircular(FtpFileObject linkDest) throws Exception {
        if (linkDest.getName().getPathDecoded().equals(this.getName().getPathDecoded())) {
            return true;
        }
        int max = 10;
        for (int i = 0; i < max; ++i) {
            FileSystem fileSystem = linkDest.getFileSystem();
            synchronized (fileSystem) {
                if (linkDest.fileInfo == null) {
                    linkDest.getInfo(false);
                }
                if (linkDest.fileInfo == UNKNOWN) {
                    return false;
                }
                if (!linkDest.fileInfo.isSymbolicLink()) {
                    return false;
                }
                linkDest = linkDest.getLinkDestination();
                continue;
            }
        }
        return true;
    }

    FtpInputStream getInputStream(long filePointer) throws IOException {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            InputStream instr = client.retrieveFileStream(this.relPath, filePointer);
            if (instr == null) {
                throw new FileSystemException("vfs.provider.ftp/input-error.debug", this.getName(), client.getReplyString());
            }
            return new FtpInputStream(client, instr);
        }
        catch (IOException e) {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMDTM() throws FileSystemException {
        if (this.mdtm != 0L) {
            return this.mdtm > 0L;
        }
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            this.mdtm = client.mdtm(this.relPath);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.log.debug((Object)("MDTM failed: " + e));
            this.mdtm = -1L;
            boolean bl = false;
            return bl;
        }
        finally {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doSetLastModifiedTime(long modtime) throws FileSystemException {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            client.setLastModifiedTime(this.relPath, modtime);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.log.debug((Object)("MDTM change failed: " + e));
            boolean bl = false;
            return bl;
        }
        finally {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
        }
    }

    @Override
    protected int doGetPermissions() {
        if (this.fileInfo == null) {
            return -1;
        }
        int result = 0;
        if (this.fileInfo.hasPermission(0, 0)) {
            result |= 0x100;
        }
        if (this.fileInfo.hasPermission(0, 1)) {
            result |= 0x80;
        }
        if (this.fileInfo.hasPermission(0, 2)) {
            result |= 0x40;
        }
        if (this.fileInfo.hasPermission(1, 0)) {
            result |= 0x20;
        }
        if (this.fileInfo.hasPermission(1, 1)) {
            result |= 0x10;
        }
        if (this.fileInfo.hasPermission(1, 2)) {
            result |= 8;
        }
        if (this.fileInfo.hasPermission(2, 0)) {
            result |= 4;
        }
        if (this.fileInfo.hasPermission(2, 1)) {
            result |= 2;
        }
        if (this.fileInfo.hasPermission(2, 2)) {
            result |= 1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doSetPermissions(int mask) throws Exception {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            client.chmod(this.relPath, mask);
            if (this.fileInfo != null) {
                this.fileInfo.setPermission(0, 0, FtpFileObject.test(mask, 256));
                this.fileInfo.setPermission(0, 1, FtpFileObject.test(mask, 128));
                this.fileInfo.setPermission(0, 2, FtpFileObject.test(mask, 64));
                this.fileInfo.setPermission(1, 0, FtpFileObject.test(mask, 32));
                this.fileInfo.setPermission(1, 1, FtpFileObject.test(mask, 16));
                this.fileInfo.setPermission(1, 2, FtpFileObject.test(mask, 8));
                this.fileInfo.setPermission(2, 0, FtpFileObject.test(mask, 4));
                this.fileInfo.setPermission(2, 1, FtpFileObject.test(mask, 2));
                this.fileInfo.setPermission(2, 2, FtpFileObject.test(mask, 1));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.log.debug((Object)("CHMOD failed: " + e));
            boolean bl = false;
            return bl;
        }
        finally {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
        }
    }

    private static boolean test(int value, int mask) {
        return (value & mask) == mask;
    }

    @Override
    protected boolean doIsSymbolicLink() {
        return this.fileInfo != null && this.fileInfo.isSymbolicLink();
    }

    @Override
    protected String doGetCurrentDir() throws Exception {
        FtpClient client = ((FtpFileSystem)this.getAbstractFileSystem()).getClient();
        try {
            String string = client.printWorkingDirectory();
            return string;
        }
        finally {
            ((FtpFileSystem)this.getAbstractFileSystem()).putClient(client);
        }
    }

    private class FtpOutputStream
    extends MonitorOutputStream {
        private final FtpClient client;

        public FtpOutputStream(FtpClient client, OutputStream outstr) {
            super(outstr);
            this.client = client;
        }

        @Override
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
            }
            finally {
                ((FtpFileSystem)FtpFileObject.this.getAbstractFileSystem()).putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-put.error", (Object)FtpFileObject.this.getName());
            }
        }
    }

    class FtpInputStream
    extends MonitorInputStream {
        private final FtpClient client;

        public FtpInputStream(FtpClient client, InputStream in) {
            super(in);
            this.client = client;
        }

        void abort() throws IOException {
            this.client.abort();
            this.close();
        }

        @Override
        protected void onClose() throws IOException {
            boolean ok;
            try {
                ok = this.client.completePendingCommand();
            }
            finally {
                ((FtpFileSystem)FtpFileObject.this.getAbstractFileSystem()).putClient(this.client);
            }
            if (!ok) {
                throw new FileSystemException("vfs.provider.ftp/finish-get.error", (Object)FtpFileObject.this.getName());
            }
        }
    }
}

