/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.fragments.loginFragment.src.app_package.ui.login;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"loginFragmentKt", "", "fragmentClass", "layoutName", "packageName", "useAndroidX", "", "studio.intellij.android.wizardTemplate.impl"})
public final class LoginFragmentKtKt {
    @NotNull
    public static final String loginFragmentKt(@NotNull String fragmentClass2, @NotNull String layoutName2, @NotNull String packageName, boolean useAndroidX) {
        Intrinsics.checkParameterIsNotNull((Object)fragmentClass2, (String)"fragmentClass");
        Intrinsics.checkParameterIsNotNull((Object)layoutName2, (String)"layoutName");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier((String)packageName) + ".ui.login\n\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.arch.lifecycle.Observer", (boolean)useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.arch.lifecycle.ViewModelProviders", (boolean)useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.support.annotation.StringRes", (boolean)useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.support.v4.app.Fragment", (boolean)useAndroidX) + "\nimport android.os.Bundle\nimport android.text.Editable\nimport android.text.TextWatcher\nimport android.view.LayoutInflater\nimport android.view.View\nimport android.view.ViewGroup\nimport android.view.inputmethod.EditorInfo\nimport android.widget.Button\nimport android.widget.EditText\nimport android.widget.ProgressBar\nimport android.widget.Toast\n\nimport " + TemplateHelpersKt.escapeKotlinIdentifier((String)packageName) + ".R\n\nclass " + fragmentClass2 + " : Fragment() {\n\n    private lateinit var loginViewModel: LoginViewModel\n\n    override fun onCreateView(\n        inflater: LayoutInflater,\n        container: ViewGroup?,\n        savedInstanceState: Bundle?\n    ): View? {\n        return inflater.inflate(R.layout." + layoutName2 + ", container, false)\n    }\n\n    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {\n        super.onViewCreated(view, savedInstanceState)\n        loginViewModel = ViewModelProviders.of(this, LoginViewModelFactory())\n            .get(LoginViewModel::class.java)\n\n        val usernameEditText = view.findViewById<EditText>(R.id.username)\n        val passwordEditText = view.findViewById<EditText>(R.id.password)\n        val loginButton = view.findViewById<Button>(R.id.login)\n        val loadingProgressBar = view.findViewById<ProgressBar>(R.id.loading)\n\n        loginViewModel.loginFormState.observe(this,\n            Observer { loginFormState ->\n                if (loginFormState == null) {\n                    return@Observer\n                }\n                loginButton.isEnabled = loginFormState.isDataValid\n                loginFormState.usernameError?.let {\n                    usernameEditText.error = getString(it)\n                }\n                loginFormState.passwordError?.let {\n                    passwordEditText.error = getString(it)\n                }\n            })\n\n        loginViewModel.loginResult.observe(this,\n            Observer { loginResult ->\n                loginResult ?: return@Observer\n                loadingProgressBar.visibility = View.GONE\n                loginResult.error?.let {\n                    showLoginFailed(it)\n                }\n                loginResult.success?.let {\n                    updateUiWithUser(it)\n                }\n            })\n\n        val afterTextChangedListener = object : TextWatcher {\n            override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {\n                // ignore\n            }\n\n            override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {\n                // ignore\n            }\n\n            override fun afterTextChanged(s: Editable) {\n                loginViewModel.loginDataChanged(\n                    usernameEditText.text.toString(),\n                    passwordEditText.text.toString()\n                )\n            }\n        }\n        usernameEditText.addTextChangedListener(afterTextChangedListener)\n        passwordEditText.addTextChangedListener(afterTextChangedListener)\n        passwordEditText.setOnEditorActionListener { _, actionId, _ ->\n            if (actionId == EditorInfo.IME_ACTION_DONE) {\n                loginViewModel.login(\n                    usernameEditText.text.toString(),\n                    passwordEditText.text.toString()\n                )\n            }\n            false\n        }\n\n        loginButton.setOnClickListener {\n            loadingProgressBar.visibility = View.VISIBLE\n            loginViewModel.login(\n                usernameEditText.text.toString(),\n                passwordEditText.text.toString()\n            )\n        }\n    }\n\n    private fun updateUiWithUser(model: LoggedInUserView) {\n        val welcome = getString(R.string.welcome) + model.displayName\n        // TODO : initiate successful logged in experience\n        val appContext = context?.applicationContext ?: return\n        Toast.makeText(appContext, welcome, Toast.LENGTH_LONG).show()\n    }\n\n    private fun showLoginFailed(@StringRes errorString: Int) {\n        val appContext = context?.applicationContext ?: return\n        Toast.makeText(appContext, errorString, Toast.LENGTH_LONG).show()\n    }\n}\n";
    }
}

