/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.fragments.loginFragment.src.app_package.ui.login;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"loginFragmentJava", "", "fragmentClass", "layoutName", "packageName", "useAndroidX", "", "studio.intellij.android.wizardTemplate.impl"})
public final class LoginFragmentJavaKt {
    @NotNull
    public static final String loginFragmentJava(@NotNull String fragmentClass2, @NotNull String layoutName2, @NotNull String packageName, boolean useAndroidX) {
        Intrinsics.checkParameterIsNotNull((Object)fragmentClass2, (String)"fragmentClass");
        Intrinsics.checkParameterIsNotNull((Object)layoutName2, (String)"layoutName");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        return "\npackage  " + packageName + ".ui.login;\n\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.arch.lifecycle.Observer", (boolean)useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.arch.lifecycle.ViewModelProviders", (boolean)useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.support.annotation.NonNull", (boolean)useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.support.annotation.Nullable", (boolean)useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.support.annotation.StringRes", (boolean)useAndroidX) + ";\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.support.v4.app.Fragment", (boolean)useAndroidX) + ";\n\nimport android.os.Bundle;\nimport android.text.Editable;\nimport android.text.TextWatcher;\nimport android.view.KeyEvent;\nimport android.view.LayoutInflater;\nimport android.view.View;\nimport android.view.ViewGroup;\nimport android.view.inputmethod.EditorInfo;\nimport android.widget.Button;\nimport android.widget.EditText;\nimport android.widget.ProgressBar;\nimport android.widget.TextView;\nimport android.widget.Toast;\n\nimport " + packageName + ".R;\n\npublic class " + fragmentClass2 + " extends Fragment {\n\n    private LoginViewModel loginViewModel;\n\n    @Nullable\n    @Override\n    public View onCreateView(@NonNull LayoutInflater inflater,\n                             @Nullable ViewGroup container,\n                             @Nullable Bundle savedInstanceState) {\n        return inflater.inflate(R.layout." + layoutName2 + ", container,false);\n    }\n\n    @Override\n    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {\n        super.onViewCreated(view, savedInstanceState);\n        loginViewModel = ViewModelProviders.of(this, new LoginViewModelFactory())\n                .get(LoginViewModel.class);\n\n        final EditText usernameEditText = view.findViewById(R.id.username);\n        final EditText passwordEditText = view.findViewById(R.id.password);\n        final Button loginButton = view.findViewById(R.id.login);\n        final ProgressBar loadingProgressBar = view.findViewById(R.id.loading);\n\n        loginViewModel.getLoginFormState().observe(this, new Observer<LoginFormState>() {\n            @Override\n            public void onChanged(@Nullable LoginFormState loginFormState) {\n                if (loginFormState == null) {\n                    return;\n                }\n                loginButton.setEnabled(loginFormState.isDataValid());\n                if (loginFormState.getUsernameError() != null) {\n                    usernameEditText.setError(getString(loginFormState.getUsernameError()));\n                }\n                if (loginFormState.getPasswordError() != null) {\n                    passwordEditText.setError(getString(loginFormState.getPasswordError()));\n                }\n            }\n        });\n\n        loginViewModel.getLoginResult().observe(this, new Observer<LoginResult>() {\n            @Override\n            public void onChanged(@Nullable LoginResult loginResult) {\n                if (loginResult == null) {\n                    return;\n                }\n                loadingProgressBar.setVisibility(View.GONE);\n                if (loginResult.getError() != null) {\n                    showLoginFailed(loginResult.getError());\n                }\n                if (loginResult.getSuccess() != null) {\n                    updateUiWithUser(loginResult.getSuccess());\n                }\n            }\n        });\n\n        TextWatcher afterTextChangedListener = new TextWatcher() {\n            @Override\n            public void beforeTextChanged(CharSequence s, int start, int count, int after) {\n                // ignore\n            }\n\n            @Override\n            public void onTextChanged(CharSequence s, int start, int before, int count) {\n                // ignore\n            }\n\n            @Override\n            public void afterTextChanged(Editable s) {\n                loginViewModel.loginDataChanged(usernameEditText.getText().toString(),\n                        passwordEditText.getText().toString());\n            }\n        };\n        usernameEditText.addTextChangedListener(afterTextChangedListener);\n        passwordEditText.addTextChangedListener(afterTextChangedListener);\n        passwordEditText.setOnEditorActionListener(new TextView.OnEditorActionListener() {\n\n            @Override\n            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {\n                if (actionId == EditorInfo.IME_ACTION_DONE) {\n                    loginViewModel.login(usernameEditText.getText().toString(),\n                            passwordEditText.getText().toString());\n                }\n                return false;\n            }\n        });\n\n        loginButton.setOnClickListener(new View.OnClickListener() {\n            @Override\n            public void onClick(View v) {\n                loadingProgressBar.setVisibility(View.VISIBLE);\n                loginViewModel.login(usernameEditText.getText().toString(),\n                        passwordEditText.getText().toString());\n            }\n        });\n    }\n\n    private void updateUiWithUser(LoggedInUserView model) {\n        String welcome = getString(R.string.welcome) + model.getDisplayName();\n        // TODO : initiate successful logged in experience\n        if (getContext() != null && getContext().getApplicationContext() != null) {\n            Toast.makeText(getContext().getApplicationContext(), welcome, Toast.LENGTH_LONG).show();\n        }\n    }\n\n    private void showLoginFailed(@StringRes Integer errorString) {\n        if (getContext() != null && getContext().getApplicationContext() != null) {\n            Toast.makeText(\n                    getContext().getApplicationContext(),\n                    errorString,\n                    Toast.LENGTH_LONG).show();\n        }\n    }\n}\n";
    }
}

