/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringInitializrRunConfigUtil {
    private static final Logger LOG = Logger.getInstance(SpringInitializrRunConfigUtil.class);

    SpringInitializrRunConfigUtil() {
    }

    static void createRunConfiguration(@NotNull Executor executorService, @NotNull Module module, @NotNull Disposable executorDisposable) {
        if (executorService == null) {
            SpringInitializrRunConfigUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringInitializrRunConfigUtil.$$$reportNull$$$0(1);
        }
        if (executorDisposable == null) {
            SpringInitializrRunConfigUtil.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            SpringInitializrRunConfigUtil.createSpringBootRunConfiguration(SpringBootApplicationConfigurationTypeBase.getInstance(), module);
            return;
        }
        ReadAction.nonBlocking(() -> SpringInitializrRunConfigUtil.createSpringBootRunConfiguration(SpringBootApplicationConfigurationTypeBase.getInstance(), module)).inSmartMode(module.getProject()).expireWith(executorDisposable).expireWith((Disposable)module).coalesceBy(new Object[]{SpringInitializrRunConfigUtil.class, module}).submit(executorService);
    }

    private static void createSpringBootRunConfiguration(@NotNull SpringBootApplicationConfigurationTypeBase springBootType, @NotNull Module module) {
        List applications;
        if (springBootType == null) {
            SpringInitializrRunConfigUtil.$$$reportNull$$$0(3);
        }
        if (module == null) {
            SpringInitializrRunConfigUtil.$$$reportNull$$$0(4);
        }
        if ((applications = SpringBootApplicationService.getInstance().getSpringApplications(module)).size() != 1) {
            return;
        }
        PsiClass springBootApp = (PsiClass)applications.get(0);
        if (!SpringBootApplicationService.getInstance().hasMainMethod(springBootApp) || springBootApp == null || SpringInitializrRunConfigUtil.hasSpringBootRunConfiguration((JvmClass)springBootApp, (ConfigurationType)springBootType, module)) {
            return;
        }
        SpringInitializrRunConfigUtil.createSpringBootRunConfiguration(springBootApp.getQualifiedName(), springBootType, module);
    }

    private static void createSpringBootRunConfiguration(@Nullable String springBootApp, @NotNull SpringBootApplicationConfigurationTypeBase springBootType, @NotNull Module module) {
        if (springBootType == null) {
            SpringInitializrRunConfigUtil.$$$reportNull$$$0(5);
        }
        if (module == null) {
            SpringInitializrRunConfigUtil.$$$reportNull$$$0(6);
        }
        if (springBootApp == null) {
            return;
        }
        try {
            RunManager runManager = RunManager.getInstance((Project)module.getProject());
            RunnerAndConfigurationSettings settings = runManager.createConfiguration("", springBootType.getDefaultConfigurationFactory());
            SpringBootApplicationRunConfigurationBase newRunConfig = (SpringBootApplicationRunConfigurationBase)settings.getConfiguration();
            newRunConfig.setModule(module);
            newRunConfig.setSpringBootMainClass(springBootApp);
            settings.setName(newRunConfig.suggestedName());
            runManager.setUniqueNameIfNeeded(settings);
            runManager.addConfiguration(settings);
            if (runManager.getAllSettings().size() == 1) {
                runManager.setSelectedConfiguration(settings);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.error("Error creating Spring Boot run configuration for " + springBootApp, t);
        }
    }

    private static boolean hasSpringBootRunConfiguration(@NotNull JvmClass applicationClass, @NotNull ConfigurationType springBootType, @NotNull Module module) {
        if (applicationClass == null) {
            SpringInitializrRunConfigUtil.$$$reportNull$$$0(7);
        }
        if (springBootType == null) {
            SpringInitializrRunConfigUtil.$$$reportNull$$$0(8);
        }
        if (module == null) {
            SpringInitializrRunConfigUtil.$$$reportNull$$$0(9);
        }
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        for (RunConfiguration config : runManager.getConfigurationsList(springBootType)) {
            Module configModule;
            SpringBootApplicationRunConfigurationBase sbConfig;
            if (!(config instanceof SpringBootApplicationRunConfigurationBase) || !(sbConfig = (SpringBootApplicationRunConfigurationBase)config).getSpringBootMainClass().equals(applicationClass.getQualifiedName()) || (configModule = sbConfig.getModule()) == null) continue;
            if (configModule.equals(module)) {
                return true;
            }
            HashSet dependentModules = new HashSet();
            ModuleUtilCore.collectModulesDependsOn((Module)module, dependentModules);
            if (!dependentModules.contains(configModule)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorService";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorDisposable";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBootType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/initializr/SpringInitializrRunConfigUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createRunConfiguration";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createSpringBootRunConfiguration";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSpringBootRunConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

