/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.WebStarterProjectDownloader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.initializr.SpringInitializrModuleBuilder;
import com.intellij.spring.boot.initializr.SpringInitializrOptions;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;

class SpringInitializrProjectDownloader
extends WebStarterProjectDownloader<SpringInitializrOptions> {
    SpringInitializrProjectDownloader(SpringInitializrModuleBuilder builder) {
        super((WebStarterModuleBuilder)builder);
    }

    protected void unzip(File tempZipFile, File contentEntryDir) throws IOException {
        ZipUtil.extract((File)tempZipFile, (File)contentEntryDir, null);
    }

    protected Url buildUrl() {
        SpringInitializrOptions options = (SpringInitializrOptions)this.myBuilder.getOptions();
        WebStarterOptions.Option selectedType = (WebStarterOptions.Option)options.type.getSelected();
        assert (selectedType != null);
        String action = options.typeToAction.get(selectedType.id);
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("type", SpringInitializrProjectDownloader.getParameter(options.type));
        parameters.put("packaging", SpringInitializrProjectDownloader.getParameter(options.packaging));
        parameters.put("javaVersion", SpringInitializrProjectDownloader.getParameter(options.javaVersion));
        parameters.put("language", SpringInitializrProjectDownloader.getParameter(options.language));
        parameters.put("bootVersion", SpringInitializrProjectDownloader.getParameter(options.bootVersionModel));
        parameters.put("groupId", options.group);
        parameters.put("artifactId", options.artifact);
        parameters.put("name", options.name);
        parameters.put("version", options.version);
        parameters.put("description", options.description);
        parameters.put("packageName", options.packageName);
        String serviceUrl = StringUtil.trimTrailing((String)this.myBuilder.getServiceUrl(), (char)'/');
        Url url = Urls.newFromEncoded((String)(serviceUrl + action)).addParameters(parameters);
        for (String id : options.selectedDependenciesIds) {
            url = url.addParameters(Collections.singletonMap("dependencies", id));
        }
        return url;
    }
}

