/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.dependencies.LinkData;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoader;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoaderIteration;
import com.intellij.frameworks.starters.web.utils.OneActionListDataListener;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.initializr.SpringInitializrOptions;
import com.intellij.spring.boot.initializr.Version;
import com.intellij.spring.boot.initializr.VersionRange;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringInitializrOptionsLoader
extends WebStarterOptionsLoader<SpringInitializrOptions> {
    static final String MIME_TYPE = "application/vnd.initializr.v2.2+json,application/vnd.initializr.v2.1+json;q=0.9";
    private static final String DEFAULT_PROPERTY = "default";
    private static final String VALUES_PROPERTY = "values";
    private static final String ID_PROPERTY = "id";
    private static final String NAME_PROPERTY = "name";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String VERSION_RANGE_PROPERTY = "versionRange";
    private static final String LINKS_PROPERTY = "_links";
    private static final String HREF_PROPERTY = "href";
    private static final String TITLE_PROPERTY = "title";
    private static final Consumer<Pair<JsonObject, WebStarterOptions.Option>> DEPENDENCIES_CALLBACK = pair -> {
        JsonObject jsonObject = (JsonObject)pair.first;
        if (jsonObject.has(VERSION_RANGE_PROPERTY)) {
            String versionRangeText = jsonObject.get(VERSION_RANGE_PROPERTY).getAsString();
            ((WebStarterOptions.Option)pair.second).putUserData(SpringInitializrOptions.VERSION_RANGE, (Object)VersionRange.parse(versionRangeText));
        }
        if (jsonObject.has(LINKS_PROPERTY)) {
            JsonObject linksObject = jsonObject.getAsJsonObject(LINKS_PROPERTY);
            ArrayList<LinkData> dependencyLinks = new ArrayList<LinkData>();
            for (Map.Entry entry : linksObject.entrySet()) {
                String linkTypeAsText = (String)entry.getKey();
                LinkData.LinkType linkType = SpringInitializrOptionsLoader.parseLinkType(linkTypeAsText);
                JsonElement linkObject = (JsonElement)entry.getValue();
                if (linkObject.isJsonArray()) {
                    for (JsonElement linkEntry : linkObject.getAsJsonArray()) {
                        SpringInitializrOptionsLoader.parseLinkAndAdd(linkEntry, linkType, dependencyLinks);
                    }
                    continue;
                }
                SpringInitializrOptionsLoader.parseLinkAndAdd(linkObject, linkType, dependencyLinks);
            }
            ((WebStarterOptions.Option)pair.second).putUserData(SpringInitializrOptions.LINKS, dependencyLinks);
        }
    };
    public static final String ONLY_PROJECT_TYPE_PATTERN = "\\w+-project";

    SpringInitializrOptionsLoader() {
    }

    private static LinkData.LinkType parseLinkType(String linkTypeAsText) {
        if ("guide".equalsIgnoreCase(linkTypeAsText)) {
            return LinkData.LinkType.GUIDE;
        }
        if ("reference".equalsIgnoreCase(linkTypeAsText)) {
            return LinkData.LinkType.REFERENCE;
        }
        return LinkData.LinkType.OTHER;
    }

    private static void parseLinkAndAdd(JsonElement linkEntry, LinkData.LinkType linkType, List<LinkData> links) {
        if (!linkEntry.isJsonObject()) {
            return;
        }
        JsonObject entryObject = linkEntry.getAsJsonObject();
        String urlTemplate = entryObject.getAsJsonPrimitive(HREF_PROPERTY).getAsString();
        JsonPrimitive titleProperty = entryObject.getAsJsonPrimitive(TITLE_PROPERTY);
        String title = titleProperty == null ? null : titleProperty.getAsString();
        links.add(new LinkData(urlTemplate, linkType, title));
    }

    protected SpringInitializrOptions createEmptyOptionsContainer() {
        return new SpringInitializrOptions();
    }

    @NotNull
    protected WebStarterOptionsLoaderIteration<SpringInitializrOptions> getFirstIteration() {
        return new WebStarterOptionsLoaderIteration<SpringInitializrOptions>(){

            protected RequestBuilder getPreparedRequestBuilder(String serviceUrl) {
                return HttpRequests.request((String)serviceUrl).accept(SpringInitializrOptionsLoader.MIME_TYPE);
            }

            public void parseJsonResponse(JsonElement jsonRootElement, @NotNull SpringInitializrOptions options) {
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                JsonObject rootObject = jsonRootElement.getAsJsonObject();
                SpringInitializrOptionsLoader.parseJson(rootObject, options);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/spring/boot/initializr/SpringInitializrOptionsLoader$1", "parseJsonResponse"));
            }
        };
    }

    static void parseJson(JsonObject rootObject, @NotNull SpringInitializrOptions options) {
        if (options == null) {
            SpringInitializrOptionsLoader.$$$reportNull$$$0(0);
        }
        options.name = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, NAME_PROPERTY);
        options.group = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, "groupId");
        options.artifact = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, "artifactId");
        options.version = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, "version");
        options.description = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, DESCRIPTION_PROPERTY);
        options.packageName = SpringInitializrOptionsLoader.getDefaultPropertyValue(rootObject, "packageName");
        options.type = SpringInitializrOptionsLoader.createComboModel(rootObject, "type", new MyTypeListFilter());
        options.canShowTypeChoiceAsRadioButton = SpringInitializrOptionsLoader.containsOnlyProjectTypes(options.type.getItems());
        options.packaging = SpringInitializrOptionsLoader.createComboModel(rootObject, "packaging");
        options.javaVersion = SpringInitializrOptionsLoader.createComboModel(rootObject, "javaVersion");
        options.language = SpringInitializrOptionsLoader.createComboModel(rootObject, "language");
        options.bootVersionModel = SpringInitializrOptionsLoader.createComboModel(rootObject, "bootVersion");
        options.bootVersion = SpringInitializrOptionsLoader.calculateBootVersion(options);
        options.bootVersionModel.addListDataListener((ListDataListener)new OneActionListDataListener(() -> {
            options.bootVersion = SpringInitializrOptionsLoader.calculateBootVersion(options);
        }));
        options.dependencies = SpringInitializrOptionsLoader.parseDependencies(rootObject);
        options.typeToAction = SpringInitializrOptionsLoader.fillTypeToAction(rootObject);
    }

    @Nullable
    private static Version calculateBootVersion(SpringInitializrOptions options) {
        WebStarterOptions.Option selectedOption = (WebStarterOptions.Option)options.bootVersionModel.getSelected();
        if (selectedOption != null) {
            return Version.parse(selectedOption.id);
        }
        return null;
    }

    private static Map<String, String> fillTypeToAction(JsonObject rootObject) {
        HashMap<String, String> typeToAction = new HashMap<String, String>();
        JsonObject typeObject = rootObject.get("type").getAsJsonObject();
        JsonArray values = typeObject.get(VALUES_PROPERTY).getAsJsonArray();
        for (JsonElement value : values) {
            String id = value.getAsJsonObject().get(ID_PROPERTY).getAsString();
            String action = value.getAsJsonObject().get("action").getAsString();
            typeToAction.put(id, action);
        }
        return typeToAction;
    }

    private static List<WebStarterOptions.MultiSelectGroup> parseDependencies(JsonObject rootObject) {
        JsonArray dependencies = rootObject.get("dependencies").getAsJsonObject().get(VALUES_PROPERTY).getAsJsonArray();
        ArrayList<WebStarterOptions.MultiSelectGroup> groups = new ArrayList<WebStarterOptions.MultiSelectGroup>();
        for (JsonElement dependency : dependencies) {
            JsonObject depObject = dependency.getAsJsonObject();
            @NlsSafe String groupName = depObject.get(NAME_PROPERTY).getAsString();
            List<WebStarterOptions.Option> options = SpringInitializrOptionsLoader.createOptions(depObject, DEPENDENCIES_CALLBACK);
            WebStarterOptions.MultiSelectGroup group = new WebStarterOptions.MultiSelectGroup(groupName, options);
            groups.add(group);
        }
        return groups;
    }

    private static String getDefaultPropertyValue(JsonObject object, String propertyName) {
        JsonElement property = object.get(propertyName);
        if (property == null) {
            return "";
        }
        JsonElement defaultProperty = property.getAsJsonObject().get(DEFAULT_PROPERTY);
        return defaultProperty == null ? "" : defaultProperty.getAsString();
    }

    private static CollectionComboBoxModel<WebStarterOptions.Option> createComboModel(JsonObject rootObject, String propertyName) {
        return SpringInitializrOptionsLoader.createComboModel(rootObject, propertyName, null);
    }

    private static CollectionComboBoxModel<WebStarterOptions.Option> createComboModel(JsonObject rootObject, String propertyName, @Nullable Function<List<WebStarterOptions.Option>, List<WebStarterOptions.Option>> filter) {
        JsonElement defaultPropertyElement;
        JsonObject property = rootObject.get(propertyName).getAsJsonObject();
        List<WebStarterOptions.Option> options = SpringInitializrOptionsLoader.createOptions(property, (Consumer<Pair<JsonObject, WebStarterOptions.Option>>)EmptyConsumer.getInstance());
        if (filter != null) {
            options = filter.apply(options);
        }
        String defaultId = (defaultPropertyElement = property.get(DEFAULT_PROPERTY)) != null ? defaultPropertyElement.getAsString() : "";
        return new CollectionComboBoxModel(options, (Object)((WebStarterOptions.Option)ContainerUtil.find(options, option -> Comparing.strEqual((String)option.id, (String)defaultId))));
    }

    @NotNull
    private static List<WebStarterOptions.Option> createOptions(JsonObject depObject, Consumer<Pair<JsonObject, WebStarterOptions.Option>> callback) {
        ArrayList<WebStarterOptions.Option> options = new ArrayList<WebStarterOptions.Option>();
        JsonArray values = depObject.get(VALUES_PROPERTY).getAsJsonArray();
        for (JsonElement value : values) {
            JsonObject valueObject = value.getAsJsonObject();
            String id = valueObject.get(ID_PROPERTY).getAsString();
            if (StringUtil.isEmptyOrSpaces((String)id)) continue;
            String name = valueObject.get(NAME_PROPERTY).getAsString();
            @NlsSafe String description = valueObject.has(DESCRIPTION_PROPERTY) ? valueObject.get(DESCRIPTION_PROPERTY).getAsString() : "";
            WebStarterOptions.Option option = new WebStarterOptions.Option(id, (String)(StringUtil.isNotEmpty((String)name) ? name : "<" + id + ">"), description);
            callback.consume((Object)Pair.create((Object)valueObject, (Object)option));
            options.add(option);
        }
        ArrayList<WebStarterOptions.Option> arrayList = options;
        if (arrayList == null) {
            SpringInitializrOptionsLoader.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static boolean containsOnlyProjectAndBuildTypes(List<WebStarterOptions.Option> typeList) {
        Pattern pattern = Pattern.compile("\\w+-(project|build)");
        for (WebStarterOptions.Option type : typeList) {
            if (pattern.matcher(type.id).matches()) continue;
            return false;
        }
        return true;
    }

    private static boolean containsOnlyProjectTypes(List<WebStarterOptions.Option> typeList) {
        Pattern pattern = Pattern.compile(ONLY_PROJECT_TYPE_PATTERN);
        for (WebStarterOptions.Option type : typeList) {
            if (pattern.matcher(type.id).matches()) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/initializr/SpringInitializrOptionsLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/initializr/SpringInitializrOptionsLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseJson";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyTypeListFilter
    implements Function<List<WebStarterOptions.Option>, List<WebStarterOptions.Option>> {
        private MyTypeListFilter() {
        }

        @Override
        public List<WebStarterOptions.Option> apply(List<WebStarterOptions.Option> typeList) {
            if (!SpringInitializrOptionsLoader.containsOnlyProjectAndBuildTypes(typeList)) {
                return typeList;
            }
            Pattern onlyProjectPattern = Pattern.compile(SpringInitializrOptionsLoader.ONLY_PROJECT_TYPE_PATTERN);
            Pattern projectWordToCutOffPattern = Pattern.compile(" project$", 2);
            ArrayList<WebStarterOptions.Option> onlyProjectTypeList = new ArrayList<WebStarterOptions.Option>();
            for (WebStarterOptions.Option type : typeList) {
                String newName;
                if (!onlyProjectPattern.matcher(type.id).matches()) continue;
                Matcher projectWordToCutOffMatcher = projectWordToCutOffPattern.matcher(type.display);
                if (projectWordToCutOffMatcher.find() && !StringUtil.isEmptyOrSpaces((String)(newName = type.display.substring(0, projectWordToCutOffMatcher.start())))) {
                    type.display = newName;
                }
                onlyProjectTypeList.add(type);
            }
            return onlyProjectTypeList.size() >= 2 ? onlyProjectTypeList : typeList;
        }
    }
}

