/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.intellij.frameworks.starters.web.WebStarterApplicationInfoStep;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.WebStarterProjectDownloader;
import com.intellij.frameworks.starters.web.dependencies.WebStarterDependenciesStepPanel;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoader;
import com.intellij.frameworks.starters.web.utils.DependencyAvailabilityVerificationResult;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.initializr.SpringInitializrApplicationInfoStep;
import com.intellij.spring.boot.initializr.SpringInitializrOptions;
import com.intellij.spring.boot.initializr.SpringInitializrOptionsLoader;
import com.intellij.spring.boot.initializr.SpringInitializrProjectDownloader;
import com.intellij.spring.boot.initializr.Version;
import com.intellij.spring.boot.initializr.VersionRange;
import com.intellij.spring.boot.initializr.dependencies.ChangeSpringBootVersionAction;
import com.intellij.spring.boot.options.SpringBootSettings;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootApiIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class SpringInitializrModuleBuilder
extends WebStarterModuleBuilder<SpringInitializrOptions> {
    private static final Map<String, Set<String>> pluginIdToDependencies = ContainerUtil.immutableMapBuilder().put((Object)"com.intellij.aop", (Object)ContainerUtil.immutableSet((Object[])new String[]{"aop"})).put((Object)"com.intellij.spring.security", (Object)ContainerUtil.immutableSet((Object[])new String[]{"security"})).put((Object)"com.intellij.spring.mvc", (Object)ContainerUtil.immutableSet((Object[])new String[]{"web", "webflux", "data-rest"})).put((Object)"com.intellij.spring.batch", (Object)ContainerUtil.immutableSet((Object[])new String[]{"batch"})).put((Object)"com.intellij.spring.data", (Object)ContainerUtil.immutableSet((Object[])new String[]{"data-jpa"})).put((Object)"com.intellij.spring.integration", (Object)ContainerUtil.immutableSet((Object[])new String[]{"integration", "cloud-stream"})).put((Object)"com.intellij.spring.websocket", (Object)ContainerUtil.immutableSet((Object[])new String[]{"websocket"})).put((Object)"com.intellij.spring.messaging", (Object)ContainerUtil.immutableSet((Object[])new String[]{"activemq", "artemis", "amqp", "kafka", "kafka-streams"})).put((Object)"com.intellij.thymeleaf", (Object)ContainerUtil.immutableSet((Object[])new String[]{"thymeleaf"})).put((Object)"com.intellij.velocity", (Object)ContainerUtil.immutableSet((Object[])new String[]{"velocity"})).put((Object)"com.intellij.freemarker", (Object)ContainerUtil.immutableSet((Object[])new String[]{"freemarker"})).put((Object)"org.intellij.groovy", (Object)ContainerUtil.immutableSet((Object[])new String[]{"groovy-templates"})).put((Object)"com.dmarcotte.handlebars", (Object)ContainerUtil.immutableSet((Object[])new String[]{"mustache"})).put((Object)"Lombook Plugin", (Object)ContainerUtil.immutableSet((Object[])new String[]{"lombok"})).put((Object)"com.alexanderpa.flyway.migration.creator", (Object)ContainerUtil.immutableSet((Object[])new String[]{"flyway"})).put((Object)"org.apache.camel", (Object)ContainerUtil.immutableSet((Object[])new String[]{"camel"})).put((Object)"jms-messenger", (Object)ContainerUtil.immutableSet((Object[])new String[]{"activemq", "artemis", "hornetq", "kafka", "kafka-streams"})).put((Object)"com.neueda4j.intellij.plugin.cypher", (Object)ContainerUtil.immutableSet((Object[])new String[]{"data-neo4j"})).put((Object)"com.google.gct.core", (Object)ContainerUtil.immutableSet((Object[])new String[]{"cloud-gcp", "cloud-gcp-pubsub", "cloud-gcp-storage"})).build();

    SpringInitializrModuleBuilder() {
    }

    protected WebStarterApplicationInfoStep<SpringInitializrOptions> createApplicationInfoStep(WizardContext context) {
        return new SpringInitializrApplicationInfoStep(this, context);
    }

    @NotNull
    public DependencyAvailabilityVerificationResult isDependencyAvailable(WebStarterOptions.Option dependency, boolean needExplanation) {
        VersionRange versionRange = (VersionRange)dependency.getUserData(SpringInitializrOptions.VERSION_RANGE);
        boolean available = versionRange == null || versionRange.match(((SpringInitializrOptions)this.getOptions()).bootVersion);
        String explanation = null;
        if (!available && needExplanation) {
            explanation = SpringBootApiBundle.message((String)"message.requires.specific.spring.boot.version", (Object[])new Object[]{versionRange.displayText()});
        }
        return new DependencyAvailabilityVerificationResult(available, explanation);
    }

    public AnAction createCustomDependenciesStepToolbarAction(WebStarterDependenciesStepPanel dependenciesStepPanel) {
        return new ChangeSpringBootVersionAction(this, dependenciesStepPanel);
    }

    public String parseLinkTemplate(String linkTemplate) {
        WebStarterOptions.Option selectedBootVersion = (WebStarterOptions.Option)((SpringInitializrOptions)this.getOptions()).bootVersionModel.getSelected();
        if (selectedBootVersion != null) {
            return StringUtil.replace((String)linkTemplate, (String)"{bootVersion}", (String)Version.parse(selectedBootVersion.id).displayText());
        }
        return linkTemplate;
    }

    public String getDependenciesValidWord(boolean isPlural, boolean isCapitalLetter) {
        if (isPlural) {
            if (isCapitalLetter) {
                return SpringBootApiBundle.message((String)"word.dependency.plural.capitalized", (Object[])new Object[0]);
            }
            return SpringBootApiBundle.message((String)"word.dependency.plural", (Object[])new Object[0]);
        }
        if (isCapitalLetter) {
            return SpringBootApiBundle.message((String)"word.dependency.capitalized", (Object[])new Object[0]);
        }
        return SpringBootApiBundle.message((String)"word.dependency", (Object[])new Object[0]);
    }

    public String getDefaultServiceUrl() {
        return "https://start.spring.io";
    }

    @NotNull
    @NonNls
    public String getBuilderId() {
        return "SpringInitializr";
    }

    public String getDescription() {
        return SpringBootApiBundle.message((String)"description.for.spring.initializr.project.starter", (Object[])new Object[0]);
    }

    public String getPresentableName() {
        return SpringBootApiBundle.message((String)"presentable.name.spring.initializr", (Object[])new Object[0]);
    }

    public Icon getNodeIcon() {
        return SpringBootApiIcons.SpringBoot;
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) {
        LanguageLevelModuleExtension moduleExt;
        Sdk sdk;
        if (modifiableRootModel == null) {
            SpringInitializrModuleBuilder.$$$reportNull$$$0(0);
        }
        Sdk sdk2 = sdk = this.getModuleJdk() != null ? this.getModuleJdk() : ProjectRootManager.getInstance((Project)modifiableRootModel.getProject()).getProjectSdk();
        if (sdk != null) {
            modifiableRootModel.setSdk(sdk);
        }
        if ((moduleExt = (LanguageLevelModuleExtension)modifiableRootModel.getModuleExtension(LanguageLevelModuleExtension.class)) != null && sdk != null) {
            WebStarterOptions.Option selected = (WebStarterOptions.Option)((SpringInitializrOptions)this.getOptions()).javaVersion.getSelected();
            assert (selected != null);
            JavaSdkVersion selectedVersion = JavaSdkVersion.fromVersionString((String)selected.id);
            JavaSdkVersion sdkVersion = JavaSdk.getInstance().getVersion(sdk);
            if (selectedVersion != null && sdkVersion != null && sdkVersion.isAtLeast(selectedVersion)) {
                moduleExt.setLanguageLevel(selectedVersion.getMaxLanguageLevel());
            }
        }
        this.doAddContentEntry(modifiableRootModel);
    }

    protected boolean isReformatAfterCreation(Project project) {
        return SpringBootSettings.getInstance((Project)project).isReformatAfterCreation();
    }

    protected WebStarterOptionsLoader<SpringInitializrOptions> createOptionsDownloader() {
        return new SpringInitializrOptionsLoader();
    }

    protected WebStarterProjectDownloader<SpringInitializrOptions> createProjectDownloader() {
        return new SpringInitializrProjectDownloader(this);
    }

    protected void verifyIdePlugins(Project project) {
        Set<String> selectedDependenciesIds = ((SpringInitializrOptions)this.getOptions()).selectedDependenciesIds;
        HashSet requiredPluginIds = new HashSet();
        pluginIdToDependencies.forEach((key, value) -> {
            if (ContainerUtil.intersects((Collection)value, (Collection)selectedDependenciesIds)) {
                requiredPluginIds.add(PluginId.getId((String)key));
            }
        });
        final HashSet<PluginId> toInstallOrEnable = new HashSet<PluginId>();
        for (PluginId pluginId : requiredPluginIds) {
            IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
            if (ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled()) continue;
            toInstallOrEnable.add(pluginId);
        }
        if (toInstallOrEnable.isEmpty()) {
            return;
        }
        PluginsAdvertiser.NOTIFICATION_GROUP.createNotification(IdeBundle.message((String)"plugins.advertiser.plugins.suggestions.title", (Object[])new Object[0]), IdeBundle.message((String)"plugins.advertiser.plugins.suggestions.text", (Object[])new Object[0]), NotificationType.INFORMATION, null).addAction((AnAction)new NotificationAction(IdeBundle.message((String)"plugins.advertiser.action.enable.plugins", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                PluginsAdvertiser.installAndEnable((Set)toInstallOrEnable, () -> ((Notification)notification).expire());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/boot/initializr/SpringInitializrModuleBuilder$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    public String getHelpId() {
        return "reference.spring.boot";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableRootModel", "com/intellij/spring/boot/initializr/SpringInitializrModuleBuilder", "setupRootModel"));
    }
}

