/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.intellij.frameworks.starters.shared.StartersValidationUtils;
import com.intellij.frameworks.starters.web.WebStarterApplicationInfoStep;
import com.intellij.frameworks.starters.web.WebStarterFormBuilder;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.initializr.SpringInitializrModuleBuilder;
import com.intellij.spring.boot.initializr.SpringInitializrOptions;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class SpringInitializrApplicationInfoStep
extends WebStarterApplicationInfoStep<SpringInitializrOptions> {
    private JBTextField myGroupField;
    private JBTextField myArtifactField;
    private JBTextField myVersionField;
    private JBTextField myNameField;
    private JBTextField myDescriptionField;
    private JBTextField myPackageNameField;

    SpringInitializrApplicationInfoStep(SpringInitializrModuleBuilder builder, WizardContext wizardContext) {
        super((WebStarterModuleBuilder)builder, wizardContext);
    }

    public boolean validate() throws ConfigurationException {
        JavaSdkVersion wizardVersion;
        if (!super.validate()) {
            return false;
        }
        Sdk sdk = this.myWizardContext.isCreatingNewProject() ? this.myWizardContext.getProjectJdk() : (Sdk)ObjectUtils.chooseNotNull((Object)this.myBuilder.getModuleJdk(), (Object)this.myWizardContext.getProjectJdk());
        JavaSdkVersion javaSdkVersion = wizardVersion = sdk == null ? null : JavaSdk.getInstance().getVersion(sdk);
        if (wizardVersion != null) {
            WebStarterOptions.Option appVersion = (WebStarterOptions.Option)((SpringInitializrOptions)this.myBuilder.getOptions()).javaVersion.getSelected();
            assert (appVersion != null);
            JavaSdkVersion selectedVersion = JavaSdkVersion.fromVersionString((String)appVersion.id);
            if (selectedVersion != null && !wizardVersion.isAtLeast(selectedVersion)) {
                throw new ConfigurationException(SpringBootApiBundle.message((String)"message.java.version.not.supported.by.sdk", (Object[])new Object[]{selectedVersion.getDescription(), wizardVersion.getDescription()}));
            }
        }
        return true;
    }

    @Nls
    private String validateSanitizedField() {
        String fieldText = this.myArtifactField.getText();
        if (!fieldText.equals(SpringInitializrApplicationInfoStep.sanitize(fieldText))) {
            return SpringBootApiBundle.message((String)"message.artifact.contains.illegal.characters", (Object[])new Object[0]);
        }
        return null;
    }

    private static String sanitize(String input) {
        String fileName = FileUtil.sanitizeFileName((String)input, (boolean)false);
        return StringUtil.toLowerCase((String)fileName.replace(' ', '-'));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGroupField;
    }

    protected void fillAppSettingsPanel(WebStarterFormBuilder formBuilder, SpringInitializrOptions options) {
        ArrayList<JPanel> panelsWithRadioButtons = new ArrayList<JPanel>();
        this.myGroupField = formBuilder.addTextField(SpringBootApiBundle.message((String)"title.label.mnemonic.group", (Object[])new Object[0]), options.group);
        DocumentAdapter updatePackageNameAdapter = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String packageName = StringUtil.toLowerCase((String)SpringInitializrApplicationInfoStep.this.myGroupField.getText()) + "." + SpringInitializrApplicationInfoStep.sanitize(StringUtil.toLowerCase((String)SpringInitializrApplicationInfoStep.this.myArtifactField.getText()));
                SpringInitializrApplicationInfoStep.this.myPackageNameField.setText(StringUtil.replace((String)packageName, (String)"-", (String)""));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/initializr/SpringInitializrApplicationInfoStep$1", "textChanged"));
            }
        };
        this.myGroupField.getDocument().addDocumentListener((DocumentListener)updatePackageNameAdapter);
        this.myArtifactField = formBuilder.addTextField(SpringBootApiBundle.message((String)"title.label.mnemonic.artifact", (Object[])new Object[0]), options.artifact);
        this.myArtifactField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                SpringInitializrApplicationInfoStep.this.myNameField.setText(SpringInitializrApplicationInfoStep.this.myArtifactField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/boot/initializr/SpringInitializrApplicationInfoStep$2", "textChanged"));
            }
        });
        this.myArtifactField.getDocument().addDocumentListener((DocumentListener)updatePackageNameAdapter);
        formBuilder.addVerticalSpacing();
        String typeLabel = SpringBootApiBundle.message((String)"title.label.mnemonic.type", (Object[])new Object[0]);
        if (options.canShowTypeChoiceAsRadioButton) {
            panelsWithRadioButtons.add(formBuilder.addRadioButtonsGroup(typeLabel, options.type));
        } else {
            formBuilder.addComboBox(typeLabel, options.type, true);
        }
        panelsWithRadioButtons.add(formBuilder.addRadioButtonsGroup(SpringBootApiBundle.message((String)"title.label.mnemonic.language", (Object[])new Object[0]), options.language));
        formBuilder.addVerticalSpacing();
        panelsWithRadioButtons.add(formBuilder.addRadioButtonsGroup(SpringBootApiBundle.message((String)"title.label.mnemonic.packaging", (Object[])new Object[0]), options.packaging));
        formBuilder.addComboBox(SpringBootApiBundle.message((String)"title.label.mnemonic.java.version", (Object[])new Object[0]), options.javaVersion);
        formBuilder.addVerticalSpacing();
        this.myVersionField = formBuilder.addTextField(SpringBootApiBundle.message((String)"title.label.mnemonic.version", (Object[])new Object[0]), options.version);
        this.myNameField = formBuilder.addTextField(SpringBootApiBundle.message((String)"title.label.mnemonic.name", (Object[])new Object[0]), options.name);
        this.myDescriptionField = formBuilder.addTextField(SpringBootApiBundle.message((String)"title.label.mnemonic.description", (Object[])new Object[0]), options.description);
        this.myPackageNameField = formBuilder.addTextField(SpringBootApiBundle.message((String)"title.label.mnemonic.package", (Object[])new Object[0]), options.packageName);
        SpringInitializrApplicationInfoStep.equalizeAllInnerComponentsWidthByIndex(panelsWithRadioButtons);
        this.registerTextComponentValidation((JTextField)this.myNameField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY});
        this.registerTextComponentValidation((JTextField)this.myGroupField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY, StartersValidationUtils.CHECK_NO_WHITESPACES, StartersValidationUtils.CHECK_NO_RESERVED_WORDS});
        this.registerTextComponentValidation((JTextField)this.myArtifactField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY, StartersValidationUtils.CHECK_NO_WHITESPACES, StartersValidationUtils.CHECK_NO_RESERVED_WORDS, fieldText -> this.validateSanitizedField()});
        this.registerTextComponentValidation((JTextField)this.myVersionField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY, StartersValidationUtils.CHECK_SIMPLE_NAME_FORMAT});
        this.registerTextComponentValidation((JTextField)this.myPackageNameField, new StartersValidationUtils.ValidationUnit[]{StartersValidationUtils.CHECK_NOT_EMPTY, StartersValidationUtils.CHECK_NO_WHITESPACES, StartersValidationUtils.CHECK_NO_RESERVED_WORDS, StartersValidationUtils.CHECK_PACKAGE_NAME});
    }

    protected void setInitialFocus(JBLoadingPanel settingsPanel) {
        this.myGroupField.selectAll();
        IdeFocusManager.findInstanceByComponent((Component)settingsPanel).requestFocus((Component)this.myGroupField, true);
    }

    public void updateDataModel() {
        super.updateDataModel();
        SpringInitializrOptions options = (SpringInitializrOptions)this.myBuilder.getOptions();
        options.name = this.myNameField.getText();
        options.group = this.myGroupField.getText();
        options.artifact = this.myArtifactField.getText();
        options.version = this.myVersionField.getText();
        options.description = this.myDescriptionField.getText();
        options.packageName = this.myPackageNameField.getText();
    }
}

