/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.util.List;
import java.util.UUID;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.remote.internal.Connection;
import org.gradle.launcher.daemon.client.DaemonClientConnection;
import org.gradle.launcher.daemon.client.DaemonConnector;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Finished;
import org.gradle.launcher.daemon.protocol.InvalidateVirtualFileSystem;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.Result;
import org.gradle.launcher.daemon.registry.DaemonInfo;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyDaemonAboutChangedPathsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyDaemonAboutChangedPathsClient.class);
    private final DaemonConnector connector;
    private final IdGenerator<UUID> idGenerator;
    private final DaemonRegistry daemonRegistry;

    public NotifyDaemonAboutChangedPathsClient(DaemonConnector connector, IdGenerator<UUID> idGenerator, DaemonRegistry daemonRegistry) {
        this.connector = connector;
        this.idGenerator = idGenerator;
        this.daemonRegistry = daemonRegistry;
    }

    public void notifyDaemonsAboutChangedPaths(List<String> changedPaths) {
        for (DaemonInfo daemonInfo : this.daemonRegistry.getAll()) {
            DaemonClientConnection connection;
            DaemonStateControl.State state = daemonInfo.getState();
            if (state != DaemonStateControl.State.Idle || (connection = this.connector.maybeConnect(daemonInfo)) == null) continue;
            NotifyDaemonAboutChangedPathsClient.dispatch(connection, new InvalidateVirtualFileSystem(changedPaths, (UUID)this.idGenerator.generateId(), connection.getDaemon().getToken()));
        }
    }

    private static void dispatch(Connection<Message> connection, Command command) {
        Throwable failure = null;
        try {
            connection.dispatch((Object)command);
            Result result = (Result)connection.receive();
            if (result instanceof Failure) {
                failure = (Throwable)((Failure)result).getValue();
            }
            connection.dispatch((Object)new Finished());
        }
        catch (Throwable e) {
            failure = e;
        }
        if (failure != null) {
            throw UncheckedException.throwAsUncheckedException((Throwable)failure);
        }
    }
}

