/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.externalSystem.service.project.wizard.MavenizedStructureWizardStep;
import com.intellij.openapi.externalSystem.util.ui.DataView;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.layout.ValidationInfoBuilder;
import icons.OpenapiIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.wizards.AbstractMavenModuleBuilder;
import org.jetbrains.idea.maven.wizards.MavenWizardBundle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\b\u0010\u0014\u001a\u00020\tH\u0016J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0014J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0014J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/maven/wizards/MavenStructureWizardStep;", "Lcom/intellij/openapi/externalSystem/service/project/wizard/MavenizedStructureWizardStep;", "Lorg/jetbrains/idea/maven/project/MavenProject;", "builder", "Lorg/jetbrains/idea/maven/wizards/AbstractMavenModuleBuilder;", "context", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "(Lorg/jetbrains/idea/maven/wizards/AbstractMavenModuleBuilder;Lcom/intellij/ide/util/projectWizard/WizardContext;)V", "_init", "", "createView", "Lorg/jetbrains/idea/maven/wizards/MavenStructureWizardStep$MavenDataView;", "data", "findAllModules", "", "Lcom/intellij/openapi/module/Module;", "findAllParents", "getHelpId", "", "suggestName", "updateProjectData", "validateArtifactId", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "validateCoordinates", "validateGroupId", "validateName", "MavenDataView", "intellij.maven"})
public final class MavenStructureWizardStep
extends MavenizedStructureWizardStep<MavenProject> {
    private final AbstractMavenModuleBuilder builder;

    @NotNull
    public String getHelpId() {
        return "reference.dialogs.new.project.fromScratch.maven";
    }

    @NotNull
    public MavenDataView createView(@NotNull MavenProject data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new MavenDataView(data);
    }

    @NotNull
    public List<MavenProject> findAllParents() {
        MavenProjectsManager projectsManager;
        Project project = this.getContext().getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project ?: return emptyList()");
        Project project2 = project;
        MavenProjectsManager mavenProjectsManager = projectsManager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"projectsManager");
        List<MavenProject> list = mavenProjectsManager.getProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"projectsManager.projects");
        return list;
    }

    public void updateProjectData() {
        MavenProject mavenProject;
        this.getContext().setProjectBuilder((ProjectBuilder)this.builder);
        this.builder.setAggregatorProject((MavenProject)this.getParentData());
        this.builder.setParentProject((MavenProject)this.getParentData());
        this.builder.setProjectId(new MavenId(this.getGroupId(), this.getArtifactId(), this.getVersion()));
        MavenProject mavenProject2 = (MavenProject)this.getParentData();
        this.builder.setInheritedOptions(Intrinsics.areEqual((Object)(mavenProject2 != null && (mavenProject2 = mavenProject2.getMavenId()) != null ? mavenProject2.getGroupId() : null), (Object)this.getGroupId()), Intrinsics.areEqual((Object)((mavenProject = (MavenProject)this.getParentData()) != null && (mavenProject = mavenProject.getMavenId()) != null ? mavenProject.getVersion() : null), (Object)this.getVersion()));
        this.builder.setName(this.getEntityName());
        this.builder.setContentEntryPath(this.getLocation());
    }

    public void _init() {
        block4: {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            boolean bl3;
            boolean bl4;
            String string2;
            String string3 = this.builder.getName();
            if (string3 != null) {
                string2 = string3;
                bl4 = false;
                bl3 = false;
                String it2 = string2;
                boolean bl5 = false;
                this.setEntityName(it2);
            }
            MavenId mavenId = this.builder.getProjectId();
            if (mavenId == null) break block4;
            string2 = mavenId;
            bl4 = false;
            bl3 = false;
            String projectId = string2;
            boolean bl6 = false;
            String string4 = projectId.getGroupId();
            if (string4 != null) {
                string = string4;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl7 = false;
                String string5 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it");
                this.setGroupId(string5);
            }
            String string6 = projectId.getArtifactId();
            if (string6 != null) {
                string = string6;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl8 = false;
                String string7 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"it");
                this.setArtifactId(string7);
            }
            String string8 = projectId.getVersion();
            if (string8 != null) {
                string = string8;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl9 = false;
                String string9 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"it");
                this.setVersion(string9);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String suggestName() {
        void $this$mapTo$iv$iv;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv2;
        File projectFileDirectory = new File(this.getContext().getProjectFileDirectory());
        Iterable $this$map$iv = this.findAllModules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Module module = (Module)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = it.getName();
            collection.add(string);
        }
        Set moduleNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = this.getParentsData();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MavenProject bl = (MavenProject)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            MavenId mavenId = it.getMavenId();
            Intrinsics.checkNotNullExpressionValue((Object)mavenId, (String)"it.mavenId");
            string = mavenId.getArtifactId();
            collection.add(string);
        }
        Set artifactIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        String string2 = FileUtil.createSequentFileName((File)projectFileDirectory, (String)"untitled", (String)"", (Predicate)new Predicate<File>(moduleNames, artifactIds){
            final /* synthetic */ Set $moduleNames;
            final /* synthetic */ Set $artifactIds;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean test(File it) {
                if (it.exists()) return false;
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                if (this.$moduleNames.contains(file.getName())) return false;
                if (this.$artifactIds.contains(it.getName())) return false;
                return true;
            }
            {
                this.$moduleNames = set;
                this.$artifactIds = set2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"createSequentFileName(pr\u2026ame !in artifactIds\n    }");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected ValidationInfo validateName(@NotNull ValidationInfoBuilder $this$validateName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$validateName, (String)"$this$validateName");
        Iterable $this$map$iv = this.findAllModules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module module = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        Set moduleNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (moduleNames.contains(this.getEntityName())) {
            Object[] objectArray = new Object[2];
            String string = this.getContext().getPresentationName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.presentationName");
            objectArray[0] = StringsKt.capitalize((String)string);
            objectArray[1] = this.getEntityName();
            String string2 = MavenWizardBundle.message("maven.structure.wizard.entity.name.exists.error", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MavenWizardBundle.messag\u2026capitalize(), entityName)");
            String message = string2;
            return $this$validateName.error(message);
        }
        return this.superValidateName($this$validateName);
    }

    @Nullable
    protected ValidationInfo validateGroupId(@NotNull ValidationInfoBuilder $this$validateGroupId) {
        Intrinsics.checkNotNullParameter((Object)$this$validateGroupId, (String)"$this$validateGroupId");
        ValidationInfo validationInfo = this.validateCoordinates($this$validateGroupId);
        if (validationInfo == null) {
            validationInfo = this.superValidateGroupId($this$validateGroupId);
        }
        return validationInfo;
    }

    @Nullable
    protected ValidationInfo validateArtifactId(@NotNull ValidationInfoBuilder $this$validateArtifactId) {
        Intrinsics.checkNotNullParameter((Object)$this$validateArtifactId, (String)"$this$validateArtifactId");
        ValidationInfo validationInfo = this.validateCoordinates($this$validateArtifactId);
        if (validationInfo == null) {
            validationInfo = this.superValidateArtifactId($this$validateArtifactId);
        }
        return validationInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final ValidationInfo validateCoordinates(ValidationInfoBuilder $this$validateCoordinates) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getParentsData();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MavenProject mavenProject = (MavenProject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            MavenId mavenId = it.getMavenId();
            Intrinsics.checkNotNullExpressionValue((Object)mavenId, (String)"it.mavenId");
            String string = mavenId.getGroupId();
            MavenId mavenId2 = it.getMavenId();
            Intrinsics.checkNotNullExpressionValue((Object)mavenId2, (String)"it.mavenId");
            Pair pair = TuplesKt.to((Object)string, (Object)mavenId2.getArtifactId());
            collection.add(pair);
        }
        Set mavenIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (mavenIds.contains(TuplesKt.to((Object)this.getGroupId(), (Object)this.getArtifactId()))) {
            Object[] objectArray = new Object[2];
            String string = this.getContext().getPresentationName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.presentationName");
            objectArray[0] = StringsKt.capitalize((String)string);
            objectArray[1] = this.getGroupId() + ':' + this.getArtifactId();
            String string2 = MavenWizardBundle.message("maven.structure.wizard.entity.coordinates.already.exists.error", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MavenWizardBundle.messag\u2026, \"$groupId:$artifactId\")");
            String message = string2;
            return $this$validateCoordinates.error(message);
        }
        return null;
    }

    private final List<Module> findAllModules() {
        ModuleManager moduleManager;
        Project project = this.getContext().getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project ?: return emptyList()");
        Project project2 = project;
        ModuleManager moduleManager2 = moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager2, (String)"moduleManager");
        Object[] objectArray = moduleManager2.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"moduleManager.modules");
        return ArraysKt.toList((Object[])objectArray);
    }

    public MavenStructureWizardStep(@NotNull AbstractMavenModuleBuilder builder, @NotNull WizardContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)builder), (String)"builder");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.builder = builder;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/wizards/MavenStructureWizardStep$MavenDataView;", "Lcom/intellij/openapi/externalSystem/util/ui/DataView;", "Lorg/jetbrains/idea/maven/project/MavenProject;", "data", "(Lorg/jetbrains/idea/maven/project/MavenProject;)V", "getData", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "groupId", "", "getGroupId", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "location", "getLocation", "presentationName", "getPresentationName", "version", "getVersion", "intellij.maven"})
    public static final class MavenDataView
    extends DataView<MavenProject> {
        @NotNull
        private final String location;
        @NotNull
        private final Icon icon;
        @NotNull
        private final String presentationName;
        @NotNull
        private final String groupId;
        @NotNull
        private final String version;
        @NotNull
        private final MavenProject data;

        @NotNull
        public String getLocation() {
            return this.location;
        }

        @NotNull
        public Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public String getPresentationName() {
            return this.presentationName;
        }

        @NotNull
        public String getGroupId() {
            return this.groupId;
        }

        @NotNull
        public String getVersion() {
            return this.version;
        }

        @NotNull
        public MavenProject getData() {
            return this.data;
        }

        public MavenDataView(@NotNull MavenProject data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
            String string = this.getData().getDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.directory");
            this.location = string;
            Icon icon = OpenapiIcons.RepositoryLibraryLogo;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"OpenapiIcons.RepositoryLibraryLogo");
            this.icon = icon;
            String string2 = this.getData().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"data.displayName");
            this.presentationName = string2;
            MavenId mavenId = this.getData().getMavenId();
            Intrinsics.checkNotNullExpressionValue((Object)mavenId, (String)"data.mavenId");
            String string3 = mavenId.getGroupId();
            if (string3 == null) {
                string3 = "";
            }
            this.groupId = string3;
            MavenId mavenId2 = this.getData().getMavenId();
            Intrinsics.checkNotNullExpressionValue((Object)mavenId2, (String)"data.mavenId");
            String string4 = mavenId2.getVersion();
            if (string4 == null) {
                string4 = "";
            }
            this.version = string4;
        }
    }
}

