/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.rmi.RemoteProcessSupport;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerCMDState;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;

class MavenServerRemoteProcessSupport
extends RemoteProcessSupport<Object, MavenServer, Object> {
    private final Sdk myJdk;
    private final String myOptions;
    private final MavenDistribution myDistribution;
    private final Project myProject;
    private final Integer myDebugPort;

    MavenServerRemoteProcessSupport(@NotNull Sdk jdk, @Nullable String vmOptions, @Nullable MavenDistribution mavenDistribution, @NotNull Project project, @Nullable Integer debugPort) {
        if (jdk == null) {
            MavenServerRemoteProcessSupport.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MavenServerRemoteProcessSupport.$$$reportNull$$$0(1);
        }
        super(MavenServer.class);
        this.myJdk = jdk;
        this.myOptions = vmOptions;
        this.myDistribution = mavenDistribution;
        this.myProject = project;
        this.myDebugPort = debugPort;
    }

    protected void fireModificationCountChanged() {
    }

    protected String getName(@NotNull Object file) {
        if (file == null) {
            MavenServerRemoteProcessSupport.$$$reportNull$$$0(2);
        }
        return MavenServerManager.class.getSimpleName();
    }

    protected RunProfileState getRunProfileState(@NotNull Object target, @NotNull Object configuration, @NotNull Executor executor) {
        if (target == null) {
            MavenServerRemoteProcessSupport.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            MavenServerRemoteProcessSupport.$$$reportNull$$$0(4);
        }
        if (executor == null) {
            MavenServerRemoteProcessSupport.$$$reportNull$$$0(5);
        }
        return new MavenServerCMDState(this.myJdk, this.myOptions, this.myDistribution, this.myProject, this.myDebugPort);
    }

    protected void sendDataAfterStart(ProcessHandler handler) {
        if (handler.getProcessInput() == null) {
            return;
        }
        OutputStreamWriter writer = new OutputStreamWriter(handler.getProcessInput(), StandardCharsets.UTF_8);
        try {
            writer.write("token=" + MavenRemoteObjectWrapper.ourToken);
            writer.write(System.lineSeparator());
            writer.flush();
            MavenLog.LOG.info("Sent token to maven server");
        }
        catch (IOException e) {
            MavenLog.LOG.warn("Cannot send token to maven server", (Throwable)e);
        }
    }

    protected void onProcessTerminated(ProcessEvent event) {
        Project[] openProjects;
        if (event.getExitCode() == 0) {
            return;
        }
        for (Project p : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            ReadAction.run(() -> {
                if (p.isDisposed()) {
                    return;
                }
                MavenProjectsManager manager = MavenProjectsManager.getInstance(p);
                if (!manager.isMavenizedProject()) {
                    return;
                }
                manager.terminateImport(event.getExitCode());
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerRemoteProcessSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getRunProfileState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

