/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;

public interface MavenServerConnector
extends Disposable {
    public boolean isSettingsStillValid(MavenWorkspaceSettings var1);

    public MavenServerEmbedder createEmbedder(MavenEmbedderSettings var1) throws RemoteException;

    public MavenServerIndexer createIndexer() throws RemoteException;

    public void addDownloadListener(MavenServerDownloadListener var1);

    public void removeDownloadListener(MavenServerDownloadListener var1);

    @NotNull
    public MavenModel interpolateAndAlignModel(MavenModel var1, File var2);

    public MavenModel assembleInheritance(MavenModel var1, MavenModel var2);

    public ProfileApplicationResult applyProfiles(MavenModel var1, File var2, MavenExplicitProfiles var3, Collection<String> var4);

    public void shutdown(boolean var1);

    default public <R, E extends Exception> R perform(RemoteObjectWrapper.Retriable<R, E> r) throws E {
        try {
            return r.execute();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose();

    @NotNull
    public Sdk getJdk();

    public MavenDistribution getMavenDistribution();

    public String getVMOptions();
}

