/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class WorkBenchLoadingPanel
extends JPanel {
    private final JBLoadingPanel myLoadingPanel;
    private final MyMessagePanel myMessagePanel;
    private boolean myShowingMessagePanel;

    public WorkBenchLoadingPanel(LayoutManager manager, @NotNull Disposable parent, int startDelayMs) {
        if (parent == null) {
            WorkBenchLoadingPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myMessagePanel = new MyMessagePanel();
        this.myLoadingPanel = new JBLoadingPanel(manager, parent, startDelayMs);
        super.add((Component)this.myLoadingPanel);
    }

    public void startLoading() {
        this.resumeLoading();
        this.myLoadingPanel.startLoading();
    }

    public void stopLoading() {
        this.resumeLoading();
        this.myLoadingPanel.stopLoading();
    }

    public void setLoadingText(String text) {
        this.myLoadingPanel.setLoadingText(text);
    }

    @VisibleForTesting
    public boolean isLoading() {
        return this.myLoadingPanel.isLoading();
    }

    @VisibleForTesting
    public boolean hasError() {
        return this.myMessagePanel.isShowing();
    }

    boolean isLoadingOrHasError() {
        return this.isLoading() || this.hasError();
    }

    @Override
    public Component add(Component comp) {
        return this.myLoadingPanel.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.myLoadingPanel.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.myLoadingPanel.add(comp, constraints);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myLoadingPanel.getPreferredSize();
    }

    public void abortLoading(String message, Icon icon) {
        this.myMessagePanel.setText(message);
        this.myMessagePanel.setIcon(icon);
        if (!this.myShowingMessagePanel) {
            super.remove((Component)this.myLoadingPanel);
            super.add(this.myMessagePanel);
            this.myShowingMessagePanel = true;
        }
    }

    private void resumeLoading() {
        if (this.myShowingMessagePanel) {
            super.remove(this.myMessagePanel);
            super.add((Component)this.myLoadingPanel);
            this.myShowingMessagePanel = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/adtui/workbench/WorkBenchLoadingPanel", "<init>"));
    }

    private static class MyMessagePanel
    extends JPanel {
        private final JLabel myText = new JLabel("", 0);
        private boolean myInitialized;

        MyMessagePanel() {
            super(new BorderLayout());
            this.setOpaque(false);
            this.add(this.myText);
            this.updateTextFont();
            this.myInitialized = true;
        }

        public void setText(String text) {
            this.myText.setText(text);
        }

        public void setIcon(Icon icon) {
            this.myText.setIcon(icon);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.myInitialized) {
                this.updateTextFont();
            }
        }

        private void updateTextFont() {
            Font font = UIUtil.getLabelFont();
            this.myText.setFont(font.deriveFont(font.getStyle(), font.getSize() + 4));
            this.myText.setForeground(ColorUtil.toAlpha((Color)UIUtil.getLabelForeground(), (int)150));
        }
    }
}

