/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class SidePanel<T>
extends JPanel
implements SideModel.Listener<T> {
    private static final String SPLITTER = "SPLITTER";
    private static final String EMPTY = "EMPTY";
    private final Side mySide;
    private final JPanel myCards;
    private final CardLayout myLayout;
    private final JPanel myEmpty;
    private final Splitter mySplitter;

    SidePanel(@NotNull Side side, @NotNull SideModel<T> model2) {
        if (side == null) {
            SidePanel.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            SidePanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.mySide = side;
        this.mySplitter = new MySplitter();
        this.myEmpty = new JPanel();
        this.myLayout = new JBCardLayout();
        this.myCards = new JPanel(this.myLayout);
        this.setBorder((Border)new SideBorder(JBColor.border(), side.isLeft() ? 4 : 1));
        this.add((Component)this.myCards, "Center");
        model2.addListener(this);
    }

    @Override
    public void modelChanged(@NotNull SideModel<T> model2, @NotNull SideModel.EventType unused) {
        if (model2 == null) {
            SidePanel.$$$reportNull$$$0(2);
        }
        if (unused == null) {
            SidePanel.$$$reportNull$$$0(3);
        }
        this.myCards.removeAll();
        this.myCards.add((Component)this.mySplitter, SPLITTER);
        this.myCards.add((Component)this.myEmpty, EMPTY);
        this.addVisibleTools(model2.getVisibleTools(this.mySide));
        this.addHiddenTools(model2.getHiddenTools(this.mySide));
        this.revalidate();
        this.repaint();
    }

    private void addVisibleTools(@NotNull List<AttachedToolWindow> tools) {
        if (tools == null) {
            SidePanel.$$$reportNull$$$0(4);
        }
        this.mySplitter.setFirstComponent(null);
        this.mySplitter.setSecondComponent(null);
        this.setVisible(!tools.isEmpty());
        this.mySplitter.setEnabled(false);
        if (tools.isEmpty()) {
            this.myLayout.show(this.myCards, EMPTY);
        } else if (tools.size() == 1) {
            AttachedToolWindow tool = tools.get(0);
            this.myCards.add((Component)tool.getComponent(), tool.getToolName());
            this.myLayout.show(this.myCards, tool.getToolName());
        } else {
            AttachedToolWindow tool1 = tools.get(0);
            AttachedToolWindow tool2 = tools.get(1);
            tool1.getComponent().setVisible(true);
            tool2.getComponent().setVisible(true);
            this.mySplitter.setFirstComponent(tool1.getComponent());
            this.mySplitter.setSecondComponent(tool2.getComponent());
            this.mySplitter.setEnabled(true);
            this.myLayout.show(this.myCards, SPLITTER);
        }
    }

    private void addHiddenTools(@NotNull List<AttachedToolWindow> tools) {
        if (tools == null) {
            SidePanel.$$$reportNull$$$0(5);
        }
        tools.forEach(tool -> this.myCards.add((Component)tool.getComponent(), tool.getToolName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unused";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/workbench/SidePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "modelChanged";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addVisibleTools";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addHiddenTools";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MySplitter
    extends Splitter {
        private MySplitter() {
            super(true);
            this.setDividerWidth(9);
        }

        protected Divider createDivider() {
            Splitter.DividerImpl divider = new Splitter.DividerImpl((Splitter)this);
            divider.setBorder(IdeBorderFactory.createBorder((int)10));
            return divider;
        }
    }
}

