/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowCallback;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DetachedToolWindow<T>
implements ToolWindowCallback,
Disposable {
    private final ToolContent<T> myContent;
    private final ToolWindowEx myToolWindow;
    private AttachedToolWindow<T> myCorrespondingToolWindow;

    DetachedToolWindow(@NotNull Project project, @NotNull ToolWindowDefinition<T> definition) {
        if (project == null) {
            DetachedToolWindow.$$$reportNull$$$0(0);
        }
        if (definition == null) {
            DetachedToolWindow.$$$reportNull$$$0(1);
        }
        this(definition, ToolWindowManager.getInstance((Project)project));
    }

    private DetachedToolWindow(@NotNull ToolWindowDefinition<T> definition, @NotNull ToolWindowManager toolWindowManager) {
        if (definition == null) {
            DetachedToolWindow.$$$reportNull$$$0(2);
        }
        if (toolWindowManager == null) {
            DetachedToolWindow.$$$reportNull$$$0(3);
        }
        this.myContent = definition.getFactory().apply(this);
        this.myToolWindow = this.createToolWindow(toolWindowManager, definition);
    }

    public void show(@NotNull AttachedToolWindow<T> correspondingWindow) {
        if (correspondingWindow == null) {
            DetachedToolWindow.$$$reportNull$$$0(4);
        }
        this.updateState(correspondingWindow);
        this.myContent.setToolContext(correspondingWindow.getContext());
        this.myContent.registerCallbacks(this);
        this.myToolWindow.setAvailable(true);
        this.myToolWindow.setType(this.toToolWindowType(correspondingWindow), null);
        this.myToolWindow.setSplitMode(correspondingWindow.isSplit(), null);
        this.myToolWindow.show(null);
    }

    public void hide() {
        this.myContent.setToolContext(null);
        this.myToolWindow.setAvailable(false);
    }

    @Override
    public void restore() {
        if (this.myToolWindow.isAvailable() && !this.myToolWindow.isVisible()) {
            this.myToolWindow.show(null);
        }
    }

    @NotNull
    private ToolWindowType toToolWindowType(@NotNull AttachedToolWindow<T> attachedToolWindow) {
        if (attachedToolWindow == null) {
            DetachedToolWindow.$$$reportNull$$$0(5);
        }
        if (attachedToolWindow.isFloating()) {
            ToolWindowType toolWindowType = ToolWindowType.FLOATING;
            if (toolWindowType == null) {
                DetachedToolWindow.$$$reportNull$$$0(6);
            }
            return toolWindowType;
        }
        if (attachedToolWindow.isAutoHide()) {
            ToolWindowType toolWindowType = ToolWindowType.SLIDING;
            if (toolWindowType == null) {
                DetachedToolWindow.$$$reportNull$$$0(7);
            }
            return toolWindowType;
        }
        ToolWindowType toolWindowType = ToolWindowType.DOCKED;
        if (toolWindowType == null) {
            DetachedToolWindow.$$$reportNull$$$0(8);
        }
        return toolWindowType;
    }

    private void updateState(@NotNull AttachedToolWindow<T> correspondingWindow) {
        if (correspondingWindow == null) {
            DetachedToolWindow.$$$reportNull$$$0(9);
        }
        this.myCorrespondingToolWindow = correspondingWindow;
    }

    private ToolWindowEx createToolWindow(@NotNull ToolWindowManager toolWindowManager, @NotNull ToolWindowDefinition<T> definition) {
        String id;
        ToolWindowEx window;
        if (toolWindowManager == null) {
            DetachedToolWindow.$$$reportNull$$$0(10);
        }
        if (definition == null) {
            DetachedToolWindow.$$$reportNull$$$0(11);
        }
        if ((window = (ToolWindowEx)toolWindowManager.getToolWindow(id = definition.getTitle())) == null) {
            ToolWindowAnchor anchor = definition.getSide().isLeft() ? ToolWindowAnchor.LEFT : ToolWindowAnchor.RIGHT;
            window = (ToolWindowEx)toolWindowManager.registerToolWindow(id, false, anchor, (Disposable)this, true);
            window.setIcon(definition.getIcon());
            window.setAutoHide(false);
            this.setToolWindowContent(window);
            this.setAdditionalGearPopupActions(window);
            this.setAdditionalActions((ToolWindow)window);
        }
        return window;
    }

    private void setToolWindowContent(@NotNull ToolWindowEx toolWindow) {
        ContentManager contentManager;
        Content content;
        if (toolWindow == null) {
            DetachedToolWindow.$$$reportNull$$$0(12);
        }
        if ((content = (contentManager = toolWindow.getContentManager()).getSelectedContent()) == null) {
            content = contentManager.getFactory().createContent(this.myContent.getComponent(), null, false);
            content.setCloseable(false);
            content.setComponent(this.myContent.getComponent());
            content.setPreferredFocusableComponent(this.myContent.getFocusedComponent());
            content.setShouldDisposeContent(true);
            contentManager.addContent(content);
            contentManager.setSelectedContent(content, true);
        }
    }

    private void setAdditionalActions(@NotNull ToolWindow toolWindow) {
        List<AnAction> actionList;
        if (toolWindow == null) {
            DetachedToolWindow.$$$reportNull$$$0(13);
        }
        if (!(actionList = this.myContent.getAdditionalActions()).isEmpty()) {
            toolWindow.setTitleActions(actionList);
        }
    }

    private void setAdditionalGearPopupActions(@NotNull ToolWindowEx toolWindow) {
        if (toolWindow == null) {
            DetachedToolWindow.$$$reportNull$$$0(14);
        }
        DefaultActionGroup attachedSide = DefaultActionGroup.createPopupGroup(() -> "Attached Side");
        attachedSide.add((AnAction)new AttachToSideAction(Side.LEFT));
        attachedSide.add((AnAction)new AttachToSideAction(Side.RIGHT));
        attachedSide.add((AnAction)new DetachedAction());
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{attachedSide}));
    }

    public void dispose() {
    }

    public void updateSettingsInAttachedToolWindow() {
        this.myCorrespondingToolWindow.setAutoHide(this.myToolWindow.getType() == ToolWindowType.SLIDING);
        this.myCorrespondingToolWindow.setFloating(this.myToolWindow.getType() == ToolWindowType.FLOATING);
        this.myCorrespondingToolWindow.setSplit(this.myToolWindow.isSplitMode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowManager";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "correspondingWindow";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachedToolWindow";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/workbench/DetachedToolWindow";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/workbench/DetachedToolWindow";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toToolWindowType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toToolWindowType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindow";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindowContent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalGearPopupActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DetachedAction
    extends DumbAwareToggleAction {
        private DetachedAction() {
            super("None");
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                DetachedAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                DetachedAction.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/DetachedToolWindow$DetachedAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AttachToSideAction
    extends DumbAwareAction {
        private final Side mySide;

        private AttachToSideAction(Side side) {
            if (side == null) {
                AttachToSideAction.$$$reportNull$$$0(0);
            }
            super(side.isLeft() ? "Left" : "Right");
            this.mySide = side;
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                AttachToSideAction.$$$reportNull$$$0(1);
            }
            event.getPresentation().setEnabledAndVisible(DetachedToolWindow.this.myCorrespondingToolWindow != null);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                AttachToSideAction.$$$reportNull$$$0(2);
            }
            if (DetachedToolWindow.this.myCorrespondingToolWindow != null) {
                DetachedToolWindow.this.myToolWindow.setAvailable(false);
                DetachedToolWindow.this.updateSettingsInAttachedToolWindow();
                DetachedToolWindow.this.myCorrespondingToolWindow.setLeft(this.mySide.isLeft());
                DetachedToolWindow.this.myCorrespondingToolWindow.setPropertyAndUpdate(AttachedToolWindow.PropertyType.DETACHED, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/DetachedToolWindow$AttachToSideAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

