/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.util;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import java.awt.AWTEvent;
import java.awt.event.FocusEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

public class CausedFocusEventWrapper {
    private final Enum<?> cause;

    public CausedFocusEventWrapper(FocusEvent e) {
        this.cause = this.getCause(e);
    }

    @VisibleForTesting
    CausedFocusEventWrapper(Enum<?> cause) {
        this.cause = cause;
    }

    @Nullable
    private Enum<?> getCause(FocusEvent e) {
        Enum cause = null;
        if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
            try {
                Method getCause = FocusEvent.class.getMethod("getCause", new Class[0]);
                cause = (Enum)getCause.invoke((Object)e, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                Logger.getInstance(CausedFocusEventWrapper.class).error("Failed to get FocusEvent cause", (Throwable)ex);
            }
        }
        return cause;
    }

    public boolean isTraversal() {
        return this.cause != null && "TRAVERSAL".equals(this.cause.name());
    }

    public boolean isTraversalForward() {
        return this.cause != null && "TRAVERSAL_FORWARD".equals(this.cause.name());
    }

    public boolean isTraversalBackward() {
        return this.cause != null && "TRAVERSAL_BACKWARD".equals(this.cause.name());
    }

    public boolean isTraversalUp() {
        return this.cause != null && "TRAVERSAL_UP".equals(this.cause.name());
    }

    public boolean isTraversalDown() {
        return this.cause != null && "TRAVERSAL_DOWN".equals(this.cause.name());
    }

    public static boolean isFocusEventWithCause(AWTEvent e) {
        if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
            return e instanceof FocusEvent;
        }
        return e instanceof FocusEvent;
    }

    @Nullable
    public static CausedFocusEventWrapper newInstanceOrNull(AWTEvent e) {
        if (CausedFocusEventWrapper.isFocusEventWithCause(e)) {
            return new CausedFocusEventWrapper((FocusEvent)e);
        }
        return null;
    }
}

