/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.axis;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import org.jetbrains.annotations.NotNull;

public final class ClampedAxisComponentModel
extends AxisComponentModel
implements Updatable {
    private boolean myIsUpdating;

    private ClampedAxisComponentModel(@NotNull AxisComponentModel.BaseBuilder<ClampedAxisComponentModel> builder) {
        if (builder == null) {
            ClampedAxisComponentModel.$$$reportNull$$$0(0);
        }
        super(builder);
        this.myIsUpdating = false;
    }

    @Override
    public void update(long elapsedNs) {
        double max;
        if (this.myIsUpdating) {
            return;
        }
        this.myIsUpdating = true;
        boolean needsUpdate = false;
        double clampedMaxTarget = this.calculateClampedMaxTarget();
        double d = max = this.myFirstUpdate ? clampedMaxTarget : Updater.lerp(this.myRange.getMax(), clampedMaxTarget, 0.99f, elapsedNs, (double)((float)(clampedMaxTarget * (double)0.001f)));
        if (Double.compare(max, this.myRange.getMax()) != 0 || this.myFirstUpdate) {
            this.myRange.setMax(max);
            needsUpdate = true;
        }
        this.myFirstUpdate = false;
        if (needsUpdate) {
            this.changed(AxisComponentModel.Aspect.AXIS);
        }
        this.myIsUpdating = false;
    }

    @Override
    public void updateImmediately() {
        this.update(0L);
    }

    private double calculateClampedMaxTarget() {
        double maxTarget = this.myRange.getMax() - this.getZero();
        double rangeTarget = this.myRange.getLength();
        long majorInterval = this.myFormatter.getMajorInterval(rangeTarget);
        float majorNumTicksTarget = (float)Math.ceil(maxTarget / (double)majorInterval);
        return (double)(majorNumTicksTarget * (float)majorInterval) + this.getZero();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/adtui/model/axis/ClampedAxisComponentModel", "<init>"));
    }

    public static class Builder
    extends AxisComponentModel.BaseBuilder<ClampedAxisComponentModel> {
        public Builder(@NotNull Range range, @NotNull BaseAxisFormatter formatter) {
            if (range == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (formatter == null) {
                Builder.$$$reportNull$$$0(1);
            }
            super(range, formatter);
        }

        @Override
        @NotNull
        public ClampedAxisComponentModel build() {
            return new ClampedAxisComponentModel(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "formatter";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/model/axis/ClampedAxisComponentModel$Builder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

