/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.intellij.util.Function;
import com.intellij.util.containers.Stack;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public final class TreeWalker {
    private final Component myRoot;

    private static Stream<Component> streamFromIterator(Iterator<Component> componentIterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(componentIterator, 1297), false);
    }

    public static boolean isAncestor(@NotNull Container ancestor, @NotNull Component child) {
        if (ancestor == null) {
            TreeWalker.$$$reportNull$$$0(0);
        }
        if (child == null) {
            TreeWalker.$$$reportNull$$$0(1);
        }
        if (child == ancestor) {
            return true;
        }
        if (child.getParent() == null) {
            return false;
        }
        return TreeWalker.isAncestor(ancestor, child.getParent());
    }

    public TreeWalker(@NotNull Component root) {
        if (root == null) {
            TreeWalker.$$$reportNull$$$0(2);
        }
        this.myRoot = root;
    }

    public Stream<Component> ancestorStream() {
        return TreeWalker.streamFromIterator(new AncestorIterator(this.myRoot));
    }

    public Iterable<Component> ancestors() {
        return new Iterable<Component>(){

            @Override
            public Iterator<Component> iterator() {
                return new AncestorIterator(TreeWalker.this.myRoot);
            }
        };
    }

    public Stream<Component> descendantStream(DescendantOrder order) {
        return TreeWalker.streamFromIterator((Iterator)order.createIterator.fun((Object)this.myRoot));
    }

    public Iterable<Component> descendants(final DescendantOrder order) {
        return new Iterable<Component>(){

            @Override
            public Iterator<Component> iterator() {
                return (Iterator)order.createIterator.fun((Object)TreeWalker.this.myRoot);
            }
        };
    }

    public Stream<Component> descendantStream() {
        return this.descendantStream(DescendantOrder.BREADTH_FIRST);
    }

    public Iterable<Component> descendants() {
        return this.descendants(DescendantOrder.BREADTH_FIRST);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/TreeWalker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAncestor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class DfsDescendantIterator
    implements Iterator<Component> {
        private final Stack<Component> myDescendants = new Stack();

        public DfsDescendantIterator(Component root) {
            this.myDescendants.push((Object)root);
        }

        @Override
        public boolean hasNext() {
            return !this.myDescendants.isEmpty();
        }

        @Override
        public Component next() {
            Component c = (Component)this.myDescendants.pop();
            if (c instanceof Container) {
                for (int i = ((Container)c).getComponentCount() - 1; i >= 0; --i) {
                    Component child = ((Container)c).getComponent(i);
                    this.myDescendants.push((Object)child);
                }
            }
            return c;
        }
    }

    private static final class BfsDescendantIterator
    implements Iterator<Component> {
        private final Deque<Component> myDescendants = new ArrayDeque<Component>(10);

        public BfsDescendantIterator(Component root) {
            this.myDescendants.addLast(root);
        }

        @Override
        public boolean hasNext() {
            return !this.myDescendants.isEmpty();
        }

        @Override
        public Component next() {
            Component c = this.myDescendants.removeFirst();
            if (c instanceof Container) {
                for (Component child : ((Container)c).getComponents()) {
                    this.myDescendants.addLast(child);
                }
            }
            return c;
        }
    }

    private static final class AncestorIterator
    implements Iterator<Component> {
        Component currComponent;

        public AncestorIterator(Component root) {
            this.currComponent = root;
        }

        @Override
        public boolean hasNext() {
            return this.currComponent != null;
        }

        @Override
        public Component next() {
            Component next = this.currComponent;
            this.currComponent = this.currComponent.getParent();
            return next;
        }
    }

    public static enum DescendantOrder {
        BREADTH_FIRST((Function<Component, Iterator<Component>>)((Function)BfsDescendantIterator::new)),
        DEPTH_FIRST((Function<Component, Iterator<Component>>)((Function)DfsDescendantIterator::new));

        final Function<Component, Iterator<Component>> createIterator;

        private DescendantOrder(Function<Component, Iterator<Component>> createIterator) {
            this.createIterator = createIterator;
        }
    }
}

