/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.instructions.GapInstruction;
import com.android.tools.adtui.instructions.IconInstruction;
import com.android.tools.adtui.instructions.InstructionsRenderer;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LegendComponent
extends AnimatedComponent {
    private static final int LEGEND_VERT_MARGIN_PX = JBUI.scale((int)8);
    private static final int LEGEND_HORIZ_MARGIN_PX = JBUI.scale((int)10);
    private static final int ICON_MARGIN_PX = JBUI.scale((int)6);
    private static final Map<Icon, Icon> myCroppedIconCache = new HashMap<Icon, Icon>();
    private final int myLeftPadding;
    private final int myRightPadding;
    private final int myVerticalPadding;
    private final LegendComponentModel myModel;
    private final Map<Legend, LegendConfig> myConfigs;
    private final Map<Legend, Integer> myMinWidths;
    @NotNull
    private final Orientation myOrientation;
    @NotNull
    private final List<RenderInstruction> myInstructions;
    private final Map<Legend, String> myValuesCache;

    public LegendComponent(@NotNull LegendComponentModel model2) {
        if (model2 == null) {
            LegendComponent.$$$reportNull$$$0(0);
        }
        this(new Builder(model2));
    }

    private LegendComponent(@NotNull Builder builder) {
        if (builder == null) {
            LegendComponent.$$$reportNull$$$0(1);
        }
        this.myMinWidths = new HashMap<Legend, Integer>();
        this.myInstructions = new ArrayList<RenderInstruction>();
        this.myValuesCache = new HashMap<Legend, String>();
        this.myModel = builder.myModel;
        this.myConfigs = new HashMap<Legend, LegendConfig>();
        this.myOrientation = builder.myOrientation;
        this.myLeftPadding = builder.myLeftPadding;
        this.myRightPadding = builder.myRightPadding;
        this.myVerticalPadding = builder.myVerticalPadding;
        this.myModel.addDependency(this.myAspectObserver).onChange(LegendComponentModel.Aspect.LEGEND, this::modelChanged);
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(builder.myTextSize));
        this.modelChanged();
    }

    public void configure(@NotNull Legend legend, @NotNull LegendConfig config) {
        if (legend == null) {
            LegendComponent.$$$reportNull$$$0(2);
        }
        if (config == null) {
            LegendComponent.$$$reportNull$$$0(3);
        }
        this.myConfigs.put(legend, config);
        this.modelChanged();
    }

    @NotNull
    public LegendComponentModel getModel() {
        LegendComponentModel legendComponentModel = this.myModel;
        if (legendComponentModel == null) {
            LegendComponent.$$$reportNull$$$0(4);
        }
        return legendComponentModel;
    }

    @VisibleForTesting
    @NotNull
    List<RenderInstruction> getInstructions() {
        List<RenderInstruction> list = this.myInstructions;
        if (list == null) {
            LegendComponent.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private LegendConfig getConfig(@NotNull Legend data) {
        LegendConfig config;
        if (data == null) {
            LegendComponent.$$$reportNull$$$0(6);
        }
        if ((config = this.myConfigs.get(data)) == null) {
            config = new LegendConfig(LegendConfig.IconType.NONE, Color.RED);
            this.myConfigs.put(data, config);
        }
        LegendConfig legendConfig = config;
        if (legendConfig == null) {
            LegendComponent.$$$reportNull$$$0(7);
        }
        return legendConfig;
    }

    @Override
    public Dimension getPreferredSize() {
        InstructionsRenderer state = new InstructionsRenderer(this.myInstructions, InstructionsRenderer.HorizontalAlignment.LEFT);
        Dimension renderSize = state.getRenderSize();
        return new Dimension(renderSize.width + this.myLeftPadding + this.myRightPadding, renderSize.height + 2 * this.myVerticalPadding);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        g2d.translate(this.myLeftPadding, this.myVerticalPadding);
        InstructionsRenderer state = new InstructionsRenderer(this.myInstructions, InstructionsRenderer.HorizontalAlignment.LEFT);
        state.draw(this, g2d);
        g2d.translate(-this.myLeftPadding, -this.myVerticalPadding);
    }

    private void modelChanged() {
        if (!this.isShowing()) {
            return;
        }
        boolean valuesChanged = false;
        for (Legend legend : this.myModel.getLegends()) {
            boolean isValueCached = this.myValuesCache.containsKey(legend);
            String value = legend.getValue();
            String oldValue = this.myValuesCache.put(legend, value);
            if (isValueCached && Objects.equals(value, oldValue)) continue;
            valuesChanged = true;
        }
        int cacheSize = this.myValuesCache.size();
        this.myValuesCache.keySet().retainAll(this.myModel.getLegends());
        if (this.myValuesCache.size() != cacheSize) {
            valuesChanged = true;
        }
        if (!valuesChanged) {
            return;
        }
        Dimension prevSize = this.getPreferredSize();
        this.myInstructions.clear();
        for (Legend legend : this.myModel.getLegends()) {
            Object name = legend.getName();
            String value = legend.getValue();
            LegendConfig config = this.getConfig(legend);
            if (value == null) continue;
            if (legend != this.myModel.getLegends().get(0)) {
                if (this.myOrientation == Orientation.HORIZONTAL) {
                    this.myInstructions.add(new GapInstruction(LEGEND_HORIZ_MARGIN_PX));
                } else {
                    this.myInstructions.add(new NewRowInstruction(LEGEND_VERT_MARGIN_PX));
                }
            }
            if (config.getIconType() != LegendConfig.IconType.NONE) {
                int gapAdjust;
                RenderInstruction iconInstruction;
                if (config.getIconType() == LegendConfig.IconType.CUSTOM) {
                    assert (config.getIconGetter() != null);
                    iconInstruction = new IconInstruction(LegendComponent.cropAndCacheIcon(config.getIconGetter().apply(value)), 0, config.getColor());
                    gapAdjust = 0;
                } else {
                    iconInstruction = new LegendIconInstruction(config.getIconType(), config.getColor());
                    gapAdjust = this.myOrientation == Orientation.VERTICAL ? LegendIconInstruction.ICON_MAX_WIDTH - ((RenderInstruction)iconInstruction).getSize().width : 0;
                }
                this.myInstructions.add(iconInstruction);
                this.myInstructions.add(new GapInstruction(ICON_MARGIN_PX + gapAdjust));
            }
            if (!((String)name).isEmpty() && StringUtil.isNotEmpty((String)value)) {
                name = (String)name + ": ";
            }
            this.myInstructions.add(new TextInstruction(UIUtilities.getFontMetrics((JComponent)this, (Font)this.getFont()), (String)name));
            if (!StringUtil.isNotEmpty((String)value)) continue;
            TextInstruction valueInstruction = new TextInstruction(UIUtilities.getFontMetrics((JComponent)this, (Font)this.getFont()), value);
            this.myInstructions.add(valueInstruction);
            if (this.myOrientation == Orientation.VERTICAL) continue;
            Integer minWidth = this.myMinWidths.getOrDefault(legend, 0);
            if (valueInstruction.getSize().width < minWidth) {
                this.myInstructions.add(new GapInstruction(minWidth - valueInstruction.getSize().width));
                continue;
            }
            this.myMinWidths.put(legend, valueInstruction.getSize().width);
        }
        if (!this.getPreferredSize().equals(prevSize)) {
            this.revalidate();
        }
        this.repaint();
    }

    @VisibleForTesting
    static Icon cropAndCacheIcon(Icon icon) {
        if (!myCroppedIconCache.containsKey(icon)) {
            myCroppedIconCache.put(icon, IconUtil.cropIcon((Icon)icon, (int)LegendIconInstruction.ICON_MAX_WIDTH, (int)15));
        }
        return myCroppedIconCache.get(icon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "legend";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/LegendComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/LegendComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static final class LegendIconInstruction
    extends RenderInstruction {
        private static final int ICON_HEIGHT_PX = 15;
        private static final int LINE_THICKNESS = 3;
        private static final Dimension BOX_SIZE = new Dimension(11, 11);
        private static final Dimension BOX_BOUNDS = new Dimension(11, 15);
        private static final Dimension LINE_SIZE = new Dimension(12, 3);
        private static final Dimension LINE_BOUNDS = new Dimension(12, 15);
        private static final BasicStroke LINE_STROKE = new BasicStroke(3.0f);
        private static final BasicStroke DASH_STROKE = new BasicStroke(3.0f, 0, 2, 10.0f, new float[]{5.0f, 2.0f}, 0.0f);
        private static final BasicStroke BORDER_STROKE = new BasicStroke(1.0f);
        private static int ICON_MAX_WIDTH = Math.max(LegendIconInstruction.BOX_SIZE.width, LegendIconInstruction.LINE_SIZE.width);
        private static final Color BOX_BORDER_COLOR = new JBColor(new Color(0.0f, 0.0f, 0.0f, 0.1f), new Color(1.0f, 1.0f, 1.0f, 0.1f));
        @VisibleForTesting
        @NotNull
        final LegendConfig.IconType myType;
        @NotNull
        private final Color myColor;

        public LegendIconInstruction(@NotNull LegendConfig.IconType type, @NotNull Color color) {
            if (type == null) {
                LegendIconInstruction.$$$reportNull$$$0(0);
            }
            if (color == null) {
                LegendIconInstruction.$$$reportNull$$$0(1);
            }
            switch (type) {
                case BOX: 
                case LINE: 
                case DASHED_LINE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(type.toString());
                }
            }
            this.myType = type;
            this.myColor = color;
        }

        @Override
        @NotNull
        public Dimension getSize() {
            switch (this.myType) {
                case BOX: {
                    Dimension dimension = BOX_BOUNDS;
                    if (dimension == null) {
                        LegendIconInstruction.$$$reportNull$$$0(2);
                    }
                    return dimension;
                }
                case LINE: 
                case DASHED_LINE: {
                    Dimension dimension = LINE_BOUNDS;
                    if (dimension == null) {
                        LegendIconInstruction.$$$reportNull$$$0(3);
                    }
                    return dimension;
                }
            }
            throw new IllegalStateException(this.myType.toString());
        }

        @Override
        public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
            if (c == null) {
                LegendIconInstruction.$$$reportNull$$$0(4);
            }
            if (g2d == null) {
                LegendIconInstruction.$$$reportNull$$$0(5);
            }
            if (bounds == null) {
                LegendIconInstruction.$$$reportNull$$$0(6);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Stroke prevStroke = g2d.getStroke();
            switch (this.myType) {
                case BOX: {
                    assert (LegendIconInstruction.BOX_SIZE.width <= bounds.width);
                    assert (LegendIconInstruction.BOX_SIZE.width <= bounds.height);
                    int boxX = bounds.x;
                    int boxY = bounds.y + (bounds.height - LegendIconInstruction.BOX_SIZE.height) / 2;
                    g2d.setColor(this.myColor);
                    g2d.fillRect(boxX, boxY, LegendIconInstruction.BOX_SIZE.width, LegendIconInstruction.BOX_SIZE.height);
                    g2d.setColor(BOX_BORDER_COLOR);
                    g2d.setStroke(BORDER_STROKE);
                    g2d.drawRect(boxX, boxY, LegendIconInstruction.BOX_SIZE.width - 1, LegendIconInstruction.BOX_SIZE.height - 1);
                    break;
                }
                case LINE: 
                case DASHED_LINE: {
                    assert (LegendIconInstruction.LINE_SIZE.width <= bounds.width);
                    assert (LegendIconInstruction.LINE_SIZE.height <= bounds.height);
                    g2d.setColor(this.myColor);
                    g2d.setStroke(this.myType == LegendConfig.IconType.LINE ? LINE_STROKE : DASH_STROKE);
                    int lineX = bounds.x;
                    int lineY = bounds.y + bounds.height / 2;
                    g2d.drawLine(lineX, lineY, lineX + LegendIconInstruction.LINE_SIZE.width, lineY);
                    break;
                }
                default: {
                    throw new IllegalStateException(this.myType.toString());
                }
            }
            g2d.setStroke(prevStroke);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/LegendComponent$LegendIconInstruction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2d";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/LegendComponent$LegendIconInstruction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Builder {
        private static final int DEFAULT_PADDING_X_PX = JBUI.scale((int)1);
        private static final int DEFAULT_PADDING_Y_PX = JBUI.scale((int)5);
        private static final float DEFAULT_TEXT_SIZE = JBUI.scale((int)12);
        private final LegendComponentModel myModel;
        private int myLeftPadding;
        private int myRightPadding;
        private int myVerticalPadding;
        private float myTextSize;
        private Orientation myOrientation;

        public Builder(@NotNull LegendComponentModel model2) {
            if (model2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myLeftPadding = DEFAULT_PADDING_X_PX;
            this.myRightPadding = DEFAULT_PADDING_X_PX;
            this.myVerticalPadding = DEFAULT_PADDING_Y_PX;
            this.myTextSize = DEFAULT_TEXT_SIZE;
            this.myOrientation = Orientation.HORIZONTAL;
            this.myModel = model2;
        }

        @NotNull
        public Builder setVerticalPadding(int verticalPadding) {
            this.myVerticalPadding = verticalPadding;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder setLeftPadding(int leftPadding) {
            this.myLeftPadding = leftPadding;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setRightPadding(int rightPadding) {
            this.myRightPadding = rightPadding;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setHorizontalPadding(int padding) {
            this.setLeftPadding(padding);
            this.setRightPadding(padding);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setTextSize(int size) {
            this.myTextSize = size;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder setOrientation(@NotNull Orientation orientation) {
            if (orientation == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myOrientation = orientation;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public LegendComponent build() {
            return new LegendComponent(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/LegendComponent$Builder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orientation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/LegendComponent$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setVerticalPadding";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLeftPadding";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRightPadding";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setHorizontalPadding";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTextSize";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setOrientation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setOrientation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

